/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container.behavior;

import com.mcmoddev.golems.container.behavior.GolemBehavior;
import com.mcmoddev.golems.container.behavior.parameter.BehaviorParameter;
import com.mcmoddev.golems.container.behavior.parameter.FireBehaviorParameter;
import com.mcmoddev.golems.container.behavior.parameter.MobEffectBehaviorParameter;
import com.mcmoddev.golems.container.behavior.parameter.SummonEntityBehaviorParameter;
import com.mcmoddev.golems.entity.GolemBase;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

@Immutable
public class OnHurtTargetBehavior
extends GolemBehavior {
    protected final Optional<FireBehaviorParameter> fire;
    protected final Optional<MobEffectBehaviorParameter> effect;
    protected final Optional<SummonEntityBehaviorParameter> summon;

    public OnHurtTargetBehavior(CompoundTag tag) {
        super(tag);
        this.fire = tag.m_128441_("fire") ? Optional.of(new FireBehaviorParameter(tag.m_128469_("fire"))) : Optional.empty();
        this.effect = tag.m_128441_("effect") ? Optional.of(new MobEffectBehaviorParameter(tag.m_128469_("effect"))) : Optional.empty();
        this.summon = tag.m_128441_("summon") ? Optional.of(new SummonEntityBehaviorParameter(tag.m_128469_("summon"))) : Optional.empty();
    }

    @Override
    public void onHurtTarget(GolemBase entity, Entity target) {
        if (!entity.m_6162_()) {
            this.fire.ifPresent(p -> p.apply(entity, target));
            if (target instanceof LivingEntity) {
                this.effect.ifPresent(p -> p.apply(entity, (LivingEntity)target));
            }
            this.summon.ifPresent(p -> p.apply(entity, target));
        }
    }

    @Override
    public void onAddDescriptions(List<Component> list) {
        this.fire.ifPresent(p -> {
            if (p.getTarget() == BehaviorParameter.Target.ENEMY && !list.contains(FIRE_DESC)) {
                list.add((Component)FIRE_DESC);
            }
        });
        this.effect.ifPresent(p -> {
            if (p.getTarget() == BehaviorParameter.Target.SELF && !list.contains(EFFECTS_SELF_DESC)) {
                list.add((Component)EFFECTS_SELF_DESC);
            } else if (p.getTarget() == BehaviorParameter.Target.ENEMY && !list.contains(EFFECTS_ENEMY_DESC)) {
                list.add((Component)EFFECTS_ENEMY_DESC);
            }
        });
        this.summon.ifPresent(p -> {
            if (!list.contains(p.getDescription())) {
                list.add(p.getDescription());
            }
        });
    }
}

