/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container.behavior;

import com.mcmoddev.golems.container.behavior.GolemBehavior;
import com.mcmoddev.golems.container.behavior.parameter.BehaviorParameter;
import com.mcmoddev.golems.container.behavior.parameter.MobEffectBehaviorParameter;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.entity.goal.PassiveEffectsGoal;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.goal.Goal;

@Immutable
public class PassiveEffectBehavior
extends GolemBehavior {
    protected final boolean nightOnly;
    protected final Optional<MobEffectBehaviorParameter> effect;

    public PassiveEffectBehavior(CompoundTag tag) {
        super(tag);
        this.nightOnly = tag.m_128471_("night_only");
        this.effect = tag.m_128441_("effect") ? Optional.of(new MobEffectBehaviorParameter(tag.m_128469_("effect"))) : Optional.empty();
    }

    @Override
    public void onRegisterGoals(GolemBase entity) {
        this.effect.ifPresent(e -> entity.f_21345_.m_25352_(4, (Goal)new PassiveEffectsGoal(entity, e.getEffects(), this.nightOnly, e.getTarget() == BehaviorParameter.Target.SELF, (float)e.getChance())));
    }

    @Override
    public void onAddDescriptions(List<Component> list) {
        this.effect.ifPresent(p -> {
            if (p.getTarget() == BehaviorParameter.Target.SELF && !list.contains(EFFECTS_SELF_DESC)) {
                list.add((Component)EFFECTS_SELF_DESC);
            } else if (p.getTarget() == BehaviorParameter.Target.ENEMY && !list.contains(EFFECTS_ENEMY_DESC)) {
                list.add((Component)EFFECTS_ENEMY_DESC);
            }
        });
    }
}

