/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container.behavior;

import com.mcmoddev.golems.container.behavior.GolemBehavior;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.entity.goal.RandomTeleportGoal;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

@Immutable
public class TeleportBehavior
extends GolemBehavior {
    protected final double range;
    protected final double chanceOnIdle;
    protected final double chanceOnHurt;
    protected final double chanceOnTarget;

    public TeleportBehavior(CompoundTag tag) {
        super(tag);
        this.range = tag.m_128459_("range");
        this.chanceOnIdle = tag.m_128459_("chance_on_idle");
        this.chanceOnHurt = tag.m_128459_("chance_on_hurt");
        this.chanceOnTarget = tag.m_128459_("chance_on_target");
    }

    @Override
    public void onRegisterGoals(GolemBase entity) {
        entity.f_21345_.m_25352_(1, new RandomTeleportGoal<GolemBase>(entity, this.range, this.chanceOnIdle, this.chanceOnTarget));
    }

    @Override
    public void onActuallyHurt(GolemBase entity, DamageSource source, float amount) {
        block4: {
            block3: {
                if (!(source instanceof IndirectEntityDamageSource)) break block3;
                if (source.m_7639_() instanceof LivingEntity) {
                    LivingEntity target = (LivingEntity)source.m_7639_();
                    entity.m_6703_(target);
                    entity.m_6710_(target);
                }
                for (int i = 0; i < 16; ++i) {
                    if (!entity.teleportRandomly((Mob)entity, this.range)) continue;
                    return;
                }
                break block4;
            }
            if (!(entity.m_21187_().nextDouble() < this.chanceOnHurt || entity.m_5448_() == null && entity.m_21187_().nextBoolean()) && (!entity.getContainer().getAttributes().isHurtByWater() || source != DamageSource.f_19312_)) break block4;
            for (int i = 0; i < 16; ++i) {
                if (!entity.teleportRandomly((Mob)entity, this.range)) continue;
                return;
            }
        }
    }

    @Override
    public void onAddDescriptions(List<Component> list) {
        list.add((Component)new TranslatableComponent("entitytip.teleport").m_130940_(ChatFormatting.LIGHT_PURPLE));
    }
}

