/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container.behavior;

import com.mcmoddev.golems.container.behavior.GolemBehavior;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.entity.goal.InertGoal;
import com.mcmoddev.golems.entity.goal.LookAtWhenActiveGoal;
import com.mcmoddev.golems.entity.goal.LookRandomlyWhenActiveGoal;
import com.mcmoddev.golems.entity.goal.UseFuelGoal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;

@Immutable
public class UseFuelBehavior
extends GolemBehavior {
    protected final int maxFuel;
    protected final int interval;

    public UseFuelBehavior(CompoundTag tag) {
        super(tag);
        this.maxFuel = tag.m_128451_("max_fuel");
        this.interval = tag.m_128451_("burn_interval");
    }

    public int getMaxFuel() {
        return this.maxFuel;
    }

    public int getInterval() {
        return this.interval;
    }

    @Override
    public void onRegisterGoals(GolemBase entity) {
        UseFuelBehavior.removeGoal(entity, LookAtPlayerGoal.class);
        UseFuelBehavior.removeGoal(entity, RandomLookAroundGoal.class);
        entity.f_21345_.m_25352_(0, new InertGoal<GolemBase>(entity));
        entity.f_21345_.m_25352_(1, new UseFuelGoal<GolemBase>(entity, this.interval));
        entity.f_21345_.m_25352_(7, new LookAtWhenActiveGoal<GolemBase>(entity, Player.class, 6.0f));
        entity.f_21345_.m_25352_(8, new LookRandomlyWhenActiveGoal<GolemBase>(entity));
    }

    @Override
    public void onMobInteract(GolemBase entity, Player player, InteractionHand hand) {
        if (!player.m_6047_() && !player.m_21120_(hand).m_41619_()) {
            entity.consumeFuel(player, hand);
        }
    }

    @Override
    public void onWriteData(GolemBase entity, CompoundTag tag) {
        entity.saveFuel(tag);
    }

    @Override
    public void onReadData(GolemBase entity, CompoundTag tag) {
        entity.loadFuel(tag);
    }

    @Override
    public void onAddDescriptions(List<Component> list) {
        list.add((Component)new TranslatableComponent("entitytip.use_fuel").m_130940_(ChatFormatting.GRAY));
    }

    protected static boolean removeGoal(GolemBase entity, Class<? extends Goal> goalToRemove) {
        ArrayList goalsToRemove = new ArrayList();
        entity.f_21345_.f_25345_.forEach(g -> {
            if (g.m_26015_().getClass() == goalToRemove) {
                goalsToRemove.add(g.m_26015_());
            }
        });
        goalsToRemove.forEach(g -> entity.f_21345_.m_25363_(g));
        return !goalsToRemove.isEmpty();
    }
}

