/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.GolemBase;
import java.util.function.BiPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface IArrowShooter
extends RangedAttackMob,
ContainerListener {
    public static final String KEY_INVENTORY = "Items";
    public static final String KEY_SLOT = "Slot";
    public static final int INVENTORY_SIZE = 9;
    public static final BiPredicate<Container, ItemStack> PICK_UP_ARROW_PRED = (inventory, stack) -> {
        if (stack != null && !stack.m_41619_() && stack.m_41720_() instanceof ArrowItem) {
            int l = inventory.m_6643_();
            for (int i = 0; i < l; ++i) {
                ItemStack invStack = inventory.m_8020_(i);
                if (!invStack.m_41619_() && (invStack.m_41720_() != stack.m_41720_() || !ItemStack.m_41658_((ItemStack)invStack, (ItemStack)stack) || invStack.m_41613_() + stack.m_41613_() > invStack.m_41741_())) continue;
                return true;
            }
        }
        return false;
    };

    public double getArrowDamage();

    public int getArrowsInInventory();

    public void setArrowsInInventory(int var1);

    public void initArrowInventory();

    public SimpleContainer getArrowInventory();

    public RangedAttackGoal getRangedGoal();

    public MeleeAttackGoal getMeleeGoal();

    public GolemBase getGolemEntity();

    default public void m_5757_(Container container) {
        GolemBase entity = this.getGolemEntity();
        if (!entity.f_19853_.m_5776_()) {
            entity.setArrowsInInventory(this.countArrowsInInventory());
            entity.updateCombatTask(false);
        }
    }

    default public void m_6504_(LivingEntity target, float distanceFactor) {
        GolemBase entity = this.getGolemEntity();
        ItemStack itemstack = IArrowShooter.findArrowsInInventory((Container)this.getArrowInventory());
        if (!itemstack.m_41619_()) {
            Vec3 pos = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() * 0.55f), 0.0);
            Vec3 to = target.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() * 0.5f), 0.0);
            double i = 0.0;
            double l = pos.m_82557_(to);
            double stepSize = 0.25;
            while (i * i < l) {
                Vec3 scaled = to.m_82546_(pos).m_82541_().m_82490_(i);
                double x = pos.f_82479_ + scaled.f_82479_;
                double y = pos.f_82480_ + scaled.f_82480_;
                double z = pos.f_82481_ + scaled.f_82481_;
                AABB aabb = new AABB(x - 0.2, y - 0.2, z - 0.2, x + 0.2, y + 0.2, z + 0.2);
                for (Entity e : entity.f_19853_.m_45933_((Entity)entity, aabb)) {
                    if (entity.m_6549_(e.m_6095_())) continue;
                    return;
                }
                i += stepSize;
            }
            AbstractArrow arrow = ProjectileUtil.m_37300_((LivingEntity)entity, (ItemStack)itemstack, (float)distanceFactor);
            arrow.m_6034_(entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() * 0.55f), entity.m_20189_());
            double d0 = target.m_20185_() - entity.m_20185_();
            double d1 = target.m_20227_(0.3333333333333333) - arrow.m_20186_();
            double d2 = target.m_20189_() - entity.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            arrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - entity.f_19853_.m_46791_().m_19028_() * 4));
            arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
            arrow.m_5602_((Entity)entity);
            arrow.m_36781_(this.getArrowDamage());
            entity.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (entity.m_21187_().nextFloat() * 0.4f + 0.8f));
            entity.f_19853_.m_7967_((Entity)arrow);
            itemstack.m_41774_(1);
            this.m_5757_((Container)this.getArrowInventory());
        }
    }

    default public void saveArrowInventory(CompoundTag tag) {
        ListTag listNBT = new ListTag();
        for (int i = 0; i < this.getArrowInventory().m_6643_(); ++i) {
            ItemStack stack = this.getArrowInventory().m_8020_(i);
            if (stack.m_41619_()) continue;
            CompoundTag slotNBT = new CompoundTag();
            slotNBT.m_128344_(KEY_SLOT, (byte)i);
            stack.m_41739_(slotNBT);
            listNBT.add((Object)slotNBT);
        }
        tag.m_128365_(KEY_INVENTORY, (Tag)listNBT);
    }

    default public void loadArrowInventory(CompoundTag tag) {
        ListTag list = tag.m_128437_(KEY_INVENTORY, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag slotNBT = list.m_128728_(i);
            int slotNum = slotNBT.m_128445_(KEY_SLOT) & 0xFF;
            if (slotNum < 0 || slotNum >= this.getArrowInventory().m_6643_()) continue;
            this.getArrowInventory().m_6836_(slotNum, ItemStack.m_41712_((CompoundTag)slotNBT));
        }
        this.m_5757_((Container)this.getArrowInventory());
    }

    default public void updateCombatTask(boolean forceMelee) {
        GolemBase entity = this.getGolemEntity();
        if (!entity.f_19853_.m_5776_()) {
            entity.f_21345_.m_25363_((Goal)this.getMeleeGoal());
            entity.f_21345_.m_25363_((Goal)this.getRangedGoal());
            if (forceMelee || this.getArrowsInInventory() == 0) {
                entity.f_21345_.m_25352_(0, (Goal)this.getMeleeGoal());
            } else {
                entity.f_21345_.m_25352_(0, (Goal)this.getRangedGoal());
            }
        }
    }

    public static ItemStack findArrowsInInventory(Container inv) {
        int l = inv.m_6643_();
        for (int i = 0; i < l; ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ArrowItem)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    default public void dropArrowInventory() {
        if (this.getArrowInventory() != null) {
            for (int i = 0; i < this.getArrowInventory().m_6643_(); ++i) {
                ItemStack itemstack = this.getArrowInventory().m_8020_(i);
                if (itemstack.m_41619_()) continue;
                this.getGolemEntity().m_19983_(itemstack);
            }
        }
    }

    default public int countArrowsInInventory() {
        int arrowCount = 0;
        int l = this.getArrowInventory().m_6643_();
        for (int i = 0; i < l; ++i) {
            ItemStack stack = this.getArrowInventory().m_8020_(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ArrowItem)) continue;
            arrowCount += stack.m_41613_();
        }
        return arrowCount;
    }
}

