/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.GolemBase;
import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.Vec3;

public interface IRandomExploder {
    public static final String KEY_FUSE = "Fuse";
    public static final String KEY_FUSE_LIT = "FuseLit";

    public int getFuseLen();

    public int getFuse();

    public void setFuse(int var1);

    public void setFuseLit(boolean var1);

    public boolean isFuseLit();

    public GolemBase getGolemEntity();

    default public void resetFuse() {
        this.setFuse(this.getFuseLen());
    }

    default public void lightFuse() {
        if (!this.isFuseLit() && !this.getGolemEntity().m_20070_()) {
            this.resetFuse();
            this.setFuseLit(true);
            this.getGolemEntity().m_5496_(SoundEvents.f_11837_, 0.9f, this.getGolemEntity().m_21187_().nextFloat());
        }
    }

    default public void saveFuse(CompoundTag tag) {
        tag.m_128405_(KEY_FUSE, this.getFuse());
        tag.m_128379_(KEY_FUSE_LIT, this.isFuseLit());
    }

    default public void loadFuse(CompoundTag tag) {
        this.setFuse(tag.m_128451_(KEY_FUSE));
        this.setFuseLit(tag.m_128471_(KEY_FUSE_LIT));
    }

    default public float getFusePercentage() {
        return (float)this.getFuse() / (float)this.getFuseLen();
    }

    default public void resetFuseLit() {
        this.setFuseLit(false);
        this.resetFuse();
    }

    default public void explode(float range) {
        GolemBase entity = this.getGolemEntity();
        if (!entity.f_19853_.m_5776_()) {
            boolean flag = entity.f_19853_.m_46469_().m_46207_(GameRules.f_46132_);
            Vec3 pos = entity.m_20182_();
            entity.f_19853_.m_46511_((Entity)entity, pos.f_82479_, pos.f_82480_, pos.f_82481_, range, flag ? Explosion.BlockInteraction.BREAK : Explosion.BlockInteraction.NONE);
            entity.m_146870_();
            this.spawnLingeringCloud();
        }
    }

    default public void spawnLingeringCloud() {
        GolemBase entity = this.getGolemEntity();
        Collection collection = entity.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            areaeffectcloud.m_19712_(2.5f);
            areaeffectcloud.m_19732_(-0.5f);
            areaeffectcloud.m_19740_(10);
            areaeffectcloud.m_19734_(areaeffectcloud.m_19748_() / 2);
            areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
            for (MobEffectInstance mobeffectinstance : collection) {
                areaeffectcloud.m_19716_(new MobEffectInstance(mobeffectinstance));
            }
            entity.f_19853_.m_7967_((Entity)areaeffectcloud);
        }
    }
}

