/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity.goal;

import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.event.AoeFunction;
import com.mcmoddev.golems.event.GolemModifyBlocksEvent;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class AoeBlocksGoal
extends Goal {
    protected final GolemBase entity;
    protected final int range;
    protected final int interval;
    protected final boolean sphere;
    protected final AoeFunction modifyFunction;
    protected int cooldown;

    public AoeBlocksGoal(GolemBase golemIn, int rangeIn, int intervalIn, boolean sphereIn, AoeFunction modifyIn) {
        this.entity = golemIn;
        this.range = rangeIn;
        this.interval = Math.max(1, intervalIn);
        this.sphere = sphereIn;
        this.modifyFunction = modifyIn;
    }

    public boolean m_8036_() {
        return !this.entity.m_6162_() && this.range > 0 && this.entity.m_21187_().nextInt(this.interval) == 0;
    }

    public void m_8056_() {
        BlockPos below = this.entity.getBlockBelow();
        GolemModifyBlocksEvent event = new GolemModifyBlocksEvent(this.entity, below, this.range, this.sphere, this.modifyFunction);
        if (!MinecraftForge.EVENT_BUS.post((Event)event) && event.getResult() != Event.Result.DENY) {
            event.getAffectedPositions().forEach(pos -> this.entity.f_19853_.m_7731_(pos, event.getFunction().map((LivingEntity)this.entity, (BlockPos)pos, this.entity.f_19853_.m_8055_(pos)), event.updateFlag));
        }
    }

    public boolean m_8045_() {
        return false;
    }

    public static class GrowFunction
    implements AoeFunction {
        private final float growChance;

        public GrowFunction(float growChanceIn) {
            this.growChance = growChanceIn;
        }

        @Override
        public BlockState map(LivingEntity entity, BlockPos pos, BlockState input) {
            CropBlock crop;
            if (input.m_60734_() instanceof CropBlock && !(crop = (CropBlock)input.m_60734_()).m_52307_(input) && entity.m_21187_().nextFloat() < this.growChance) {
                int maxAge;
                int growAge = (Integer)input.m_61143_((Property)crop.m_7959_()) + Mth.m_14072_((Random)entity.m_21187_(), (int)2, (int)5);
                if (growAge > (maxAge = crop.m_7419_())) {
                    growAge = maxAge;
                }
                return crop.m_52289_(growAge);
            }
            return input;
        }
    }

    public static class FreezeFunction
    implements AoeFunction {
        public final int iceChance = 52;
        public final int cobbleChance = 29;
        public final boolean frostedIce;

        public FreezeFunction(boolean useFrost) {
            this.frostedIce = useFrost;
        }

        @Override
        public BlockState map(LivingEntity entity, BlockPos pos, BlockState input) {
            BlockState cobbleState = Blocks.f_50652_.m_49966_();
            BlockState iceState = this.frostedIce ? Blocks.f_50449_.m_49966_() : Blocks.f_50126_.m_49966_();
            Material material = input.m_60767_();
            if (material.m_76332_()) {
                Block block = input.m_60734_();
                if (block == Blocks.f_49990_) {
                    boolean isNotPacked = this.frostedIce || entity.m_21187_().nextInt(100) < this.iceChance;
                    return isNotPacked ? iceState : Blocks.f_50354_.m_49966_();
                }
                if (block == Blocks.f_49991_) {
                    boolean isNotObsidian = entity.m_21187_().nextInt(100) < this.cobbleChance;
                    return isNotObsidian ? cobbleState : Blocks.f_50080_.m_49966_();
                }
            }
            return input;
        }
    }

    public static class DryFunction
    implements AoeFunction {
        @Override
        public BlockState map(LivingEntity entity, BlockPos pos, BlockState input) {
            if (input.m_61138_((Property)BlockStateProperties.f_61362_)) {
                return (BlockState)input.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
            }
            if (input.m_60767_() == Material.f_76305_ || input.m_60767_() == Material.f_76304_) {
                return Blocks.f_50016_.m_49966_();
            }
            return input;
        }
    }
}

