/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.render.layer;

import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.container.render.GolemRenderSettings;
import com.mcmoddev.golems.container.render.LayerRenderSettings;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.render.GolemModel;
import com.mcmoddev.golems.render.GolemRenderType;
import com.mcmoddev.golems.render.GolemRenderer;
import com.mcmoddev.golems.util.ResourcePair;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.animal.IronGolem;

public class ColoredTextureLayer<T extends GolemBase>
extends RenderLayer<T, GolemModel<T>> {
    private static final Vector3f ONE = new Vector3f(1.0f, 1.0f, 1.0f);
    private final GolemModel<T> layerModel;

    public ColoredTextureLayer(RenderLayerParent<T, GolemModel<T>> renderParent, EntityModelSet modelSet) {
        super(renderParent);
        this.layerModel = new GolemModel(modelSet.m_171103_(GolemRenderer.GOLEM_MODEL_RESOURCE));
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        GolemRenderSettings settings = ExtraGolems.GOLEM_RENDER_SETTINGS.get(((GolemBase)entity).getMaterial()).orElse(GolemRenderSettings.EMPTY);
        if (!(entity.m_20145_() || ((GolemModel)this.m_117386_()).disableLayers() || settings.getLayers().isEmpty())) {
            ((GolemModel)this.m_117386_()).m_102624_((EntityModel)this.layerModel);
            this.layerModel.m_6839_((IronGolem)entity, limbSwing, limbSwingAmount, partialTicks);
            this.layerModel.setupAnim(entity, limbSwing, limbSwingAmount, partialTicks, netHeadYaw, headPitch);
            settings.getLayers().forEach(l -> ColoredTextureLayer.renderTexture(this.layerModel, settings, l, matrixStackIn, bufferIn, packedLightIn, entity));
        }
    }

    protected static <G extends GolemBase> void renderTexture(GolemModel<G> model, GolemRenderSettings settings, LayerRenderSettings layer, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, G entity) {
        int packedLight;
        matrixStackIn.m_85836_();
        ResourcePair texture = layer.getTexture();
        int n = packedLight = layer.getLight().orElse(settings.getBaseLight().orElse(false)) != false ? 0xF000F0 : packedLightIn;
        RenderType renderType = layer.isTranslucent() ? GolemRenderType.getGolemTranslucent(texture.resource(), layer.getTemplate(), !texture.flag()) : GolemRenderType.getGolemCutout(texture.resource(), layer.getTemplate(), !texture.flag());
        VertexConsumer vertexBuilder = bufferIn.m_6299_(renderType);
        if (layer.isTranslucent()) {
            RenderSystem.m_69478_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        }
        Vector3f colors = layer.getColor().isPresent() && layer.getColor().get() >= 0 ? GolemRenderSettings.unpackColor(layer.getColor().get()) : (settings.getBaseColor().isPresent() && settings.getBaseColor().get() >= 0 ? GolemRenderSettings.unpackColor(settings.getBaseColor().get()) : ONE);
        model.setColor(colors.m_122239_(), colors.m_122260_(), colors.m_122269_());
        model.m_7695_(matrixStackIn, vertexBuilder, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (layer.isTranslucent()) {
            RenderSystem.m_69461_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        matrixStackIn.m_85849_();
    }
}

