/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.screen;

import com.mcmoddev.golems.EGRegistry;
import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.container.GolemContainer;
import com.mcmoddev.golems.screen.GolemBookEntry;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class GolemBookScreen
extends Screen {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("golems", "textures/gui/info_book.png");
    protected static final ResourceLocation CONTENTS = new ResourceLocation("golems", "textures/gui/info_book_contents.png");
    protected static final Component INTRO_TITLE = new TranslatableComponent("item.golems.info_book");
    protected static final Component INTRO_PAGE = new TranslatableComponent("golembook.intro1").m_130946_("\n").m_7220_((Component)new TranslatableComponent("golembook.intro2"));
    protected static final Component CONTENTS_TITLE = new TranslatableComponent("golembook.contents.title");
    protected static final Component BUILD_GOLEM_TITLE = new TranslatableComponent("golembook.build_golem.title");
    protected static final Component BUILD_GOLEM_PAGE = new TranslatableComponent("golembook.build_golem.howto1").m_130946_(" ").m_7220_((Component)new TranslatableComponent("golembook.build_golem.howto2")).m_130946_("\n\n").m_7220_((Component)new TranslatableComponent("golembook.build_golem.howto3", new Object[]{new TranslatableComponent("block.golems.golem_head")}));
    protected static final Component BUILD_HEAD_TITLE = new TranslatableComponent("block.golems.golem_head");
    protected static final Component BUILD_HEAD_PAGE = new TextComponent("\n\n\n\n").m_7220_((Component)new TranslatableComponent("golembook.recipe_head.recipe", new Object[]{BUILD_HEAD_TITLE, new TranslatableComponent("item.golems.golem_paper"), new TranslatableComponent("block.minecraft.pumpkin")}));
    protected static final Component BUILD_SPELL_TITLE = new TranslatableComponent("item.golems.golem_paper");
    protected static final Component BUILD_SPELL_PAGE = new TextComponent("\n\n\n\n").m_7220_((Component)new TranslatableComponent("golembook.recipe_spell.recipe", new Object[]{BUILD_SPELL_TITLE, new TranslatableComponent("item.minecraft.paper"), new TranslatableComponent("item.minecraft.feather"), new TranslatableComponent("item.minecraft.ink_sac"), new TranslatableComponent("item.minecraft.redstone")}));
    protected static final int BOOK_HEIGHT = 164;
    protected static final int BOOK_WIDTH = 256;
    protected static final int ICON_SP = 5;
    protected static final int SCR_OFFSET_Y = 16;
    protected static final int ARROW_WIDTH = 18;
    protected static final int ARROW_HEIGHT = 15;
    protected static final int SUPP_WIDTH = 100;
    protected static final int SUPP_HEIGHT = 50;
    private BlockButton buttonBlockLeft;
    private BlockButton buttonBlockRight;
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    private GolemEntryButton[] tableOfContents;
    protected int curPage;
    protected int totalPages;
    private static final List<GolemBookEntry> GOLEMS = new ArrayList<GolemBookEntry>();
    private static final List<GolemBookEntry> ALPHABETICAL = new ArrayList<GolemBookEntry>();
    private static final float GOLEM_BLOCK_SCALE = 1.6f;
    private static final int MARGIN = 12;
    private static final int NUM_PAGES_INTRO = 6;
    private static final int NUM_CONTENTS_ENTRIES = 5;
    protected static final int CONTENTS_W = 106;
    protected static final int CONTENTS_H = 110;
    protected static final int SCROLL_STARTX = 12;
    protected static final int SCROLL_STARTY = 24;
    protected static final int SCROLL_W = 12;
    protected static final int SCROLL_H = 15;
    protected static final int ENTRY_W = 88;
    protected static final int ENTRY_H = 22;
    private float currentScroll;
    private boolean isScrolling;
    protected long ticksOpen;
    private static final ItemStack[] ingredientsSpell = new ItemStack[]{new ItemStack((ItemLike)Items.f_42516_), new ItemStack((ItemLike)Items.f_42402_), new ItemStack((ItemLike)Items.f_42451_), new ItemStack((ItemLike)Items.f_42532_)};
    private static final ItemStack outputSpell = new ItemStack((ItemLike)EGRegistry.GOLEM_SPELL, 3);
    private static final ItemStack[] ingredientsHead = new ItemStack[]{new ItemStack((ItemLike)Blocks.f_50143_), new ItemStack((ItemLike)EGRegistry.GOLEM_SPELL)};
    private static final ItemStack outputHead = new ItemStack((ItemLike)EGRegistry.GOLEM_HEAD);

    public GolemBookScreen(Player playerIn, ItemStack itemIn) {
        super(EGRegistry.GOLEM_BOOK.m_41466_());
        GolemBookScreen.initGolemBookEntries();
        this.curPage = 0;
        this.totalPages = 6 + GOLEMS.size();
        this.currentScroll = 0.0f;
        this.isScrolling = false;
        this.tableOfContents = new GolemEntryButton[5];
        this.ticksOpen = 0L;
    }

    private static final void initGolemBookEntries() {
        GOLEMS.clear();
        for (Map.Entry<ResourceLocation, Optional<GolemContainer>> entry : ExtraGolems.GOLEM_CONTAINERS.getEntries()) {
            if (!entry.getValue().isPresent() || entry.getValue().get().isHidden()) continue;
            GOLEMS.add(new GolemBookEntry(entry.getKey(), entry.getValue().get()));
        }
        Collections.sort(GOLEMS, (g1, g2) -> Float.compare(g1.getAttack(), g2.getAttack()));
        ALPHABETICAL.clear();
        ALPHABETICAL.addAll(GOLEMS);
        Collections.sort(ALPHABETICAL, (g1, g2) -> g1.getGolemName().getString().compareTo(g2.getGolemName().getString()));
    }

    public void m_7856_() {
        int doneW = 98;
        int doneH = 20;
        int doneX = (this.f_96543_ - doneW) / 2;
        int doneY = 188;
        this.m_142416_((GuiEventListener)new Button(doneX, doneY, doneW, doneH, (Component)new TranslatableComponent("gui.done"), c -> this.f_96541_.m_91152_(null)));
        int arrowX = (this.f_96543_ - 256) / 2;
        int arrowY = 158;
        this.buttonPreviousPage = (NextPageButton)this.m_142416_((GuiEventListener)new NextPageButton(this, arrowX + 18, arrowY, false));
        this.buttonNextPage = (NextPageButton)this.m_142416_((GuiEventListener)new NextPageButton(this, arrowX + 256 - 36, arrowY, true));
        int blockX = (this.f_96543_ - 256) / 2 + 12 + 4;
        int blockY = 28;
        this.buttonBlockLeft = (BlockButton)this.m_142416_((GuiEventListener)new BlockButton(this, new Block[0], blockX, blockY, 1.6f));
        blockX = this.f_96543_ / 2 + 12;
        this.buttonBlockRight = (BlockButton)this.m_142416_((GuiEventListener)new BlockButton(this, new Block[0], blockX, blockY, 1.6f));
        int l = Math.min(5, ALPHABETICAL.size());
        for (int i = 0; i < l; ++i) {
            this.tableOfContents[i] = (GolemEntryButton)this.m_142416_((GuiEventListener)new GolemEntryButton(this, ALPHABETICAL.get(i), this.f_96543_ / 2 + 12, 40 + 22 * i));
        }
        this.updateButtons();
    }

    public void m_96624_() {
        super.m_96624_();
        ++this.ticksOpen;
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int bookX = (this.f_96543_ - 256) / 2;
        int bookY = 16;
        this.m_93228_(matrix, bookX, bookY, 0, 0, 256, 164);
        this.drawPageAt(matrix, bookX + 1, bookY, this.curPage, partialTicks);
        this.drawPageAt(matrix, bookX + 128 - 2, bookY, this.curPage + 1, partialTicks);
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        if (GolemBookScreen.isPageGolemEntry(this.curPage, this.totalPages) && this.buttonBlockLeft.m_5702_()) {
            this.buttonBlockLeft.m_7428_(matrix, mouseX, mouseY);
        }
        if (GolemBookScreen.isPageGolemEntry(this.curPage + 1, this.totalPages) && this.buttonBlockRight.m_5702_()) {
            this.buttonBlockRight.m_7428_(matrix, mouseX, mouseY);
        }
    }

    private void drawPageAt(PoseStack matrix, int cornerX, int cornerY, int pageNum, float partialTicks) {
        this.drawPageNum(matrix, cornerX, cornerY, pageNum + 1);
        switch (pageNum) {
            case 0: {
                Component title = INTRO_TITLE;
                Component body = INTRO_PAGE;
                this.drawBasicPage(matrix, cornerX, cornerY, title, body);
                return;
            }
            case 1: {
                Component title = CONTENTS_TITLE;
                this.drawTableOfContents(matrix, cornerX, cornerY, title);
                return;
            }
            case 2: {
                Component title = BUILD_SPELL_TITLE;
                Component body = BUILD_SPELL_PAGE;
                this.drawBasicPage(matrix, cornerX, cornerY, title, body);
                this.draw2x2Grid(matrix, cornerX + 24, cornerY + 24, ingredientsSpell, outputSpell);
                return;
            }
            case 3: {
                Component title = BUILD_HEAD_TITLE;
                Component body = BUILD_HEAD_PAGE;
                this.drawBasicPage(matrix, cornerX, cornerY, title, body);
                this.draw2x2Grid(matrix, cornerX + 24, cornerY + 24, ingredientsHead, outputHead);
                return;
            }
            case 4: {
                Component title = BUILD_GOLEM_TITLE;
                Component body = BUILD_GOLEM_PAGE;
                this.drawBasicPage(matrix, cornerX, cornerY, title, body);
                return;
            }
            case 5: {
                this.drawGolemDiagram(matrix, cornerX, cornerY);
                return;
            }
        }
        if (GolemBookScreen.isPageGolemEntry(pageNum, this.totalPages)) {
            GolemBookEntry entry = GolemBookScreen.getGolemEntryForPage(pageNum);
            this.drawGolemEntry(matrix, cornerX, cornerY, entry, partialTicks);
        }
    }

    private void drawPageNum(PoseStack matrix, int cornerX, int cornerY, int pageNum) {
        boolean isLeft = pageNum % 2 == 1;
        int numX = isLeft ? this.f_96543_ / 2 - 12 : this.f_96543_ / 2 + 12;
        int numY = cornerY + 164 - 22;
        String pageNumLeft = String.valueOf(pageNum);
        int sWidth = isLeft ? this.f_96547_.m_92895_(pageNumLeft) : 0;
        this.f_96547_.m_92883_(matrix, pageNumLeft, (float)(numX - sWidth), (float)numY, 0);
    }

    protected void drawBlock(Block blockIn, int cornerX, int cornerY, float scale) {
        Block block = blockIn != Blocks.f_50016_ ? blockIn : Blocks.f_50375_;
        float blockX = cornerX + 12 + 4;
        float blockY = cornerY + 12;
        RenderSystem.m_157191_().m_85836_();
        Lighting.m_84930_();
        RenderSystem.m_157191_().m_85841_(scale, scale, scale);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93097_);
        this.f_96542_.m_115123_(new ItemStack((ItemLike)block), (int)(blockX / scale), (int)(blockY / scale));
        RenderSystem.m_157191_().m_85849_();
    }

    private void drawGolemEntry(PoseStack matrix, int cornerX, int cornerY, GolemBookEntry entry, float partialTicks) {
        int nameX = cornerX + 48;
        int nameY = cornerY + 12;
        MutableComponent golemName = entry.getGolemName();
        this.f_96547_.m_92857_((FormattedText)golemName, nameX, nameY, 68, 0);
        int statsX = cornerX + 12;
        int statsY = nameY + 24;
        MutableComponent stats = entry.getDescriptionPage();
        this.f_96547_.m_92857_((FormattedText)stats, statsX, statsY, 104, 0);
        if (entry.hasImage()) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float scale = 0.9f;
            int imgX = cornerX + 64 - (int)(100.0f * scale / 2.0f);
            int imgY = cornerY + 164 - (int)(50.0f * scale) - 24;
            RenderSystem.m_157456_((int)0, (ResourceLocation)entry.getImageResource());
            int w = (int)(100.0f * scale);
            int h = (int)(50.0f * scale);
            GolemBookScreen.m_93133_((PoseStack)matrix, (int)imgX, (int)imgY, (float)0.0f, (float)0.0f, (int)w, (int)h, (int)w, (int)h);
        }
    }

    private void drawBasicPage(PoseStack matrix, int cornerX, int cornerY, Component title, Component body) {
        int maxWidth = 104;
        int titleX = cornerX + 12 + 4;
        int titleY = cornerY + 12;
        int sWidth = this.f_96547_.m_92895_(title.getString());
        if (sWidth > 104) {
            this.f_96547_.m_92857_((FormattedText)title, titleX, titleY, 104, 0);
        } else {
            this.f_96547_.m_92883_(matrix, title.getString(), (float)(titleX + (104 - sWidth) / 2), (float)titleY, 0);
        }
        int bodyX = titleX;
        int bodyY = titleY + 24;
        this.f_96547_.m_92857_((FormattedText)body, bodyX, bodyY, 104, 0);
    }

    private void drawTableOfContents(PoseStack matrix, int cornerX, int cornerY, Component title) {
        this.drawBasicPage(matrix, cornerX, cornerY, title, TextComponent.f_131282_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)CONTENTS);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int startX = cornerX + 12 + 1;
        int startY = cornerY + 24 - 1;
        this.m_93228_(matrix, startX, startY, 0, 0, 106, 112);
        startX = GolemBookScreen.getScrollX(this.f_96543_) - 2;
        startY = GolemBookScreen.getScrollY(this.currentScroll);
        this.m_93228_(matrix, startX, startY, this.isScrolling ? 17 : 0, 115, 12, 15);
        if (this.isScrolling) {
            GolemBookEntry[] visibleArray = GolemBookScreen.getGolemEntriesForScroll(this.currentScroll);
            int l = this.tableOfContents.length;
            for (int i = 0; i < l; ++i) {
                this.tableOfContents[i].setEntry(visibleArray[i]);
            }
        }
    }

    private void draw2x2Grid(PoseStack matrix, int startX, int startY, ItemStack[] ingredients, ItemStack result) {
        float posY;
        float posX;
        int frameWidth = 3;
        float scale = 1.0f;
        int gridW = 84;
        int gridH = 46;
        RenderSystem.m_157191_().m_85836_();
        RenderSystem.m_157191_().m_85841_(1.0f, 1.0f, 1.0f);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(matrix, startX, startY, 172, 169, 84, 46);
        Lighting.m_84930_();
        int iconW = 15;
        switch (ingredients.length) {
            case 4: {
                posX = (float)(startX + iconW) + 9.0f;
                posY = (float)(startY + iconW) + 9.0f;
                this.f_96542_.m_115123_(ingredients[3], (int)(posX / 1.0f), (int)(posY / 1.0f));
            }
            case 3: {
                posX = (float)startX + 6.0f;
                posY = (float)(startY + iconW) + 9.0f;
                this.f_96542_.m_115123_(ingredients[2], (int)(posX / 1.0f), (int)(posY / 1.0f));
            }
            case 2: {
                posX = (float)(startX + iconW) + 9.0f;
                posY = (float)startY + 6.0f;
                this.f_96542_.m_115123_(ingredients[1], (int)(posX / 1.0f), (int)(posY / 1.0f));
            }
            case 1: {
                posX = (float)startX + 6.0f;
                posY = (float)startY + 6.0f;
                this.f_96542_.m_115123_(ingredients[0], (int)(posX / 1.0f), (int)(posY / 1.0f));
            }
        }
        posX = (float)(startX + 84) - 16.0f - 6.0f;
        posY = (float)startY + 16.0f;
        this.f_96542_.m_115123_(result, (int)(posX / 1.0f), (int)(posY / 1.0f));
        RenderSystem.m_157191_().m_85849_();
    }

    private void drawGolemDiagram(PoseStack matrix, int cornerX, int cornerY) {
        Block golemBody = Blocks.f_50075_;
        Block golemHead = EGRegistry.GOLEM_HEAD;
        float scale = 2.0f;
        int blockW = (int)(8.0f * scale);
        int startX = cornerX + 32;
        int startY = cornerY + blockW;
        this.drawBlock(golemHead, startX, startY, scale);
        this.drawBlock(golemBody, startX, startY += blockW * 4, scale);
        this.drawBlock(golemBody, startX += blockW * 2, startY -= blockW * 5 / 2, scale);
        this.drawBlock(golemBody, startX -= blockW * 2, startY += blockW / 2, scale);
        this.drawBlock(golemBody, startX -= blockW * 2, startY += blockW / 2, scale);
    }

    public boolean m_7979_(double mouseX, double mouseY, int state, double lastBtnClicked, double timeSinceClick) {
        if (GolemBookScreen.isPageTableContents(this.curPage)) {
            int mouseYCentered = (int)(mouseY - 7.5);
            if (GolemBookScreen.isMouseOverScroll((int)mouseX, mouseYCentered, this.f_96543_)) {
                this.isScrolling = true;
                if (mouseYCentered < 150 && mouseYCentered >= 40) {
                    this.currentScroll = GolemBookScreen.getScrollFloat((int)(mouseY - 7.5));
                }
            } else {
                this.isScrolling = false;
            }
        }
        return super.m_7979_(mouseX, mouseY, state, lastBtnClicked, timeSinceClick);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollAmount) {
        float scrollMultiplier = 3.0f / (float)GOLEMS.size();
        this.isScrolling = true;
        this.currentScroll = GolemBookScreen.getScrollFloat(GolemBookScreen.getScrollY(this.currentScroll - (float)scrollAmount * scrollMultiplier));
        return super.m_6050_(mouseX, mouseY, scrollAmount);
    }

    public boolean m_6348_(double mouseX, double mouseY, int state) {
        this.isScrolling = false;
        return super.m_6348_(mouseX, mouseY, state);
    }

    private void updateButtons() {
        this.buttonPreviousPage.f_93624_ = this.curPage > 0;
        this.buttonNextPage.f_93624_ = this.curPage + 2 < this.totalPages;
        boolean tableContentsVisible = GolemBookScreen.isPageTableContents(this.curPage);
        for (GolemEntryButton b : this.tableOfContents) {
            b.f_93624_ = tableContentsVisible;
        }
        if (GolemBookScreen.isPageGolemEntry(this.curPage, this.totalPages)) {
            this.buttonBlockLeft.f_93624_ = true;
            this.buttonBlockLeft.updateBlocks(GolemBookScreen.getGolemEntryForPage(this.curPage).getBlocks());
        } else {
            this.buttonBlockLeft.f_93624_ = false;
        }
        if (GolemBookScreen.isPageGolemEntry(this.curPage + 1, this.totalPages)) {
            this.buttonBlockRight.f_93624_ = true;
            this.buttonBlockRight.updateBlocks(GolemBookScreen.getGolemEntryForPage(this.curPage + 1).getBlocks());
        } else {
            this.buttonBlockRight.f_93624_ = false;
        }
    }

    private static boolean isMouseOverScroll(int mouseX, int mouseY, int width) {
        int scrollStartX = GolemBookScreen.getScrollX(width);
        int scrollStartY = 40;
        return mouseX >= scrollStartX && mouseY >= scrollStartY && mouseX < scrollStartX + 12 && mouseY < scrollStartY + 110 - 7;
    }

    private static int getScrollX(int screenWidth) {
        return screenWidth / 2 + 12 + 106 - 12;
    }

    private static int getScrollY(float scroll) {
        float f = Math.max(0.0f, Math.min(1.0f, scroll));
        return 40 + (int)(f * 95.0f);
    }

    private static float getScrollFloat(int currentY) {
        int minY = 40;
        int maxY = 135;
        float f = Math.max(40, Math.min(135, currentY)) - 40;
        return f / 95.0f;
    }

    private static boolean isPageGolemEntry(int page, int totalPages) {
        return page >= 6 && page < totalPages;
    }

    private static boolean isPageTableContents(int page) {
        return page >= 0 && page < 2;
    }

    private static GolemBookEntry getGolemEntryForPage(int page) {
        return GOLEMS.get(page - 6);
    }

    private static GolemBookEntry[] getGolemEntriesForScroll(float scrollIn) {
        float scroll = Mth.m_14036_((float)scrollIn, (float)0.0f, (float)1.0f);
        int i = (int)(scroll * (float)(ALPHABETICAL.size() - 5));
        return ALPHABETICAL.subList(i, i + 5).toArray(new GolemBookEntry[5]);
    }

    protected static class GolemEntryButton
    extends Button {
        private final GolemBookScreen gui;
        private GolemBookEntry entry;

        public GolemEntryButton(GolemBookScreen guiIn, GolemBookEntry entryIn, int x, int y) {
            super(x, y, 88, 22, TextComponent.f_131282_, b -> {});
            this.gui = guiIn;
            this.entry = entryIn;
        }

        public void setEntry(GolemBookEntry toSet) {
            this.entry = toSet;
        }

        public void m_5716_(double mouseX, double mouseY) {
            int index = GOLEMS.indexOf(this.entry);
            if (index >= 0 && index <= GOLEMS.size()) {
                int page = index + 6;
                this.gui.curPage = page = Math.floorDiv(page, 2) * 2;
            }
            this.gui.updateButtons();
        }

        public void m_6303_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
                RenderSystem.m_157456_((int)0, (ResourceLocation)CONTENTS);
                this.m_93228_(matrix, this.f_93620_, this.f_93621_, 111, this.f_93622_ ? 27 : 0, 88, 22);
                int index = (int)(this.gui.ticksOpen / 30L);
                this.gui.drawBlock(this.entry.getBlock(index), this.f_93620_ - 12 - 2, this.f_93621_ - 9, 1.0f);
                matrix.m_85836_();
                MutableComponent name = this.entry.getGolemName();
                int wrap = this.f_93618_ - 20;
                float scale = 1.0f;
                int nameH = this.gui.f_96547_.m_92920_(name.getString(), wrap);
                if (nameH > this.f_93619_) {
                    scale = 0.78f;
                    nameH = (int)(scale * (float)this.gui.f_96547_.m_92920_(name.getString(), (int)((float)wrap / scale)));
                }
                int nameX = this.f_93620_ + 20;
                int nameY = this.f_93621_ + (this.f_93619_ - nameH) / 2 + 1;
                matrix.m_85841_(scale, scale, scale);
                for (FormattedCharSequence word : this.gui.f_96547_.m_92923_((FormattedText)name, (int)((float)wrap / scale))) {
                    this.gui.f_96547_.m_92877_(matrix, word, (float)nameX / scale, (float)nameY / scale, 0);
                    Objects.requireNonNull(this.gui.f_96547_);
                    nameY += 9;
                }
                matrix.m_85849_();
            }
        }
    }

    protected static class NextPageButton
    extends Button {
        protected static final int TEXTURE_STARTY = 169;
        private final GolemBookScreen gui;
        private final boolean isForward;

        public NextPageButton(GolemBookScreen guiBook, int x, int y, boolean isForwardIn) {
            super(x, y, 18, 15, TextComponent.f_131282_, b -> {});
            this.gui = guiBook;
            this.isForward = isForwardIn;
        }

        public void m_5716_(double mouseX, double mouseY) {
            this.gui.curPage = this.isForward ? (this.gui.curPage += 2) : (this.gui.curPage -= 2);
            this.gui.updateButtons();
        }

        public void m_6303_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                boolean mouseOver = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
                int tx = 0;
                int ty = 169;
                if (mouseOver) {
                    tx += 23;
                }
                if (!this.isForward) {
                    ty += 15;
                }
                this.m_93228_(matrix, this.f_93620_, this.f_93621_, tx, ty, 18, 15);
            }
        }
    }

    protected static class BlockButton
    extends Button {
        private float scale;
        private Block[] blocks;
        private Block currentBlock;
        private final GolemBookScreen gui;

        public BlockButton(GolemBookScreen guiIn, Block[] blockValues, int x, int y, float scaleIn) {
            super(x, y, (int)(scaleIn * 16.0f), (int)(scaleIn * 16.0f), TextComponent.f_131282_, b -> {}, (b, p, mx, my) -> b.m_7428_(p, mx, my));
            this.gui = guiIn;
            this.blocks = blockValues;
            this.scale = scaleIn;
        }

        public void m_6303_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                boolean bl = this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
                if (this.blocks != null && this.blocks.length > 0) {
                    int index = (int)(this.gui.ticksOpen / 30L) % this.blocks.length;
                    this.currentBlock = this.blocks[index];
                } else {
                    this.currentBlock = Blocks.f_50016_;
                }
                matrix.m_85836_();
                this.gui.drawBlock(this.currentBlock, this.f_93620_ - 12 - 4, this.f_93621_ - 12, this.scale);
                matrix.m_85849_();
            }
        }

        public void m_7428_(PoseStack matrix, int mouseX, int mouseY) {
            if (this.currentBlock != Blocks.f_50016_) {
                matrix.m_85841_(1.0f / this.scale, 1.0f / this.scale, 1.0f / this.scale);
                this.gui.m_96602_(matrix, (Component)this.currentBlock.m_49954_(), mouseX, mouseY);
            }
        }

        public void updateBlocks(Block[] blocksToDraw) {
            this.blocks = blocksToDraw;
        }
    }
}

