/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.util;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mcmoddev.golems.ExtraGolems;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fmllegacy.LogicalSidedProvider;

public class GenericJsonReloadListener<T>
extends SimpleJsonResourceReloadListener {
    private final Codec<T> codec;
    private final Consumer<GenericJsonReloadListener<T>> syncOnReload;
    private final Class<T> objClass;
    protected Map<ResourceLocation, Optional<T>> OBJECTS = new HashMap<ResourceLocation, Optional<T>>();

    public GenericJsonReloadListener(String folderIn, Class<T> oClass, Codec<T> oCodec, Consumer<GenericJsonReloadListener<T>> syncOnReloadConsumer) {
        super(new GsonBuilder().create(), folderIn);
        this.objClass = oClass;
        this.codec = oCodec;
        this.syncOnReload = syncOnReloadConsumer;
    }

    public void put(ResourceLocation id, @Nullable T obj) {
        this.OBJECTS.put(id, Optional.ofNullable(obj));
    }

    public Optional<T> get(ResourceLocation id) {
        return this.OBJECTS.getOrDefault(id, Optional.empty());
    }

    public Collection<Optional<T>> getValues() {
        return this.OBJECTS.values();
    }

    public Set<ResourceLocation> getKeys() {
        return this.OBJECTS.keySet();
    }

    public Set<Map.Entry<ResourceLocation, Optional<T>>> getEntries() {
        return this.OBJECTS.entrySet();
    }

    public DataResult<Tag> writeObject(T obj) {
        return this.codec.encodeStart((DynamicOps)NbtOps.f_128958_, obj);
    }

    public DataResult<T> jsonToObject(JsonElement json) {
        return this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
    }

    public DataResult<T> readObject(Tag nbt) {
        return this.codec.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager manager, ProfilerFiller profile) {
        this.OBJECTS.clear();
        ExtraGolems.LOGGER.info("Parsing Reloadable JSON map of type " + this.objClass.getName());
        jsons.forEach((key, input) -> this.OBJECTS.put((ResourceLocation)key, this.jsonToObject((JsonElement)input).resultOrPartial(error -> ExtraGolems.LOGGER.error("Failed to read JSON object for type" + this.objClass.getName() + "\n" + error))));
        ExtraGolems.LOGGER.info("Found " + this.OBJECTS.size() + " entries");
        boolean isServer = true;
        try {
            LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        }
        catch (Exception e) {
            isServer = false;
        }
        if (isServer) {
            this.syncOnReload.accept(this);
        }
    }

    public String m_7812_() {
        return this.objClass.getName();
    }
}

