/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;

public final class ResourcePair {
    public static final Codec<ResourcePair> CODEC = Codec.STRING.comapFlatMap(ResourcePair::read, ResourcePair::toString).stable();
    private final ResourceLocation resource;
    private final boolean flag;

    public ResourcePair(ResourceLocation resource, boolean flag) {
        this.resource = resource;
        this.flag = flag;
    }

    public ResourceLocation resource() {
        return this.resource;
    }

    public boolean flag() {
        return this.flag;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flag ? 1231 : 1237);
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourcePair other = (ResourcePair)obj;
        if (this.flag != other.flag) {
            return false;
        }
        return !(this.resource == null ? other.resource != null : !this.resource.equals((Object)other.resource));
    }

    public static DataResult<ResourcePair> read(String string) {
        try {
            boolean dyn;
            ResourceLocation res;
            if (string.length() > 0 && string.charAt(0) == '#') {
                res = new ResourceLocation(string.substring(1));
                dyn = true;
            } else {
                res = new ResourceLocation(string);
                dyn = false;
            }
            return DataResult.success((Object)new ResourcePair(res, dyn));
        }
        catch (ResourceLocationException resourcelocationexception) {
            return DataResult.error((String)("Not a valid resource location: " + string + " " + resourcelocationexception.getMessage()));
        }
    }

    public String toString() {
        return this.flag() ? "#".concat(this.resource().toString()) : this.resource().toString();
    }
}

