/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class MagmaGolem
extends GolemBase {
    public static final String ALLOW_FIRE_SPECIAL = "Allow Special: Burn Enemies";
    public static final String ALLOW_LAVA_SPECIAL = "Allow Special: Melt Cobblestone";
    public static final String ALLOW_WATER_DAMAGE = "Enable Water Damage";
    public static final String SPLITTING_CHILDREN = "Splitting Factor";
    public static final String MELT_DELAY = "Melting Delay";
    private int ticksStandingStill = 0;
    private int stillX;
    private int stillZ;
    private boolean isHurtByWater = this.getConfigBool("Enable Water Damage");
    private boolean allowFire = this.getConfigBool("Allow Special: Burn Enemies");
    private boolean allowMelting = this.getConfigBool("Allow Special: Melt Cobblestone");
    private int meltDelay = this.getConfigInt("Melting Delay");

    public MagmaGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world);
        if (this.isHurtByWater) {
            this.func_184644_a(PathNodeType.WATER, -1.0f);
        }
    }

    public boolean func_204231_K() {
        return this.isHurtByWater;
    }

    @Override
    public void func_82227_f(boolean isChild) {
        super.func_82227_f(isChild);
        if (isChild) {
            this.allowMelting = false;
            this.allowFire = false;
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (!this.func_70631_g_() && this.allowFire) {
                entity.func_70015_d(2 + this.field_70146_Z.nextInt(5));
            }
            return true;
        }
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isHurtByWater && this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 0.5f);
        }
        if (this.allowMelting && !this.func_70631_g_()) {
            BlockPos below = this.getBlockBelow();
            Block b1 = this.field_70170_p.func_180495_p(below).func_177230_c();
            if (below.func_177958_n() == this.stillX && below.func_177952_p() == this.stillZ) {
                if (++this.ticksStandingStill >= this.meltDelay && b1 == Blocks.field_150347_e && this.field_70146_Z.nextInt(16) == 0) {
                    BlockState replace = Blocks.field_196814_hQ.func_176223_P();
                    this.field_70170_p.func_180501_a(below, replace, 3);
                    this.ticksStandingStill = 0;
                }
            } else {
                this.ticksStandingStill = 0;
                this.stillX = below.func_177958_n();
                this.stillZ = below.func_177952_p();
            }
        }
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource ignored) {
        return ignored == DamageSource.field_76369_e ? SoundEvents.field_187659_cY : this.getGolemSound();
    }

    public void func_70645_a(DamageSource source) {
        int children = this.getConfigInt(SPLITTING_CHILDREN);
        if (children > 0) {
            this.trySpawnChildren(children);
        }
        super.func_70645_a(source);
    }
}

