/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.ai.PassiveEffectsGoal;
import com.mcmoddev.golems.entity.ai.PlaceBlocksGoal;
import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemMultiTextured;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public final class MushroomGolem
extends GolemMultiTextured {
    public static final String ALLOW_SPECIAL = "Allow Special: Plant Mushrooms";
    public static final String FREQUENCY = "Mushroom Frequency";
    public static final String ALLOW_HEALING = "Allow Special: Random Healing";
    public static final String[] TEXTURE_NAMES = new String[]{"red_mushroom_block", "brown_mushroom_block"};
    public static final String[] LOOT_TABLE_NAMES = new String[]{"red", "brown"};

    public MushroomGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world, "minecraft", TEXTURE_NAMES, "golems", LOOT_TABLE_NAMES);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        boolean allowed = this.getConfigBool(ALLOW_SPECIAL);
        int freq = allowed ? this.getConfigInt(FREQUENCY) : -100;
        freq += this.field_70146_Z.nextInt(Math.max(10, freq / 2));
        BlockState[] mushrooms = new BlockState[]{Blocks.field_150338_P.func_176223_P(), Blocks.field_150337_Q.func_176223_P()};
        Block[] soils = new Block[]{Blocks.field_150346_d, Blocks.field_196658_i, Blocks.field_150391_bh, Blocks.field_196661_l, Blocks.field_150424_aL, Blocks.field_150425_aM};
        this.field_70714_bg.func_75776_a(2, (Goal)new PlaceBlocksGoal((GolemBase)this, freq, mushrooms, soils, allowed));
        if (this.getConfigBool(ALLOW_HEALING)) {
            this.field_70714_bg.func_75776_a(4, (Goal)new PassiveEffectsGoal(this, Effects.field_76428_l, 50, 60, 1, 1, g -> !g.func_130014_f_().func_72935_r() && g.func_130014_f_().func_201674_k().nextInt(450) == 0));
        }
    }

    @Override
    public void onBuilt(BlockState body, BlockState legs, BlockState arm1, BlockState arm2) {
        byte textureNum = body.func_177230_c() == Blocks.field_150419_aX ? (byte)0 : 1;
        textureNum = (byte)(textureNum % this.getNumTextures());
        this.setTextureNum(textureNum);
    }

    @Override
    public ItemStack getCreativeReturn(RayTraceResult target) {
        return this.getTextureNum() == 0 ? new ItemStack((IItemProvider)Blocks.field_150419_aX) : new ItemStack((IItemProvider)Blocks.field_150420_aW);
    }

    @Override
    public Map<Block, Byte> getTextureBytes() {
        return new HashMap<Block, Byte>();
    }
}

