/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemMultiTextured;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;

public final class WoodenGolem
extends GolemMultiTextured {
    private static final Map<RegistryKey<Biome>, Integer> BIOME_TO_TEXTURE_MAP = new HashMap<RegistryKey<Biome>, Integer>();
    public static final String[] TEXTURE_NAMES = new String[]{"oak_log", "spruce_log", "birch_log", "jungle_log", "acacia_log", "dark_oak_log"};
    public static final String[] LOOT_TABLE_NAMES = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak"};

    public WoodenGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world, "minecraft", TEXTURE_NAMES, "golems", LOOT_TABLE_NAMES);
    }

    @Override
    public void onBuilt(BlockState body, BlockState legs, BlockState arm1, BlockState arm2) {
        int textureNum;
        Block b = body.func_177230_c();
        if (b.func_203417_a((ITag)BlockTags.field_203286_o)) {
            textureNum = 0;
        } else if (b.func_203417_a((ITag)BlockTags.field_203290_s)) {
            textureNum = 1;
        } else if (b.func_203417_a((ITag)BlockTags.field_203287_p)) {
            textureNum = 2;
        } else if (b.func_203417_a((ITag)BlockTags.field_203289_r)) {
            textureNum = 3;
        } else if (b.func_203417_a((ITag)BlockTags.field_203288_q)) {
            textureNum = 4;
        } else if (b.func_203417_a((ITag)BlockTags.field_203285_n)) {
            textureNum = 5;
        } else {
            this.randomizeTexture(this.field_70170_p, this.func_226270_aj_());
            return;
        }
        this.setTextureNum((byte)textureNum);
    }

    @Override
    public ItemStack getCreativeReturn(RayTraceResult target) {
        switch (this.getTextureNum()) {
            case 0: {
                return new ItemStack((IItemProvider)Blocks.field_196617_K);
            }
            case 1: {
                return new ItemStack((IItemProvider)Blocks.field_196618_L);
            }
            case 2: {
                return new ItemStack((IItemProvider)Blocks.field_196619_M);
            }
            case 3: {
                return new ItemStack((IItemProvider)Blocks.field_196620_N);
            }
            case 4: {
                return new ItemStack((IItemProvider)Blocks.field_196621_O);
            }
            case 5: {
                return new ItemStack((IItemProvider)Blocks.field_196623_P);
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void randomizeTexture(World world, BlockPos pos) {
        boolean useBiome = world.func_201674_k().nextBoolean();
        if (useBiome) {
            Optional biome = world.func_242406_i(pos);
            byte texture = (byte)WoodenGolem.getTextureForBiome(biome);
            this.setTextureNum(texture);
            return;
        }
        super.randomizeTexture(world, pos);
    }

    @Override
    public Map<Block, Byte> getTextureBytes() {
        return new HashMap<Block, Byte>();
    }

    public static int getTextureForBiome(Optional<RegistryKey<Biome>> biome) {
        if (BIOME_TO_TEXTURE_MAP.isEmpty()) {
            WoodenGolem.initLogMap();
        }
        return biome.flatMap(b -> Optional.ofNullable(BIOME_TO_TEXTURE_MAP.get(b))).orElse(0);
    }

    private static void initLogMap() {
        BIOME_TO_TEXTURE_MAP.clear();
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_150588_X, 4);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_150587_Y, 4);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_185435_ag, 4);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_185436_ah, 4);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_150583_P, 2);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_150582_Q, 2);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_185448_Z, 2);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_185429_aa, 2);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_150585_R, 5);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_185430_ab, 5);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_76782_w, 3);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_150574_L, 3);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_76792_x, 3);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_222371_ax, 3);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_222370_aw, 3);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_185446_X, 3);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_185447_Y, 3);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_76768_g, 1);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_76784_u, 1);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_150590_f, 1);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_185432_ad, 1);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_185433_ae, 1);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_150578_U, 1);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_150581_V, 1);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_76770_e, 1);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_150580_W, 1);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_185443_S, 1);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_150577_O, 1);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_76775_o, 1);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_150584_S, 1);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_150579_T, 1);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_185431_ac, 1);
        BIOME_TO_TEXTURE_MAP.put((RegistryKey<Biome>)Biomes.field_76774_n, 1);
    }
}

