/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemMultiTextured;
import com.mcmoddev.golems.util.GolemTextureBytes;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public final class WoolGolem
extends GolemMultiTextured {
    public static final String[] TEXTURE_NAMES = new String[]{"black_wool", "orange_wool", "magenta_wool", "light_blue_wool", "yellow_wool", "lime_wool", "pink_wool", "gray_wool", "light_gray_wool", "cyan_wool", "purple_wool", "blue_wool", "brown_wool", "green_wool", "red_wool", "white_wool"};
    public static final String[] LOOT_TABLE_NAMES = new String[]{"black", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "white"};

    public WoolGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world, "minecraft", TEXTURE_NAMES, "golems", LOOT_TABLE_NAMES);
    }

    @Override
    public void setTextureNum(byte toSet) {
        toSet = (byte)(toSet % (byte)(LOOT_TABLE_NAMES.length - 1));
        super.setTextureNum(toSet);
    }

    @Override
    public ItemStack getCreativeReturn(RayTraceResult target) {
        return new ItemStack((IItemProvider)GolemTextureBytes.getByByte(GolemTextureBytes.WOOL, (byte)this.getTextureNum()));
    }

    @Override
    public Map<Block, Byte> getTextureBytes() {
        return GolemTextureBytes.WOOL;
    }
}

