/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity.modded;

import com.mcmoddev.golems.entity.base.GolemBase;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.EntityPredicates;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;

public class UraniumGolem
extends GolemBase {
    public static final String ALLOW_POISON = "Allow Special: Poison Creatures";
    public static final String AOE = "Poison Area of Effect";
    public static final String DURATION = "Poison Duration";
    public static final String AMPLIFIER = "Poison Amplifier";
    protected double poisonAOEFactor;
    protected int poisonLen;
    protected int poisonAmp;
    protected boolean allowPoison;
    protected Predicate<? super Entity> CAN_POISON = EntityPredicates.field_180132_d.and(EntityPredicates.field_94557_a).and(e -> !(e instanceof UraniumGolem) && (!(e instanceof PlayerEntity) || !((PlayerEntity)e).func_184812_l_()));

    public UraniumGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world);
        this.poisonAOEFactor = this.getConfigDouble(AOE);
        this.poisonLen = this.getConfigInt(DURATION);
        this.poisonAmp = this.getConfigInt(AMPLIFIER);
        this.allowPoison = this.getConfigBool(ALLOW_POISON);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.allowPoison) {
            EffectInstance POISON_EFFECT = new EffectInstance(Effects.field_76436_u, this.poisonLen, this.poisonAmp);
            List entityList = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(this.poisonAOEFactor, this.poisonAOEFactor * 0.75, this.poisonAOEFactor), this.CAN_POISON);
            entityList.forEach(e -> {
                if (e instanceof LivingEntity) {
                    ((LivingEntity)e).func_195064_c(POISON_EFFECT);
                }
            });
        }
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (potioneffectIn.func_188419_a() == Effects.field_76436_u) {
            PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent((LivingEntity)this, potioneffectIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.func_70687_e(potioneffectIn);
    }
}

