/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.events;

import com.mcmoddev.golems.entity.base.GolemBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@Cancelable
public final class IceGolemFreezeEvent
extends Event {
    private List<BlockPos> affectedBlocks;
    private Function<BlockState, BlockState> freezeFunction;
    public final GolemBase iceGolem;
    public final BlockPos iceGolemPos;
    public final int range;
    public static final int ICE_CHANCE = 52;
    public static final int COBBLE_CHANCE = 29;
    public int updateFlag;

    public IceGolemFreezeEvent(GolemBase golem, BlockPos center, int radius, boolean frostedIce) {
        this(golem, center, radius, new DefaultFreezeFunction(golem.func_70681_au(), frostedIce, 52, 29));
    }

    public IceGolemFreezeEvent(GolemBase golem, BlockPos center, int radius, Function<BlockState, BlockState> function) {
        this.setResult(Event.Result.ALLOW);
        this.iceGolem = golem;
        this.iceGolemPos = center;
        this.range = radius;
        this.updateFlag = 3;
        this.setFunction(function, true);
    }

    public void initAffectedBlockList(int range) {
        this.affectedBlocks = new ArrayList<BlockPos>(range * range * 2 * 4);
        int maxDis = range * range;
        for (int i = -range; i <= range; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -range; k <= range; ++k) {
                    BlockState state;
                    BlockState replace;
                    BlockPos currentPos = this.iceGolemPos.func_177982_a(i, j, k);
                    if (!(this.iceGolemPos.func_177951_i((Vector3i)currentPos) <= (double)maxDis) || (replace = this.freezeFunction.apply(state = this.iceGolem.field_70170_p.func_180495_p(currentPos))) == state) continue;
                    this.affectedBlocks.add(currentPos);
                }
            }
        }
    }

    public Function<BlockState, BlockState> getFunction() {
        return this.freezeFunction;
    }

    public void setFunction(Function<BlockState, BlockState> toSet, boolean refresh) {
        this.freezeFunction = toSet;
        if (refresh) {
            this.initAffectedBlockList(this.range);
        }
    }

    public List<BlockPos> getAffectedPositions() {
        return this.affectedBlocks;
    }

    public boolean add(BlockPos pos) {
        return this.affectedBlocks.add(pos);
    }

    public boolean remove(BlockPos toRemove) {
        return this.affectedBlocks.remove(toRemove);
    }

    public static class DefaultFreezeFunction
    implements Function<BlockState, BlockState> {
        public final Random random;
        public final int iceChance;
        public final int cobbleChance;
        public final boolean frostedIce;

        public DefaultFreezeFunction(Random randomIn, boolean useFrost, int iceChanceIn, int cobbleChanceIn) {
            this.random = randomIn;
            this.frostedIce = useFrost;
            this.iceChance = iceChanceIn;
            this.cobbleChance = cobbleChanceIn;
        }

        @Override
        public BlockState apply(BlockState input) {
            BlockState cobbleState = Blocks.field_150347_e.func_176223_P();
            BlockState iceState = this.frostedIce ? Blocks.field_185778_de.func_176223_P() : Blocks.field_150432_aD.func_176223_P();
            Material material = input.func_185904_a();
            if (material.func_76224_d()) {
                Block block = input.func_177230_c();
                if (block == Blocks.field_150355_j) {
                    boolean isNotPacked = this.frostedIce || this.random.nextInt(100) < this.iceChance;
                    return isNotPacked ? iceState : Blocks.field_150403_cj.func_176223_P();
                }
                if (block == Blocks.field_150353_l) {
                    boolean isNotObsidian = this.random.nextInt(100) < this.cobbleChance;
                    return isNotObsidian ? cobbleState : Blocks.field_150343_Z.func_176223_P();
                }
            }
            return input;
        }
    }
}

