/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.integration;

import com.mcmoddev.golems_clib.ClibGolemsEntities;
import com.mcmoddev.golems_immersiveengineering.IEGolemsEntities;
import com.mcmoddev.golems_mekanism.MekanismGolemsEntities;
import com.mcmoddev.golems_quark.QuarkGolemsEntities;
import com.mcmoddev.golems_thermal.ThermalGolemsEntities;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;

public final class AddonLoader {
    public static final String QUARK_MODID = "quark";
    public static final String QUARK_GOLEMS_MODID = "golems_quark";
    public static final String THERMAL_MODID = "thermal";
    public static final String THERMAL_GOLEMS_MODID = "golems_thermal";
    public static final String MEKANISM_MODID = "mekanism";
    public static final String MEKANISM_GOLEMS_MODID = "golems_mekanism";
    public static final String IE_MODID = "immersiveengineering";
    public static final String IE_GOLEMS_MODID = "golems_ie";
    public static final String CLIB_MODID = "clib";
    public static final String CLIB_GOLEMS_MODID = "golems_clib";
    public static final String NNOW_MODID = "nnow";
    public static final String NNOW_GOLEMS_MODID = "golems_nnow";

    private AddonLoader() {
    }

    public static boolean isQuarkLoaded() {
        return ModList.get().isLoaded(QUARK_MODID);
    }

    public static boolean isThermalLoaded() {
        return ModList.get().isLoaded(THERMAL_MODID);
    }

    public static boolean isMekanismLoaded() {
        return ModList.get().isLoaded(MEKANISM_MODID);
    }

    public static boolean isIELoaded() {
        return ModList.get().isLoaded(IE_MODID);
    }

    public static boolean isClibLoaded() {
        return ModList.get().isLoaded(CLIB_MODID);
    }

    public static boolean isNNOWLoaded() {
        return ModList.get().isLoaded(NNOW_MODID);
    }

    public static void initEntityTypes() {
        if (AddonLoader.isQuarkLoaded()) {
            QuarkGolemsEntities.initEntityTypes();
        }
        if (AddonLoader.isThermalLoaded()) {
            ThermalGolemsEntities.initEntityTypes();
        }
        if (AddonLoader.isMekanismLoaded()) {
            MekanismGolemsEntities.initEntityTypes();
        }
        if (AddonLoader.isIELoaded()) {
            IEGolemsEntities.initEntityTypes();
        }
        if (AddonLoader.isClibLoaded()) {
            ClibGolemsEntities.initEntityTypes();
        }
    }

    public static void interModEnqueueEvent(InterModEnqueueEvent event) {
        if (AddonLoader.isQuarkLoaded()) {
            QuarkGolemsEntities.interModEnqueueEvent(event);
        }
        if (AddonLoader.isThermalLoaded()) {
            ThermalGolemsEntities.interModEnqueueEvent(event);
        }
        if (AddonLoader.isMekanismLoaded()) {
            MekanismGolemsEntities.interModEnqueueEvent(event);
        }
        if (AddonLoader.isIELoaded()) {
            IEGolemsEntities.interModEnqueueEvent(event);
        }
        if (AddonLoader.isClibLoaded()) {
            ClibGolemsEntities.interModEnqueueEvent(event);
        }
    }

    public static void setupEvent(FMLCommonSetupEvent event) {
        if (AddonLoader.isQuarkLoaded()) {
            QuarkGolemsEntities.setupEvent(event);
        }
        if (AddonLoader.isThermalLoaded()) {
            ThermalGolemsEntities.setupEvent(event);
        }
        if (AddonLoader.isMekanismLoaded()) {
            MekanismGolemsEntities.setupEvent(event);
        }
        if (AddonLoader.isIELoaded()) {
            IEGolemsEntities.setupEvent(event);
        }
        if (AddonLoader.isClibLoaded()) {
            ClibGolemsEntities.setupEvent(event);
        }
    }
}

