/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.integration;

import com.mcmoddev.golems.util.GolemContainer;
import com.mcmoddev.golems.util.GolemRegistrar;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class DeferredContainer {
    protected GolemContainer container;
    protected ResourceLocation[] blocks;

    public DeferredContainer(GolemContainer lContainer, String modid, String[] lBlocks) {
        this(lContainer, new ResourceLocation[lBlocks.length]);
        int l = lBlocks.length;
        for (int i = 0; i < l; ++i) {
            this.blocks[i] = new ResourceLocation(modid, lBlocks[i]);
        }
    }

    public DeferredContainer(GolemContainer lContainer, ResourceLocation[] lBlocks) {
        this.container = lContainer;
        this.blocks = lBlocks;
    }

    public GolemContainer getContainer() {
        return this.container;
    }

    public ResourceLocation[] getBlocks() {
        return this.blocks;
    }

    public void addBlocks() {
        GolemContainer cont = GolemRegistrar.getContainer(this.container.getRegistryName());
        if (null == cont) {
            return;
        }
        for (ResourceLocation r : this.blocks) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(r);
            if (block == null) continue;
            cont.addBlocks(block);
        }
    }
}

