/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.proxies;

import com.mcmoddev.golems.entity.MushroomGolem;
import com.mcmoddev.golems.entity.WoolGolem;
import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.gui.GuiDispenserGolem;
import com.mcmoddev.golems.integration.AddonLoader;
import com.mcmoddev.golems.main.GolemItems;
import com.mcmoddev.golems.proxies.ProxyCommon;
import com.mcmoddev.golems.renders.GolemRenderType;
import com.mcmoddev.golems.renders.GolemRenderer;
import com.mcmoddev.golems.renders.model.SimpleTextureLayer;
import com.mcmoddev.golems.util.GolemRegistrar;
import com.mcmoddev.golems_thermal.entity.RockwoolGolem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.entity.EntityType;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public final class ProxyClient
extends ProxyCommon {
    @Override
    public void registerListeners() {
        IResourceManager manager = Minecraft.func_71410_x().func_195551_G();
        if (manager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)manager).func_219534_a((IFutureReloadListener)new ReloadListener<ModelBakery>(){

                protected void apply(ModelBakery arg0, IResourceManager arg1, IProfiler arg2) {
                    GolemRenderType.reloadDynamicTextureMap();
                }

                protected ModelBakery prepare(IResourceManager arg0, IProfiler arg1) {
                    return null;
                }
            });
        }
    }

    @Override
    public void registerContainerRenders() {
        ScreenManager.func_216911_a(GolemItems.DISPENSER_GOLEM, GuiDispenserGolem::new);
    }

    @Override
    public void registerEntityRenders() {
        GolemRegistrar.getContainers().forEach(container -> {
            if (!container.getRenderSettings().hasCustomRender()) {
                RenderingRegistry.registerEntityRenderingHandler(container.getEntityType(), m -> new GolemRenderer(m).withAllLayers());
            }
        });
        this.registerWithSimpleLayers(GolemRegistrar.getContainer(new ResourceLocation("golems", "golem_lapis")).getEntityType(), new ResourceLocation("golems", "textures/entity/layer/gold_edging.png"));
        this.registerWithSimpleLayers(GolemRegistrar.getContainer(new ResourceLocation("golems", "golem_blackstone")).getEntityType(), new ResourceLocation("golems", "textures/entity/layer/gold_nuggets.png"));
        this.registerWoolGolemRenders();
        this.registerMushroomGolemRenders();
        if (AddonLoader.isThermalLoaded()) {
            this.registerRockwoolGolemRenders();
        }
    }

    private void registerWithSimpleLayers(EntityType<? extends GolemBase> entityType, ResourceLocation ... layers) {
        RenderingRegistry.registerEntityRenderingHandler(entityType, m -> {
            GolemRenderer r = new GolemRenderer(m);
            for (ResourceLocation l : layers) {
                r = r.withLayer(new SimpleTextureLayer(r, g -> l, g -> 0xFFFFFF, g -> false, 1.0f));
            }
            return r.withAllLayers();
        });
    }

    private void registerWoolGolemRenders() {
        RenderingRegistry.registerEntityRenderingHandler(GolemRegistrar.getContainer(new ResourceLocation("golems", "golem_wool")).getEntityType(), m -> {
            GolemRenderer<GolemBase> r = new GolemRenderer<GolemBase>(m);
            return r.withLayer(new SimpleTextureLayer<GolemBase>(r, g -> ((WoolGolem)g).getTexture(), g -> 0xFFFFFF, g -> false, 1.0f){

                @Override
                protected RenderType getRenderType(ResourceLocation texture) {
                    return GolemRenderType.getGolemCutout(texture, GolemRenderType.WOOL_TEMPLATE, true);
                }
            }).withAllLayers();
        });
    }

    private void registerMushroomGolemRenders() {
        RenderingRegistry.registerEntityRenderingHandler(GolemRegistrar.getContainer(new ResourceLocation("golems", "golem_mushroom")).getEntityType(), m -> {
            GolemRenderer<GolemBase> r = new GolemRenderer<GolemBase>(m);
            return r.withLayer(new SimpleTextureLayer<GolemBase>(r, g -> ((MushroomGolem)g).getTexture(), g -> 0xFFFFFF, g -> false, 1.0f){

                @Override
                protected RenderType getRenderType(ResourceLocation texture) {
                    return GolemRenderType.getGolemCutout(texture, GolemRenderType.MUSHROOM_TEMPLATE, true);
                }
            }).withAllLayers();
        });
    }

    private void registerRockwoolGolemRenders() {
        RenderingRegistry.registerEntityRenderingHandler(GolemRegistrar.getContainer(new ResourceLocation("golems_thermal", "golem_rockwool")).getEntityType(), m -> {
            GolemRenderer<GolemBase> r = new GolemRenderer<GolemBase>(m);
            return r.withLayer(new SimpleTextureLayer<GolemBase>(r, g -> ((RockwoolGolem)g).getTexture(), g -> 0xFFFFFF, g -> false, 1.0f){

                @Override
                protected RenderType getRenderType(ResourceLocation texture) {
                    return GolemRenderType.getGolemCutout(texture, GolemRenderType.WOOL_TEMPLATE, true);
                }
            }).withAllLayers();
        });
    }
}

