/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.util;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemMultiTextured;
import com.mcmoddev.golems.events.GolemContainerBuildEvent;
import com.mcmoddev.golems.util.GolemDescription;
import com.mcmoddev.golems.util.GolemRenderSettings;
import com.mcmoddev.golems.util.config.ExtraGolemsConfig;
import com.mcmoddev.golems.util.config.special.GolemSpecialContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.IRegistryDelegate;

public final class GolemContainer {
    private final Class<? extends GolemBase> entityClass;
    private final Set<IRegistryDelegate<Block>> validBuildingBlocks;
    private final Set<ResourceLocation> validBuildingBlockTags;
    private final EntityType<? extends GolemBase> entityType;
    private final String name;
    private final GolemRenderSettings renderSettings;
    private final SoundEvent basicSound;
    private final boolean fallDamage;
    private final boolean explosionImmunity;
    private final SwimMode swimMode;
    private final boolean canInteractChangeTexture;
    private final boolean noGolemBookEntry;
    private double health;
    private double attack;
    private final double speed;
    private final double knockbackResist;
    private final int lightLevel;
    private final int powerLevel;
    private boolean enabled = true;
    private final ImmutableMap<String, GolemSpecialContainer> specialContainers;
    private final ImmutableList<GolemDescription> descContainers;
    private final ImmutableMap<IRegistryDelegate<Item>, Double> healItemMap;

    private GolemContainer(EntityType<? extends GolemBase> lEntityType, Class<? extends GolemBase> lEntityClass, String lPath, GolemRenderSettings lRenderSettings, Set<IRegistryDelegate<Block>> lValidBuildingBlocks, Set<ResourceLocation> lValidBuildingBlockTags, double lHealth, double lAttack, double lSpeed, double lKnockbackResist, int lLightLevel, int lPowerLevel, boolean lFallDamage, boolean lExplosionImmunity, SwimMode lSwimMode, HashMap<String, GolemSpecialContainer> lSpecialContainers, List<GolemDescription> lDesc, Map<IRegistryDelegate<Item>, Double> lHealItemMap, SoundEvent lBasicSound, boolean lNoGolemBookEntry) {
        this.entityType = lEntityType;
        this.entityClass = lEntityClass;
        this.renderSettings = lRenderSettings;
        this.validBuildingBlocks = lValidBuildingBlocks;
        this.validBuildingBlockTags = lValidBuildingBlockTags;
        this.name = lPath;
        this.health = lHealth;
        this.attack = lAttack;
        this.speed = lSpeed;
        this.knockbackResist = lKnockbackResist;
        this.lightLevel = lLightLevel;
        this.powerLevel = lPowerLevel;
        this.fallDamage = lFallDamage;
        this.explosionImmunity = lExplosionImmunity;
        this.swimMode = lSwimMode;
        this.specialContainers = ImmutableMap.copyOf(lSpecialContainers);
        this.descContainers = ImmutableList.copyOf(lDesc);
        this.healItemMap = ImmutableMap.copyOf(lHealItemMap);
        this.basicSound = lBasicSound;
        this.noGolemBookEntry = lNoGolemBookEntry;
        this.canInteractChangeTexture = GolemMultiTextured.class.isAssignableFrom(lEntityClass);
    }

    public void addDescription(List<IFormattableTextComponent> list) {
        if (this.entityType.func_220338_c()) {
            list.add(new TranslationTextComponent("enchantment.minecraft.fire_protection").func_240699_a_(TextFormatting.GOLD));
        }
        if (this.explosionImmunity) {
            list.add(new TranslationTextComponent("enchantment.minecraft.blast_protection").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.BOLD}));
        }
        if (ExtraGolemsConfig.enableTextureInteract() && this.canInteractChangeTexture) {
            list.add(new TranslationTextComponent("entitytip.click_change_texture").func_240699_a_(TextFormatting.BLUE));
        }
        if (this.swimMode == SwimMode.SWIM) {
            list.add(new TranslationTextComponent("entitytip.advanced_swim").func_240699_a_(TextFormatting.AQUA));
        }
        for (GolemDescription desc : this.descContainers) {
            desc.addDescription(list, this);
        }
    }

    public boolean hasBuildingBlock() {
        return !this.validBuildingBlocks.isEmpty() || !this.validBuildingBlockTags.isEmpty();
    }

    public Set<Block> getBuildingBlocks() {
        HashSet<Block> blocks = this.validBuildingBlocks.isEmpty() ? new HashSet<Block>() : this.validBuildingBlocks.stream().map(d -> (Block)d.get()).collect(Collectors.toSet());
        for (ITag<Block> tag : GolemContainer.loadTags(this.validBuildingBlockTags)) {
            blocks.addAll(tag.func_230236_b_());
        }
        blocks.remove(Blocks.field_150350_a);
        return blocks;
    }

    public ImmutableCollection<GolemSpecialContainer> getSpecialContainers() {
        return this.specialContainers.values();
    }

    public GolemSpecialContainer getSpecialContainer(String key) {
        return (GolemSpecialContainer)this.specialContainers.get((Object)key);
    }

    public double getHealAmount(Item item) {
        Map<IRegistryDelegate<Item>, Double> map = GolemContainer.loadTagsForHealMap(this.getBuildingBlocks(), this.healItemMap);
        if (item != null && item != Items.field_190931_a && map.containsKey(item.delegate)) {
            return map.get(item.delegate);
        }
        return 0.0;
    }

    public boolean areBuildingBlocks(Block body, Block legs, Block arm1, Block arm2) {
        Set<Block> blocks = this.getBuildingBlocks();
        return blocks.contains(body) && blocks.contains(legs) && blocks.contains(arm1) && blocks.contains(arm2);
    }

    @Nullable
    public Block getPrimaryBuildingBlock() {
        Block[] blocks;
        if (this.hasBuildingBlock() && (blocks = this.getBuildingBlocks().toArray(new Block[0])) != null && blocks.length > 0) {
            return blocks[0];
        }
        return null;
    }

    public boolean addBlocks(Block ... additional) {
        return additional.length > 0 && this.validBuildingBlocks.addAll(Arrays.asList(additional).stream().map(d -> d.delegate).collect(Collectors.toList()));
    }

    public boolean addBlocks(@Nonnull ITag.INamedTag<Block> additional) {
        return this.validBuildingBlockTags.add(additional.func_230234_a_());
    }

    private static Collection<ITag<Block>> loadTags(Collection<ResourceLocation> rls) {
        HashSet<ITag<Block>> tags = new HashSet<ITag<Block>>();
        for (ResourceLocation rl : rls) {
            ITag tag;
            if (BlockTags.func_199896_a().func_199910_a(rl) == null || (tag = BlockTags.func_199896_a().func_199910_a(rl)) == null) continue;
            tags.add((ITag<Block>)tag);
        }
        return tags;
    }

    private static Map<IRegistryDelegate<Item>, Double> loadTagsForHealMap(Set<Block> set, Map<IRegistryDelegate<Item>, Double> healItems) {
        HashMap<IRegistryDelegate<Item>, Double> map = new HashMap<IRegistryDelegate<Item>, Double>(healItems);
        for (Block b : set) {
            Item ib = b.func_199767_j();
            if (ib == Items.field_190931_a || map.containsKey(ib.delegate)) continue;
            map.put((IRegistryDelegate<Item>)ib.delegate, 0.75);
        }
        return map;
    }

    public void setHealth(double pHealth) {
        this.health = pHealth;
    }

    public void setAttack(double pAttack) {
        this.attack = pAttack;
    }

    public void setEnabled(boolean pEnabled) {
        this.enabled = pEnabled;
    }

    public Class<? extends GolemBase> getEntityClass() {
        return this.entityClass;
    }

    public EntityType<? extends GolemBase> getEntityType() {
        return this.entityType;
    }

    public ResourceLocation getRegistryName() {
        return this.entityType.getRegistryName();
    }

    public GolemRenderSettings getRenderSettings() {
        return this.renderSettings;
    }

    public SoundEvent getSound() {
        return this.basicSound;
    }

    public String getName() {
        return this.name;
    }

    public double getHealth() {
        return this.health;
    }

    public double getAttack() {
        return this.attack;
    }

    public double getSpeed() {
        return this.speed;
    }

    public double getKnockbackResist() {
        return this.knockbackResist;
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean takesFallDamage() {
        return this.fallDamage;
    }

    public boolean isImmuneToExplosions() {
        return this.explosionImmunity;
    }

    public boolean canSwim() {
        return this.swimMode == SwimMode.FLOAT;
    }

    public SwimMode getSwimMode() {
        return this.swimMode;
    }

    public boolean noGolemBookEntry() {
        return this.noGolemBookEntry;
    }

    public Supplier<AttributeModifierMap.MutableAttribute> getAttributeSupplier() {
        return () -> MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, this.health).func_233815_a_(Attributes.field_233821_d_, this.speed).func_233815_a_(Attributes.field_233820_c_, this.knockbackResist).func_233815_a_(Attributes.field_233823_f_, this.attack);
    }

    public static enum SwimMode {
        SINK,
        FLOAT,
        SWIM;

    }

    public static final class Builder {
        private final String golemName;
        private final Class<? extends GolemBase> entityClass;
        private EntityType.Builder<? extends GolemBase> entityTypeBuilder;
        private SoundEvent basicSound = SoundEvents.field_187902_gb;
        private String modid = "golems";
        private double health = 100.0;
        private double attack = 7.0;
        private double speed = 0.25;
        private double knockBackResist = 0.4;
        private int lightLevel = 0;
        private int powerLevel = 0;
        private boolean fallDamage = false;
        private boolean explosionImmunity = false;
        private boolean noGolemBookEntry = false;
        private SwimMode swimMode = SwimMode.SINK;
        private Set<IRegistryDelegate<Block>> validBuildingBlocks = new HashSet<IRegistryDelegate<Block>>();
        private Set<ResourceLocation> validBuildingBlockTags = new HashSet<ResourceLocation>();
        private List<GolemSpecialContainer> specials = new ArrayList<GolemSpecialContainer>();
        private List<GolemDescription> descriptions = new ArrayList<GolemDescription>();
        private final Map<IRegistryDelegate<Item>, Double> healItemMap = new HashMap<IRegistryDelegate<Item>, Double>();
        private GolemRenderSettings customSettings = null;
        private boolean hasCustomRender = false;
        private boolean hasTransparency = false;
        private boolean hasPrefabTexture = false;
        private boolean hasVinesTexture = true;
        private boolean hasColor = false;
        private boolean doVinesGlow = false;
        private boolean doEyesGlow = false;
        private GolemRenderSettings.ITextureProvider dynamicTextureProvider = g -> GolemRenderSettings.FALLBACK_BLOCK;
        private GolemRenderSettings.ITextureProvider prefabTextureProvider = g -> GolemRenderSettings.FALLBACK_PREFAB;
        private GolemRenderSettings.ITextureProvider vinesTextureProvider = g -> GolemRenderSettings.FALLBACK_VINES;
        private GolemRenderSettings.ITextureProvider eyesTextureProvider = g -> GolemRenderSettings.FALLBACK_EYES;
        private GolemRenderSettings.IColorProvider textureColorProvider = g -> 0;
        private GolemRenderSettings.IColorProvider vinesColorProvider = g -> 8626266;
        private GolemRenderSettings.ILightingProvider textureGlowProvider = g -> g.isProvidingLight();

        public Builder(String golemName, Class<? extends GolemBase> entityClazz, EntityType.IFactory<? extends GolemBase> entityFactory) {
            this.golemName = golemName;
            this.entityClass = entityClazz;
            this.entityTypeBuilder = EntityType.Builder.func_220322_a(entityFactory, (EntityClassification)EntityClassification.MISC).setTrackingRange(48).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).func_220321_a(1.4f, 2.9f);
        }

        public Builder setModId(String lModId) {
            this.modid = lModId;
            return this;
        }

        public Builder setHealth(double lHealth) {
            this.health = lHealth;
            return this;
        }

        public Builder setAttack(double lAttack) {
            this.attack = lAttack;
            return this;
        }

        public Builder setSpeed(double lMoveSpeed) {
            this.speed = lMoveSpeed;
            return this;
        }

        public Builder setKnockbackResist(double lKnockbackResist) {
            this.knockBackResist = lKnockbackResist;
            return this;
        }

        public Builder setLightLevel(int lLightLevel) {
            this.lightLevel = MathHelper.func_76125_a((int)lLightLevel, (int)0, (int)15);
            if (this.lightLevel > 0) {
                this.addSpecial("Allow Special: Light", true, "Whether the golem can emit light");
            }
            return this;
        }

        public Builder setPowerLevel(int lPowerLevel) {
            this.powerLevel = MathHelper.func_76125_a((int)lPowerLevel, (int)0, (int)15);
            if (this.powerLevel > 0) {
                this.addSpecial("Allow Special: Power", true, "Whether the golem can emit power");
            }
            return this;
        }

        public Builder hasCustomRender() {
            this.hasCustomRender = true;
            return this;
        }

        public Builder setRenderSettings(GolemRenderSettings renderSettings) {
            this.customSettings = renderSettings;
            return this;
        }

        public Builder setStaticTexture(GolemRenderSettings.ITextureProvider prefab) {
            this.hasPrefabTexture = true;
            this.prefabTextureProvider = prefab;
            return this;
        }

        public Builder setDynamicTexture(String blockTexture) {
            return this.setDynamicTexture("minecraft", blockTexture);
        }

        public Builder setDynamicTexture(String modid, String blockTexture) {
            ResourceLocation texture = new ResourceLocation(modid, "textures/block/" + blockTexture + ".png");
            return this.setDynamicTexture((GolemBase g) -> texture);
        }

        public Builder setDynamicTexture(GolemRenderSettings.ITextureProvider texture) {
            this.hasPrefabTexture = false;
            this.dynamicTextureProvider = texture;
            return this;
        }

        public Builder setTextureColor(GolemRenderSettings.IColorProvider textureColorer) {
            this.hasColor = true;
            this.textureColorProvider = textureColorer;
            return this;
        }

        public Builder transparent() {
            this.hasTransparency = true;
            return this;
        }

        public Builder noVines() {
            this.hasVinesTexture = false;
            this.doVinesGlow = false;
            return this;
        }

        public Builder setVinesProvider(GolemRenderSettings.ITextureProvider vines) {
            this.hasVinesTexture = true;
            this.vinesTextureProvider = vines;
            return this;
        }

        public Builder setVinesColor(GolemRenderSettings.IColorProvider vinesColorer) {
            this.vinesColorProvider = vinesColorer;
            return this;
        }

        public Builder setEyesProvider(GolemRenderSettings.ITextureProvider eyes) {
            this.eyesTextureProvider = eyes;
            return this;
        }

        public Builder noVinesLighting() {
            this.doVinesGlow = true;
            return this;
        }

        public Builder noEyesLighting() {
            this.doEyesGlow = true;
            return this;
        }

        public Builder noLighting() {
            return this.noLighting(g -> true);
        }

        public Builder noLighting(GolemRenderSettings.ILightingProvider noLighting) {
            this.textureGlowProvider = noLighting;
            return this;
        }

        public Builder setSound(SoundEvent lSound) {
            this.basicSound = lSound;
            return this;
        }

        public Builder setSwimMode(SwimMode mode) {
            this.swimMode = mode;
            return this;
        }

        public Builder addBlocks(Block ... additionalBlocks) {
            if (additionalBlocks != null && additionalBlocks.length > 0) {
                this.validBuildingBlocks.addAll(Arrays.asList(additionalBlocks).stream().map(b -> b.delegate).collect(Collectors.toSet()));
            }
            return this;
        }

        public Builder addBlocks(ITag.INamedTag<Block> blockTag) {
            this.validBuildingBlockTags.add(blockTag.func_230234_a_());
            return this;
        }

        public Builder addBlocks(ResourceLocation blockTag) {
            this.validBuildingBlockTags.add(blockTag);
            return this;
        }

        public Builder addSpecials(GolemSpecialContainer ... specialContainers) {
            this.specials.addAll(Arrays.asList(specialContainers));
            return this;
        }

        public <T> Builder addSpecial(String name, T value, String comment) {
            this.specials.add(new GolemSpecialContainer.Builder<T>(name, value, comment).build());
            return this;
        }

        public Builder addSpecial(String name, Boolean value, String comment, IFormattableTextComponent desc) {
            this.addSpecial(name, value, comment);
            this.addDesc(new GolemDescription(desc, name));
            return this;
        }

        public Builder addDesc(GolemDescription ... desc) {
            for (GolemDescription cont : desc) {
                this.descriptions.add(cont);
            }
            return this;
        }

        public Builder addHealItem(Item item, double amount) {
            this.healItemMap.put((IRegistryDelegate<Item>)item.delegate, amount);
            return this;
        }

        public Builder immuneToFire() {
            this.entityTypeBuilder = this.entityTypeBuilder.func_220320_c();
            return this;
        }

        public Builder immuneToExplosions() {
            this.explosionImmunity = true;
            return this;
        }

        public Builder enableFallDamage() {
            this.fallDamage = true;
            return this;
        }

        public Builder noGolemBookEntry() {
            this.noGolemBookEntry = true;
            return this;
        }

        public GolemContainer build() {
            ResourceLocation name = new ResourceLocation(this.modid, this.golemName);
            GolemContainerBuildEvent event = new GolemContainerBuildEvent(name, this, this.validBuildingBlocks, this.validBuildingBlockTags);
            MinecraftForge.EVENT_BUS.post((Event)event);
            EntityType entityType = this.entityTypeBuilder.func_206830_a(this.golemName);
            entityType.setRegistryName(name);
            HashMap<String, GolemSpecialContainer> containerMap = new HashMap<String, GolemSpecialContainer>();
            for (GolemSpecialContainer c : this.specials) {
                containerMap.put(c.name, c);
            }
            GolemRenderSettings renderSettings = this.customSettings != null ? this.customSettings : new GolemRenderSettings(this.hasCustomRender, this.hasTransparency, this.textureGlowProvider, this.dynamicTextureProvider, this.hasVinesTexture, this.doVinesGlow, this.vinesTextureProvider, this.doEyesGlow, this.eyesTextureProvider, this.hasPrefabTexture, this.prefabTextureProvider, this.hasColor, this.textureColorProvider, this.vinesColorProvider);
            return new GolemContainer(entityType, this.entityClass, this.golemName, renderSettings, this.validBuildingBlocks, this.validBuildingBlockTags, this.health, this.attack, this.speed, this.knockBackResist, this.lightLevel, this.powerLevel, this.fallDamage, this.explosionImmunity, this.swimMode, containerMap, this.descriptions, this.healItemMap, this.basicSound, this.noGolemBookEntry);
        }
    }
}

