/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.util;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.util.GolemContainer;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public final class GolemRegistrar {
    public static HashMap<ResourceLocation, GolemContainer> golemList = new HashMap();

    private GolemRegistrar() {
    }

    public static void registerGolem(GolemContainer container) {
        if (golemList.containsKey(container.getRegistryName())) {
            return;
        }
        golemList.put(container.getRegistryName(), container);
    }

    @Nullable
    public static GolemContainer getContainer(EntityType<?> entityType) {
        return entityType != null ? GolemRegistrar.getContainer(entityType.getRegistryName()) : null;
    }

    @Nullable
    public static GolemContainer getContainer(ResourceLocation name) {
        return golemList.get(name);
    }

    public static boolean hasContainer(ResourceLocation name) {
        return golemList.containsKey(name);
    }

    @Nullable
    public static GolemBase getGolem(World world, Block below1, Block below2, Block arm1, Block arm2) {
        GolemContainer container = null;
        for (GolemContainer c : golemList.values()) {
            if (!c.areBuildingBlocks(below1, below2, arm1, arm2)) continue;
            container = c;
            break;
        }
        if (container == null) {
            return null;
        }
        return (GolemBase)container.getEntityType().func_200721_a(world);
    }

    public static Collection<GolemContainer> getContainers() {
        return golemList.values();
    }
}

