/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.util.config;

import com.mcmoddev.golems.util.GolemContainer;
import net.minecraftforge.common.ForgeConfigSpec;

public class GolemConfigurationSection {
    public final String entityName;
    public ForgeConfigSpec.DoubleValue health;
    public ForgeConfigSpec.DoubleValue attack;
    public ForgeConfigSpec.BooleanValue enabled;

    protected GolemConfigurationSection(GolemContainer container, ForgeConfigSpec.Builder builder) {
        this.entityName = container.getName();
        this.loadConfig(builder, container);
    }

    public void loadConfig(ForgeConfigSpec.Builder builder, GolemContainer container) {
        this.enabled = builder.comment("Disables in-world building of the golem.").worldRestart().define("enabled", true);
        this.health = builder.worldRestart().defineInRange("health", container.getHealth(), 1.0, 999.0);
        this.attack = builder.worldRestart().defineInRange("attack", container.getAttack(), 1.0, 999.0);
    }
}

