/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems_clib;

import com.mcmoddev.golems.entity.GenericGolem;
import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.integration.DeferredContainer;
import com.mcmoddev.golems.main.ExtraGolems;
import com.mcmoddev.golems.util.GolemBuilders;
import com.mcmoddev.golems.util.GolemContainer;
import com.mcmoddev.golems.util.GolemRegistrar;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;

public final class ClibGolemsEntities {
    public static final String CLIB = "clib";
    public static final String MODID = "golems_clib";
    private static final List<DeferredContainer> deferred = new ArrayList<DeferredContainer>();

    private ClibGolemsEntities() {
    }

    public static void initEntityTypes() {
        ExtraGolems.LOGGER.debug("Extra Golems: CLib - initEntityTypes");
        ClibGolemsEntities.register(GolemBuilders.aluminumGolem().setDynamicTexture(CLIB, "aluminum_block").build(), "aluminum_block");
        ClibGolemsEntities.register(new GolemContainer.Builder("golem_amethyst", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(85.0).setAttack(6.75).setSpeed(0.28).setKnockbackResist(0.6).addBlocks(new ResourceLocation("forge", "storage_blocks/amethyst")).setDynamicTexture(CLIB, "amethyst_block").build(), "amethyst_block");
        ClibGolemsEntities.register(new GolemContainer.Builder("golem_brass", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(98.0).setAttack(7.25).setKnockbackResist(0.6).setSound(SoundEvents.field_187778_dq).setDynamicTexture(CLIB, "brass_block").addBlocks(new ResourceLocation("forge", "storage_blocks/brass")).build(), "brass_block");
        ClibGolemsEntities.register(GolemBuilders.bronzeGolem().setDynamicTexture(CLIB, "bronze_block").build(), "bronze_block");
        ClibGolemsEntities.register(new GolemContainer.Builder("golem_chromium", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(114.0).setAttack(8.5).setKnockbackResist(0.9).setSound(SoundEvents.field_187778_dq).setDynamicTexture(CLIB, "chromium_block").addBlocks(new ResourceLocation("forge", "storage_blocks/chromium")).build(), "chromium_block");
        ClibGolemsEntities.register(new GolemContainer.Builder("golem_cobalt", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(85.0).setAttack(6.5).setSpeed(0.28).setKnockbackResist(1.0).addBlocks(new ResourceLocation("forge", "storage_blocks/cobalt")).setDynamicTexture(CLIB, "cobalt_block").build(), "cobalt_block");
        ClibGolemsEntities.register(GolemBuilders.copperGolem().setDynamicTexture(CLIB, "copper_block").build(), "copper_block");
        ClibGolemsEntities.register(GolemBuilders.electrumGolem().setDynamicTexture(CLIB, "electrum_block").build(), "electrum_block");
        ClibGolemsEntities.register(GolemBuilders.enderiumGolem().setDynamicTexture(CLIB, "enderium_block").build(), "enderium_block");
        ClibGolemsEntities.register(GolemBuilders.invarGolem().setDynamicTexture(CLIB, "invar_block").build(), "invar_block");
        ClibGolemsEntities.register(GolemBuilders.leadGolem().setDynamicTexture(CLIB, "lead_block").build(), "lead_block");
        ClibGolemsEntities.register(GolemBuilders.lumiumGolem().setDynamicTexture(CLIB, "lumium_block").build(), "lumium_block");
        ClibGolemsEntities.register(GolemBuilders.nickelGolem().setDynamicTexture(CLIB, "nickel_block").build(), "nickel_block");
        ClibGolemsEntities.register(new GolemContainer.Builder("golem_opal", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(65.0).setAttack(6.5).setSpeed(0.28).setKnockbackResist(0.6).setSound(SoundEvents.field_187569_bQ).setDynamicTexture(CLIB, "opal_block").addBlocks(new ResourceLocation("forge", "storage_blocks/opal")).build(), "opal_block");
        ClibGolemsEntities.register(GolemBuilders.platinumGolem().setDynamicTexture(CLIB, "platinum_block").build(), "platinum_block");
        ClibGolemsEntities.register(GolemBuilders.rubyGolem().setDynamicTexture(CLIB, "ruby_block").build(), "ruby_block");
        ClibGolemsEntities.register(GolemBuilders.sapphireGolem().setDynamicTexture(CLIB, "sapphire_block").build(), "sapphire_block");
        ClibGolemsEntities.register(GolemBuilders.signalumGolem().setDynamicTexture(CLIB, "signalum_block").build(), "signalum_block");
        ClibGolemsEntities.register(GolemBuilders.silverGolem().setDynamicTexture(CLIB, "silver_block").build(), "silver_block");
        ClibGolemsEntities.register(GolemBuilders.steelGolem().setDynamicTexture(CLIB, "steel_block").build(), "steel_block");
        ClibGolemsEntities.register(GolemBuilders.tinGolem().setDynamicTexture(CLIB, "tin_block").build(), "tin_block");
        ClibGolemsEntities.register(new GolemContainer.Builder("golem_titanium", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(146.0).setAttack(7.9).setSound(SoundEvents.field_187778_dq).addBlocks(new ResourceLocation("forge", "storage_blocks/titanium")).setDynamicTexture(CLIB, "titanium_block").build(), "titanium_block");
        ClibGolemsEntities.register(new GolemContainer.Builder("golem_tungsten", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(68.0).setAttack(5.9).setSound(SoundEvents.field_187778_dq).addBlocks(new ResourceLocation("forge", "storage_blocks/tungsten")).setDynamicTexture(CLIB, "tungsten_block").build(), "tungsten_block");
        ClibGolemsEntities.register(new GolemContainer.Builder("golem_zinc", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(52.0).setAttack(3.75).setSound(SoundEvents.field_187778_dq).addBlocks(new ResourceLocation("forge", "storage_blocks/zinc")).setDynamicTexture(CLIB, "zinc_block").build(), "zinc_block");
    }

    protected static void register(GolemContainer cont, String ... blockNames) {
        deferred.add(new DeferredContainer(cont, CLIB, blockNames));
        GolemRegistrar.registerGolem(cont);
    }

    public static void interModEnqueueEvent(InterModEnqueueEvent event) {
    }

    public static void setupEvent(FMLCommonSetupEvent event) {
        for (DeferredContainer d : deferred) {
            d.addBlocks();
        }
    }
}

