/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems_immersiveengineering;

import com.mcmoddev.golems.entity.GenericGolem;
import com.mcmoddev.golems.entity.NetheriteGolem;
import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.integration.DeferredContainer;
import com.mcmoddev.golems.main.ExtraGolems;
import com.mcmoddev.golems.util.GolemBuilders;
import com.mcmoddev.golems.util.GolemContainer;
import com.mcmoddev.golems.util.GolemRegistrar;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;

public final class IEGolemsEntities {
    public static final String IE = "immersiveengineering";
    public static final String MODID = "golems_ie";
    private static final List<DeferredContainer> deferred = new ArrayList<DeferredContainer>();

    private IEGolemsEntities() {
    }

    public static void initEntityTypes() {
        ExtraGolems.LOGGER.debug("Extra Golems: Immersive Engineering - initEntityTypes");
        IFormattableTextComponent descResist = new TranslationTextComponent("effect.minecraft.resistance").func_240699_a_(TextFormatting.DARK_GRAY);
        IEGolemsEntities.register(GolemBuilders.aluminumGolem().setDynamicTexture(IE, "metal/storage_aluminum").build(), "storage_aluminum");
        IEGolemsEntities.register(GolemBuilders.coalCokeGolem().setDynamicTexture(IE, "stone_decoration/coke").build(), "coke", "cokebrick");
        IEGolemsEntities.register(new GolemContainer.Builder("golem_concrete", NetheriteGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)NetheriteGolem::new)).setModId(MODID).setHealth(59.0).setAttack(5.0).setSpeed(0.26).setKnockbackResist(0.6).addSpecial("Allow Special: Resistance", true, "Whether this golem reduces damage it takes", descResist).immuneToExplosions().setDynamicTexture(IE, "stone_decoration/concrete_tile").build(), "concrete", "concrete_tile");
        IEGolemsEntities.register(GolemBuilders.constantanGolem().setDynamicTexture(IE, "metal/storage_constantan").build(), "storage_constantan");
        IEGolemsEntities.register(GolemBuilders.copperGolem().setDynamicTexture(IE, "metal/storage_copper").build(), "storage_copper");
        IEGolemsEntities.register(new GolemContainer.Builder("golem_copper_coil", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(64.0).setAttack(4.6).setSound(SoundEvents.field_187778_dq).setDynamicTexture(IE, "metal_decoration/coil_lv_side").build(), "coil_lv");
        IEGolemsEntities.register(new GolemContainer.Builder("golem_cushion", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(44.0).setAttack(2.6).setKnockbackResist(0.0).setSound(SoundEvents.field_187554_ai).setDynamicTexture(IE, "cushion").build(), "cushion");
        IEGolemsEntities.register(GolemBuilders.electrumGolem().setDynamicTexture(IE, "metal/storage_electrum").build(), "storage_electrum");
        IEGolemsEntities.register(new GolemContainer.Builder("golem_electrum_coil", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(71.0).setAttack(5.6).setSound(SoundEvents.field_187778_dq).setDynamicTexture(IE, "metal_decoration/coil_mv_side").build(), "coil_mv");
        IEGolemsEntities.register(new GolemContainer.Builder("golem_hv_coil", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(78.0).setAttack(6.6).setSound(SoundEvents.field_187778_dq).setDynamicTexture(IE, "metal_decoration/coil_hv_side").build(), "coil_hv");
        IEGolemsEntities.register(new GolemContainer.Builder("golem_insulating_glass", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(20.0).setAttack(8.9).setSound(SoundEvents.field_187569_bQ).setDynamicTexture(IE, "stone_decoration/insulating_glass").transparent().build(), "insulating_glass");
        IEGolemsEntities.register(GolemBuilders.leadGolem().setDynamicTexture(IE, "metal/storage_lead").build(), "storage_lead");
        IEGolemsEntities.register(new GolemContainer.Builder("golem_leaded_concrete", NetheriteGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)NetheriteGolem::new)).setModId(MODID).setHealth(67.0).setAttack(5.2).setSpeed(0.24).setKnockbackResist(1.0).addSpecial("Allow Special: Resistance", true, "Whether this golem reduces damage it takes", descResist).immuneToExplosions().setDynamicTexture(IE, "stone_decoration/concrete_leaded").build(), "concrete_leaded");
        IEGolemsEntities.register(GolemBuilders.nickelGolem().setDynamicTexture(IE, "metal/storage_nickel").build(), "storage_nickel");
        IEGolemsEntities.register(GolemBuilders.silverGolem().setDynamicTexture(IE, "metal/storage_silver").build(), "storage_silver");
        IEGolemsEntities.register(GolemBuilders.steelGolem().setDynamicTexture(IE, "metal/storage_steel").build(), "storage_steel");
        IEGolemsEntities.register(GolemBuilders.uraniumGolem().setDynamicTexture(IE, "metal/storage_uranium_side").build(), "storage_uranium");
    }

    protected static void register(GolemContainer cont, String ... blockNames) {
        deferred.add(new DeferredContainer(cont, IE, blockNames));
        GolemRegistrar.registerGolem(cont);
    }

    public static void interModEnqueueEvent(InterModEnqueueEvent event) {
    }

    public static void setupEvent(FMLCommonSetupEvent event) {
        for (DeferredContainer d : deferred) {
            d.addBlocks();
        }
    }
}

