/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems_mekanism;

import com.mcmoddev.golems.entity.GenericGolem;
import com.mcmoddev.golems.entity.NetheriteGolem;
import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.integration.DeferredContainer;
import com.mcmoddev.golems.main.ExtraGolems;
import com.mcmoddev.golems.util.GolemBuilders;
import com.mcmoddev.golems.util.GolemContainer;
import com.mcmoddev.golems.util.GolemRegistrar;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;

public final class MekanismGolemsEntities {
    public static final String MEK = "mekanism";
    public static final String MODID = "golems_mekanism";
    private static final List<DeferredContainer> deferred = new ArrayList<DeferredContainer>();

    private MekanismGolemsEntities() {
    }

    public static void initEntityTypes() {
        ExtraGolems.LOGGER.debug("Extra Golems: Mekanism - initEntityTypes");
        IFormattableTextComponent descResist = new TranslationTextComponent("effect.minecraft.resistance").func_240699_a_(TextFormatting.DARK_GRAY);
        MekanismGolemsEntities.register(GolemBuilders.bronzeGolem().setDynamicTexture(MEK, "block_bronze").build(), "block_bronze");
        MekanismGolemsEntities.register(GolemBuilders.charcoalGolem().setDynamicTexture(MEK, "block_charcoal").build(), "block_charcoal");
        MekanismGolemsEntities.register(GolemBuilders.copperGolem().setDynamicTexture(MEK, "block_copper").build(), "block_copper");
        MekanismGolemsEntities.register(GolemBuilders.leadGolem().setDynamicTexture(MEK, "block_lead").build(), "block_lead");
        MekanismGolemsEntities.register(GolemBuilders.osmiumGolem().setDynamicTexture(MEK, "block_osmium").build(), "block_osmium");
        MekanismGolemsEntities.register(new GolemContainer.Builder("golem_refined_glowstone", NetheriteGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)NetheriteGolem::new)).setModId(MODID).setHealth(48.0).setAttack(2.6).setLightLevel(15).immuneToFire().addSpecial("Allow Special: Resistance", true, "Whether this golem reduces incoming damage", descResist).setDynamicTexture(MEK, "block_refined_glowstone").build(), "block_refined_glowstone");
        MekanismGolemsEntities.register(new GolemContainer.Builder("golem_refined_obsidian", NetheriteGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)NetheriteGolem::new)).setModId(MODID).setHealth(120.0).setAttack(18.0).setSpeed(0.23).setKnockbackResist(0.8).addSpecial("Allow Special: Resistance", true, "Whether this golem reduces incoming damage", descResist).immuneToFire().immuneToExplosions().setLightLevel(8).setDynamicTexture(MEK, "block_refined_obsidian").build(), "block_refined_obsidian");
        MekanismGolemsEntities.register(new GolemContainer.Builder("golem_salt", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(48.0).setAttack(2.6).setKnockbackResist(0.6).addBlocks(new ResourceLocation("forge", "storage_blocks/salt")).setDynamicTexture(MEK, "block_salt").build(), "block_salt");
        MekanismGolemsEntities.register(GolemBuilders.steelGolem().setDynamicTexture(MEK, "block_steel").build(), "block_steel");
        MekanismGolemsEntities.register(GolemBuilders.tinGolem().setDynamicTexture(MEK, "block_tin").build(), "block_tin");
        MekanismGolemsEntities.register(GolemBuilders.uraniumGolem().setDynamicTexture(MEK, "block_uranium").build(), "block_uranium");
    }

    protected static void register(GolemContainer cont, String ... blockNames) {
        deferred.add(new DeferredContainer(cont, MEK, blockNames));
        GolemRegistrar.registerGolem(cont);
    }

    public static void interModEnqueueEvent(InterModEnqueueEvent event) {
    }

    public static void setupEvent(FMLCommonSetupEvent event) {
        for (DeferredContainer d : deferred) {
            d.addBlocks();
        }
    }
}

