/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems_quark.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemMultiTextured;
import com.mcmoddev.golems.util.GolemTextureBytes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.automation.module.ColorSlimeModule;

public class ColorSlimeGolem
extends GolemMultiTextured {
    public static final String ALLOW_SPECIAL = "Allow Special: Extra Knockback";
    public static final String SPLITTING_CHILDREN = "Splitting Factor";
    public static final String KNOCKBACK = "Knockback Factor";
    public static final String[] TEXTURE_NAMES = new String[]{"red_slime_block", "blue_slime_block", "cyan_slime_block", "magenta_slime_block", "yellow_slime_block"};
    public static final String[] LOOT_TABLE_NAMES = new String[]{"red", "blue", "cyan", "magenta", "yellow"};
    private static final Map<Block, Byte> textureBytes = new HashMap<Block, Byte>();
    private boolean allowKnockback = this.getConfigBool("Allow Special: Extra Knockback");
    private double knockbackAmount = this.getConfigDouble("Knockback Factor");

    public ColorSlimeGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world, "quark", TEXTURE_NAMES, "golems_quark", LOOT_TABLE_NAMES);
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (!this.func_70631_g_() && this.allowKnockback && !(entity instanceof SlimeEntity)) {
                this.applyKnockback(entity, this.knockbackAmount);
            }
            return true;
        }
        return false;
    }

    protected void func_70665_d(DamageSource source, float amount) {
        if (!this.func_180431_b(source)) {
            super.func_70665_d(source, amount);
            if (this.allowKnockback && !this.func_70631_g_() && source.func_76364_f() != null) {
                this.applyKnockback(source.func_76364_f(), this.getConfigDouble(KNOCKBACK));
            }
        }
    }

    @Override
    public void func_82227_f(boolean isChild) {
        super.func_82227_f(isChild);
        if (isChild) {
            this.allowKnockback = false;
        }
    }

    public void func_70645_a(DamageSource source) {
        int children = this.getConfigInt(SPLITTING_CHILDREN);
        if (children > 0) {
            for (GolemBase g : this.trySpawnChildren(children)) {
                ((ColorSlimeGolem)g).setTextureNum((byte)this.getTextureNum());
            }
        }
        super.func_70645_a(source);
    }

    @Override
    public ItemStack getCreativeReturn(RayTraceResult target) {
        return new ItemStack((IItemProvider)GolemTextureBytes.getByByte(textureBytes, (byte)this.getTextureNum()));
    }

    @Override
    public Map<Block, Byte> getTextureBytes() {
        if (textureBytes.isEmpty()) {
            ColorSlimeGolem.fillTextureBytes();
        }
        return textureBytes;
    }

    private void applyKnockback(Entity entity, double knockbackFactor) {
        Vector3d myPos = this.func_213303_ch();
        Vector3d ePos = entity.func_213303_ch();
        double dX = Math.signum(ePos.field_72450_a - myPos.field_72450_a) * knockbackFactor;
        double dZ = Math.signum(ePos.field_72449_c - myPos.field_72449_c) * knockbackFactor;
        entity.func_70024_g(dX, knockbackFactor / 2.0, dZ);
        entity.field_70133_I = true;
    }

    private static void fillTextureBytes() {
        if (ModuleLoader.INSTANCE.isModuleEnabled(ColorSlimeModule.class)) {
            int l = LOOT_TABLE_NAMES.length;
            for (int i = 0; i < l; ++i) {
                Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark:" + LOOT_TABLE_NAMES[i] + "_slime_block"));
                textureBytes.put(b, (byte)i);
            }
        }
    }
}

