/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems_quark.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemMultiTextured;
import com.mcmoddev.golems.util.GolemTextureBytes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.building.module.QuiltedWoolModule;

public class QuiltedWoolGolem
extends GolemMultiTextured {
    private static final Map<Block, Byte> textureBytes = new HashMap<Block, Byte>();
    public static final String[] TEXTURE_NAMES = new String[]{"black_quilted_wool", "orange_quilted_wool", "magenta_quilted_wool", "light_blue_quilted_wool", "yellow_quilted_wool", "lime_quilted_wool", "pink_quilted_wool", "gray_quilted_wool", "light_gray_quilted_wool", "cyan_quilted_wool", "purple_quilted_wool", "blue_quilted_wool", "brown_quilted_wool", "green_quilted_wool", "red_quilted_wool", "white_quilted_wool"};
    public static final String[] LOOT_TABLE_NAMES = new String[]{"black", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "white"};

    public QuiltedWoolGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world, "quark", TEXTURE_NAMES, "golems_quark", LOOT_TABLE_NAMES);
    }

    @Override
    public ItemStack getCreativeReturn(RayTraceResult target) {
        return new ItemStack((IItemProvider)GolemTextureBytes.getByByte(textureBytes, (byte)this.getTextureNum()));
    }

    @Override
    public Map<Block, Byte> getTextureBytes() {
        if (textureBytes.isEmpty()) {
            QuiltedWoolGolem.fillTextureBytes();
        }
        return textureBytes;
    }

    private static void fillTextureBytes() {
        if (ModuleLoader.INSTANCE.isModuleEnabled(QuiltedWoolModule.class)) {
            for (DyeColor d : DyeColor.values()) {
                Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark:" + d.func_176610_l() + "_quilted_wool"));
                textureBytes.put(b, (byte)d.func_196059_a());
            }
        }
    }
}

