/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems_thermal;

import com.mcmoddev.golems.entity.GenericGolem;
import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.integration.DeferredContainer;
import com.mcmoddev.golems.main.ExtraGolems;
import com.mcmoddev.golems.util.GolemBuilders;
import com.mcmoddev.golems.util.GolemContainer;
import com.mcmoddev.golems.util.GolemRegistrar;
import com.mcmoddev.golems_thermal.entity.GunpowderGolem;
import com.mcmoddev.golems_thermal.entity.HardenedGlassGolem;
import com.mcmoddev.golems_thermal.entity.RockwoolGolem;
import com.mcmoddev.golems_thermal.entity.RubberGolem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.registries.ForgeRegistries;

public final class ThermalGolemsEntities {
    public static final String THERMAL = "thermal";
    public static final String MODID = "golems_thermal";
    private static final List<DeferredContainer> deferred = new ArrayList<DeferredContainer>();

    private ThermalGolemsEntities() {
    }

    public static void initEntityTypes() {
        ExtraGolems.LOGGER.debug("Extra Golems: Thermal - initEntityTypes");
        String[] rockwoolTypes = new String[DyeColor.values().length];
        int l = rockwoolTypes.length;
        for (int i = 0; i < l; ++i) {
            rockwoolTypes[i] = DyeColor.values()[i] + "_rockwool";
        }
        ThermalGolemsEntities.register(new GolemContainer.Builder("golem_apatite", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(44.0).setAttack(2.9).setSpeed(0.26).addBlocks(new ResourceLocation("forge", "storage_blocks/apatite")).setDynamicTexture(THERMAL, "storage/apatite_block").build(), "apatite_block");
        ThermalGolemsEntities.register(GolemBuilders.bronzeGolem().setDynamicTexture(THERMAL, "storage/bronze_block").build(), "bronze_block");
        ThermalGolemsEntities.register(GolemBuilders.charcoalGolem().setDynamicTexture(THERMAL, "storage/charcoal_block").build(), "charcoal_block");
        ThermalGolemsEntities.register(new GolemContainer.Builder("golem_cinnabar", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(72.0).setAttack(4.25).setSound(SoundEvents.field_187778_dq).addBlocks(new ResourceLocation("forge", "storage_blocks/cinnabar")).setDynamicTexture(THERMAL, "storage/cinnabar_block").build(), "cinnabar_block");
        ThermalGolemsEntities.register(GolemBuilders.coalCokeGolem().setDynamicTexture(THERMAL, "storage/coal_coke_block").build(), "coal_coke_block");
        ThermalGolemsEntities.register(GolemBuilders.constantanGolem().setDynamicTexture(THERMAL, "storage/constantan_block").build(), "constantan_block");
        ThermalGolemsEntities.register(GolemBuilders.copperGolem().setDynamicTexture(THERMAL, "storage/copper_block").build(), "copper_block");
        ThermalGolemsEntities.register(new GolemContainer.Builder("golem_cured_rubber", RubberGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)RubberGolem::new)).setModId(MODID).setHealth(68.0).setAttack(2.5).setSpeed(0.288).setKnockbackResist(0.35).addSpecial("Allow Special: Extra Knockback", true, "Whether this golem can apply extra knockback when attacking", new TranslationTextComponent("entitytip.has_knockback").func_240699_a_(TextFormatting.DARK_GRAY)).addSpecial("Knockback Factor", 0.5, "Cured Rubber Golem knockback power (Higher Value = Bigger Knockback)").setSwimMode(GolemContainer.SwimMode.FLOAT).setSound(SoundEvents.field_226140_eU_).setDynamicTexture(THERMAL, "storage/cured_rubber_block").build(), "cured_rubber_block");
        ThermalGolemsEntities.register(GolemBuilders.electrumGolem().setDynamicTexture(THERMAL, "storage/electrum_block").build(), "electrum_block");
        ThermalGolemsEntities.register(GolemBuilders.enderiumGolem().setDynamicTexture(THERMAL, "storage/enderium_block").build(), "enderium_block");
        ResourceLocation enderiumGlassTex = new ResourceLocation(MODID, "textures/entity/golem_enderium_glass.png");
        ThermalGolemsEntities.register(new GolemContainer.Builder("golem_enderium_glass", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(14.0).setAttack(10.0).setSpeed(0.29).enableFallDamage().setSound(SoundEvents.field_187569_bQ).setStaticTexture(g -> enderiumGlassTex).noVines().build(), "enderium_glass");
        ThermalGolemsEntities.register(new GolemContainer.Builder("golem_gunpowder", GunpowderGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GunpowderGolem::new)).setModId(MODID).setHealth(90.0).setAttack(2.25).setSpeed(0.27).addSpecial("Allow Special: Explode", true, "Whether this golem can explode when fighting or dying", new TranslationTextComponent("entitytip.explodes").func_240699_a_(TextFormatting.GRAY)).setSwimMode(GolemContainer.SwimMode.FLOAT).setSound(SoundEvents.field_187668_ca).addHealItem(Items.field_151016_H, 0.25).addBlocks(new ResourceLocation("forge", "storage_blocks/gunpowder")).setDynamicTexture(THERMAL, "storage/gunpowder_block").build(), "gunpowder_block");
        ResourceLocation hardenedGlassTex = new ResourceLocation(MODID, "textures/entity/golem_hardened_glass.png");
        ThermalGolemsEntities.register(new GolemContainer.Builder("golem_hardened_glass", HardenedGlassGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)HardenedGlassGolem::new)).setModId(MODID).setHealth(24.0).setAttack(11.5).setSpeed(0.29).setSound(SoundEvents.field_187569_bQ).immuneToExplosions().addSpecial("Allow Special: Resistance", true, "Whether this golem reduces damage it takes", new TranslationTextComponent("effect.minecraft.resistance").func_240699_a_(TextFormatting.DARK_GRAY)).setStaticTexture(g -> hardenedGlassTex).noVines().build(), "obsidian_glass");
        ThermalGolemsEntities.register(GolemBuilders.invarGolem().setDynamicTexture(THERMAL, "storage/invar_block").build(), "invar_block");
        ThermalGolemsEntities.register(GolemBuilders.leadGolem().setDynamicTexture(THERMAL, "storage/lead_block").build(), "lead_block");
        ThermalGolemsEntities.register(GolemBuilders.lumiumGolem().setDynamicTexture(THERMAL, "storage/lumium_block").build(), "lumium_block");
        ResourceLocation lumiumGlassTex = new ResourceLocation(MODID, "textures/entity/golem_lumium_glass.png");
        ThermalGolemsEntities.register(new GolemContainer.Builder("golem_lumium_glass", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(14.0).setAttack(10.5).setSpeed(0.28).enableFallDamage().setLightLevel(15).setSound(SoundEvents.field_187569_bQ).setStaticTexture(g -> lumiumGlassTex).noVines().build(), "lumium_glass");
        ThermalGolemsEntities.register(GolemBuilders.nickelGolem().setDynamicTexture(THERMAL, "storage/nickel_block").build(), "nickel_block");
        ThermalGolemsEntities.register(new GolemContainer.Builder("golem_niter", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(56.0).setAttack(3.5).setSpeed(0.29).setSound(SoundEvents.field_187778_dq).addBlocks(new ResourceLocation("forge", "storage_blocks/niter")).setDynamicTexture(THERMAL, "storage/niter_block").build(), "niter_block");
        ThermalGolemsEntities.register(new GolemContainer.Builder("golem_rich_slag", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(52.0).setAttack(3.0).setSpeed(0.265).setDynamicTexture(THERMAL, "storage/rich_slag_block").build(), "rich_slag_block");
        ThermalGolemsEntities.register(new GolemContainer.Builder("golem_rockwool", RockwoolGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)RockwoolGolem::new)).setModId(MODID).setHealth(28.0).setAttack(1.75).setSpeed(0.285).setKnockbackResist(0.2).immuneToFire().immuneToExplosions().setSwimMode(GolemContainer.SwimMode.FLOAT).setSound(SoundEvents.field_187554_ai).addHealItem(Items.field_151007_F, 0.1).setDynamicTexture("white_wool").noVines().hasCustomRender().build(), rockwoolTypes);
        ThermalGolemsEntities.register(new GolemContainer.Builder("golem_rosin", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(40.0).setAttack(2.5).setSpeed(0.27).setDynamicTexture(THERMAL, "storage/rosin_block_side").build(), "rosin_block");
        ThermalGolemsEntities.register(new GolemContainer.Builder("golem_rubber", RubberGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)RubberGolem::new)).setModId(MODID).setHealth(58.0).setAttack(2.5).setSpeed(0.288).setKnockbackResist(0.35).addSpecial("Allow Special: Extra Knockback", true, "Whether this golem can apply extra knockback when attacking", new TranslationTextComponent("entitytip.has_knockback").func_240699_a_(TextFormatting.GRAY)).addSpecial("Knockback Factor", 0.44, "Rubber Golem knockback power (Higher Value = Bigger Knockback)").setSwimMode(GolemContainer.SwimMode.FLOAT).setSound(SoundEvents.field_226140_eU_).setDynamicTexture(THERMAL, "storage/rubber_block").build(), "rubber_block");
        ThermalGolemsEntities.register(GolemBuilders.rubyGolem().setDynamicTexture(THERMAL, "storage/ruby_block").build(), "ruby_block");
        ThermalGolemsEntities.register(GolemBuilders.sapphireGolem().setDynamicTexture(THERMAL, "storage/sapphire_block").build(), "sapphire_block");
        ThermalGolemsEntities.register(new GolemContainer.Builder("golem_sawdust", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(16.0).setAttack(2.0).setSpeed(0.28).setSound(SoundEvents.field_187897_gY).setDynamicTexture(THERMAL, "storage/sawdust_block").build(), "sawdust_block");
        ThermalGolemsEntities.register(GolemBuilders.signalumGolem().setDynamicTexture(THERMAL, "storage/signalum_block").build(), "signalum_block");
        ResourceLocation signalumGlassTex = new ResourceLocation(MODID, "textures/entity/golem_signalum_glass.png");
        ThermalGolemsEntities.register(new GolemContainer.Builder("golem_signalum_glass", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(14.0).setAttack(10.5).setSpeed(0.285).enableFallDamage().setSound(SoundEvents.field_187569_bQ).setStaticTexture(g -> signalumGlassTex).noVines().build(), "signalum_glass");
        ThermalGolemsEntities.register(new GolemContainer.Builder("golem_slag", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(38.0).setAttack(3.25).setSpeed(0.27).setDynamicTexture(THERMAL, "storage/slag_block").build(), "slag_block");
        ThermalGolemsEntities.register(GolemBuilders.sulfurGolem().setDynamicTexture(THERMAL, "storage/sulfur_block").build(), "sulfur_block");
        ThermalGolemsEntities.register(GolemBuilders.tinGolem().setDynamicTexture(THERMAL, "storage/tin_block").build(), "tin_block");
    }

    protected static void register(GolemContainer cont, String ... blockNames) {
        deferred.add(new DeferredContainer(cont, THERMAL, blockNames));
        GolemRegistrar.registerGolem(cont);
    }

    public static void interModEnqueueEvent(InterModEnqueueEvent event) {
    }

    public static void setupEvent(FMLCommonSetupEvent event) {
        for (DeferredContainer d : deferred) {
            d.addBlocks();
        }
    }

    protected static void addBlocks(GolemContainer cont, String modid, String ... blockNames) {
        if (null == cont) {
            return;
        }
        for (String s : blockNames) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(modid, s));
            if (block == null) continue;
            cont.addBlocks(block);
        }
    }
}

