/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems_thermal.entity;

import com.mcmoddev.golems.entity.WoolGolem;
import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemMultiTextured;
import com.mcmoddev.golems.util.GolemTextureBytes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class RockwoolGolem
extends GolemMultiTextured {
    private static final Map<Block, Byte> textureBytes = new HashMap<Block, Byte>();

    public RockwoolGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world, "minecraft", WoolGolem.TEXTURE_NAMES, "golems_thermal", WoolGolem.LOOT_TABLE_NAMES);
    }

    @Override
    public ItemStack getCreativeReturn(RayTraceResult target) {
        return new ItemStack((IItemProvider)GolemTextureBytes.getByByte(textureBytes, (byte)this.getTextureNum()));
    }

    @Override
    public Map<Block, Byte> getTextureBytes() {
        if (textureBytes.isEmpty()) {
            RockwoolGolem.fillTextureBytes();
        }
        return textureBytes;
    }

    private static void fillTextureBytes() {
        for (DyeColor d : DyeColor.values()) {
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("thermal:" + d.func_176610_l() + "_rockwool"));
            textureBytes.put(b, (byte)d.func_196059_a());
        }
    }
}

