/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems_thermal.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class RubberGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Extra Knockback";
    public static final String KNOCKBACK = "Knockback Factor";
    private boolean allowKnockback = this.getConfigBool("Allow Special: Extra Knockback");
    private double knockbackAmount = this.getConfigDouble("Knockback Factor");

    public RubberGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world);
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (this.allowKnockback) {
                this.applyKnockback(entity, this.knockbackAmount);
            }
            return true;
        }
        return false;
    }

    protected void func_70665_d(DamageSource source, float amount) {
        if (!this.func_180431_b(source)) {
            super.func_70665_d(source, amount);
            if (this.allowKnockback && !this.func_70631_g_() && source.func_76364_f() != null) {
                this.applyKnockback(source.func_76364_f(), this.getConfigDouble(KNOCKBACK));
            }
        }
    }

    private void applyKnockback(Entity entity, double knockbackFactor) {
        Vector3d myPos = this.func_213303_ch();
        Vector3d ePos = entity.func_213303_ch();
        double dX = Math.signum(ePos.field_72450_a - myPos.field_72450_a) * knockbackFactor;
        double dZ = Math.signum(ePos.field_72449_c - myPos.field_72449_c) * knockbackFactor;
        entity.func_70024_g(dX, knockbackFactor / 2.0, dZ);
        entity.field_70133_I = true;
    }
}

