/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.gui.GuiAddWaypoint;
import com.mamiyaotaru.voxelmap.gui.GuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.mamiyaotaru.voxelmap.interfaces.AbstractMapData;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IColorManager;
import com.mamiyaotaru.voxelmap.interfaces.IMap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.persistent.GuiPersistentMap;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import com.mamiyaotaru.voxelmap.util.BlockRepository;
import com.mamiyaotaru.voxelmap.util.ColorUtils;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.FullMapData;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.LayoutVariables;
import com.mamiyaotaru.voxelmap.util.LiveGLBufferedImage;
import com.mamiyaotaru.voxelmap.util.LiveScaledGLBufferedImage;
import com.mamiyaotaru.voxelmap.util.MapChunkCache;
import com.mamiyaotaru.voxelmap.util.MapUtils;
import com.mamiyaotaru.voxelmap.util.MutableBlockPos;
import com.mamiyaotaru.voxelmap.util.ReflectionUtils;
import com.mamiyaotaru.voxelmap.util.TickCounter;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import net.minecraft.class_1043;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2368;
import net.minecraft.class_2378;
import net.minecraft.class_2506;
import net.minecraft.class_2561;
import net.minecraft.class_2572;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_290;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_316;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3614;
import net.minecraft.class_4060;
import net.minecraft.class_418;
import net.minecraft.class_4184;
import net.minecraft.class_428;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_758;
import net.minecraft.class_765;
import org.lwjgl.BufferUtils;

public class Map
implements Runnable,
IMap {
    private IVoxelMap master;
    private class_310 game;
    private String zmodver = "v1.10.15";
    private class_638 world = null;
    private final int WORLD_HEIGHT = 256;
    private MapSettingsManager options = null;
    private LayoutVariables layoutVariables = null;
    private IColorManager colorManager = null;
    private IWaypointManager waypointManager = null;
    private int availableProcessors = Runtime.getRuntime().availableProcessors();
    private boolean multicore = this.availableProcessors > 1;
    private FullMapData[] mapData = new FullMapData[5];
    private MapChunkCache[] chunkCache = new MapChunkCache[5];
    private LiveGLBufferedImage[] mapImages;
    private LiveGLBufferedImage[] mapImagesFiltered = new LiveGLBufferedImage[5];
    private LiveGLBufferedImage[] mapImagesUnfiltered = new LiveScaledGLBufferedImage[5];
    private MutableBlockPos blockPos = new MutableBlockPos(0, 0, 0);
    private MutableBlockPos tempBlockPos = new MutableBlockPos(0, 0, 0);
    private class_2680 transparentBlockState;
    private class_2680 surfaceBlockState;
    private class_2680 seafloorBlockState;
    private class_2680 foliageBlockState;
    private boolean imageChanged = true;
    private class_1043 lightmapTexture = null;
    private boolean needLightmapRefresh = true;
    private int tickWithLightChange = 0;
    private boolean lastPaused = true;
    private final float[] lastLightBrightnessTable = new float[16];
    private double lastGamma = 0.0;
    private float lastSunBrightness = 0.0f;
    private float lastLightning = 0.0f;
    private float lastPotion = 0.0f;
    private int[] lastLightmapValues = new int[]{-16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216};
    private boolean lastBeneathRendering = false;
    private boolean needSkyColor = false;
    private boolean lastAboveHorizon = true;
    private int lastBiome = 0;
    private int lastSkyColor = 0;
    private Random generator = new Random();
    private boolean showWelcomeScreen = true;
    private class_437 lastGuiScreen = null;
    private boolean enabled = true;
    private boolean fullscreenMap = false;
    private boolean active = false;
    private int zoom = 2;
    private int mapX = 37;
    private int mapY = 37;
    private int scWidth;
    private int scHeight;
    private String error = "";
    private class_2561[] welcomeText = new class_2561[8];
    private int ztimer = 0;
    private int heightMapFudge = 0;
    private int timer = 0;
    private boolean doFullRender = true;
    private boolean zoomChanged;
    private int lastX = 0;
    private int lastZ = 0;
    private int lastY = 0;
    private int lastImageX = 0;
    private int lastImageZ = 0;
    private boolean lastFullscreen = false;
    private float direction = 0.0f;
    private float percentX;
    private float percentY;
    private String subworldName = "";
    private int heightMapResetHeight = this.multicore ? 2 : 5;
    private int heightMapResetTime = this.multicore ? 300 : 3000;
    private int northRotate = 0;
    private Thread zCalc = new Thread((Runnable)this, "Voxelmap LiveMap Calculation Thread");
    private int zCalcTicker = 0;
    private boolean threading = this.multicore;
    private class_327 fontRenderer;
    private int[] lightmapColors = new int[256];
    private final Object coordinateLock = new Object();
    private final int SEAFLOORLAYER = 0;
    private final int GROUNDLAYER = 1;
    private final int FOLIAGELAYER = 2;
    private final int TRANSPARENTLAYER = 3;
    private double zoomScale = 1.0;
    private double zoomScaleAdjusted = 1.0;
    private final float SQRT2 = 1.4142f;
    private final class_2960 arrowResourceLocation = new class_2960("voxelmap", "images/mmarrow.png");
    private final class_2960 roundmapResourceLocation = new class_2960("voxelmap", "images/roundmap.png");
    private final class_2960 squareStencil = new class_2960("voxelmap", "images/square.png");
    private final class_2960 circleStencil = new class_2960("voxelmap", "images/circle.png");
    LiveScaledGLBufferedImage roundImage = new LiveScaledGLBufferedImage(128, 128, 6);
    private int mapImageInt = -1;

    public Map(IVoxelMap master) {
        this.master = master;
        this.game = GameVariableAccessShim.getMinecraft();
        this.options = master.getMapOptions();
        this.colorManager = master.getColorManager();
        this.waypointManager = master.getWaypointManager();
        this.layoutVariables = new LayoutVariables();
        ArrayList<class_304> tempBindings = new ArrayList<class_304>();
        tempBindings.addAll(Arrays.asList(this.game.field_1690.field_1839));
        tempBindings.addAll(Arrays.asList(this.options.keyBindings));
        Field f = ReflectionUtils.getFieldByType(this.game.field_1690, class_315.class, class_304[].class, 1);
        try {
            f.set(this.game.field_1690, tempBindings.toArray(new class_304[tempBindings.size()]));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        java.util.Map categoryOrder = (java.util.Map)ReflectionUtils.getPrivateFieldValueByType(null, class_304.class, java.util.Map.class, 2);
        System.out.println("CATEGORY ORDER IS " + categoryOrder.size());
        Integer categoryPlace = (Integer)categoryOrder.get("controls.minimap.title");
        if (categoryPlace == null) {
            int currentSize = categoryOrder.size();
            categoryOrder.put("controls.minimap.title", currentSize + 1);
        }
        this.showWelcomeScreen = this.options.welcome;
        this.zCalc.start();
        this.zCalc.setPriority(5);
        this.mapData[0] = new FullMapData(32, 32);
        this.mapData[1] = new FullMapData(64, 64);
        this.mapData[2] = new FullMapData(128, 128);
        this.mapData[3] = new FullMapData(256, 256);
        this.mapData[4] = new FullMapData(512, 512);
        this.chunkCache[0] = new MapChunkCache(3, 3, this);
        this.chunkCache[1] = new MapChunkCache(5, 5, this);
        this.chunkCache[2] = new MapChunkCache(9, 9, this);
        this.chunkCache[3] = new MapChunkCache(17, 17, this);
        this.chunkCache[4] = new MapChunkCache(33, 33, this);
        this.mapImagesFiltered[0] = new LiveGLBufferedImage(32, 32, 6);
        this.mapImagesFiltered[1] = new LiveGLBufferedImage(64, 64, 6);
        this.mapImagesFiltered[2] = new LiveGLBufferedImage(128, 128, 6);
        this.mapImagesFiltered[3] = new LiveGLBufferedImage(256, 256, 6);
        this.mapImagesFiltered[4] = new LiveGLBufferedImage(512, 512, 6);
        this.mapImagesUnfiltered[0] = new LiveScaledGLBufferedImage(32, 32, 6);
        this.mapImagesUnfiltered[1] = new LiveScaledGLBufferedImage(64, 64, 6);
        this.mapImagesUnfiltered[2] = new LiveScaledGLBufferedImage(128, 128, 6);
        this.mapImagesUnfiltered[3] = new LiveScaledGLBufferedImage(256, 256, 6);
        this.mapImagesUnfiltered[4] = new LiveScaledGLBufferedImage(512, 512, 6);
        this.mapImages = this.options.filtering ? this.mapImagesFiltered : this.mapImagesUnfiltered;
        GLUtils.setupFrameBuffer();
        this.fontRenderer = this.game.field_1772;
        this.zoom = this.options.zoom;
        this.setZoomScale();
    }

    @Override
    public void forceFullRender(boolean forceFullRender) {
        this.doFullRender = forceFullRender;
        this.master.getSettingsAndLightingChangeNotifier().notifyOfChanges();
    }

    @Override
    public float getPercentX() {
        return this.percentX;
    }

    @Override
    public float getPercentY() {
        return this.percentY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.game == null) {
            return;
        }
        while (true) {
            Thread thread;
            if (this.threading) {
                this.active = true;
                while (this.game.field_1724 != null && this.world != null && this.active) {
                    if (!this.options.hide) {
                        try {
                            this.mapCalc(this.doFullRender);
                            if (!this.doFullRender) {
                                this.chunkCache[this.zoom].centerChunks(this.blockPos.withXYZ(this.lastX, 0, this.lastZ));
                                this.chunkCache[this.zoom].checkIfChunksChanged();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.doFullRender = this.zoomChanged;
                    this.zoomChanged = false;
                    this.active = false;
                }
                this.zCalcTicker = 0;
                thread = this.zCalc;
                synchronized (thread) {
                    try {
                        this.zCalc.wait(0L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            thread = this.zCalc;
            synchronized (thread) {
                try {
                    this.zCalc.wait(0L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void newWorld(class_638 world) {
        this.world = world;
        this.lightmapTexture = this.getLightmapTexture();
        this.mapData[this.zoom].blank();
        this.mapImages[this.zoom].blank();
        this.doFullRender = true;
        this.master.getSettingsAndLightingChangeNotifier().notifyOfChanges();
    }

    @Override
    public void newWorldName() {
        this.subworldName = this.waypointManager.getCurrentSubworldDescriptor(true);
        StringBuilder subworldNameBuilder = new StringBuilder("\u00a7r").append(I18nUtils.getString("worldmap.multiworld.newworld", new Object[0])).append(":").append(" ");
        if (this.subworldName.equals("") && this.waypointManager.isMultiworld()) {
            subworldNameBuilder.append("???");
        } else if (!this.subworldName.equals("")) {
            subworldNameBuilder.append(this.subworldName);
        }
        this.error = subworldNameBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTickInGame(class_4587 matrixStack, class_310 mc) {
        int n = this.northRotate = this.options.oldNorth ? 90 : 0;
        if (this.game == null) {
            this.game = mc;
        }
        if (this.lightmapTexture == null) {
            this.lightmapTexture = this.getLightmapTexture();
        }
        if (this.game.field_1755 == null && this.options.keyBindMenu.method_1436()) {
            this.showWelcomeScreen = false;
            if (this.options.welcome) {
                this.options.welcome = false;
                this.options.saveAll();
            }
            this.game.method_1507((class_437)new GuiPersistentMap(null, this.master));
        }
        if (this.game.field_1755 == null && this.options.keyBindWaypointMenu.method_1436()) {
            this.showWelcomeScreen = false;
            if (this.options.welcome) {
                this.options.welcome = false;
                this.options.saveAll();
            }
            this.game.method_1507((class_437)new GuiWaypoints(null, this.master));
        }
        if (this.game.field_1755 == null && this.options.keyBindWaypoint.method_1436()) {
            float b;
            float g;
            float r;
            this.showWelcomeScreen = false;
            if (this.options.welcome) {
                this.options.welcome = false;
                this.options.saveAll();
            }
            if (this.waypointManager.getWaypoints().size() == 0) {
                r = 0.0f;
                g = 1.0f;
                b = 0.0f;
            } else {
                r = this.generator.nextFloat();
                g = this.generator.nextFloat();
                b = this.generator.nextFloat();
            }
            TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
            dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByWorld((class_1937)this.game.field_1687));
            double dimensionScale = this.game.field_1724.field_6002.method_8597().method_31110();
            Waypoint newWaypoint = new Waypoint("", (int)((double)GameVariableAccessShim.xCoord() * dimensionScale), (int)((double)GameVariableAccessShim.zCoord() * dimensionScale), GameVariableAccessShim.yCoord(), true, r, g, b, "", this.master.getWaypointManager().getCurrentSubworldDescriptor(false), dimensions);
            this.game.method_1507((class_437)new GuiAddWaypoint(null, this.master, newWaypoint, false));
        }
        if (this.game.field_1755 == null && this.options.keyBindMobToggle.method_1436()) {
            this.master.getRadarOptions().setOptionValue(EnumOptionsMinimap.SHOWRADAR);
            this.options.saveAll();
        }
        if (this.game.field_1755 == null && this.options.keyBindWaypointToggle.method_1436()) {
            this.options.toggleIngameWaypoints();
        }
        if (this.game.field_1755 == null && this.options.keyBindZoom.method_1436()) {
            this.showWelcomeScreen = false;
            if (this.options.welcome) {
                this.options.welcome = false;
                this.options.saveAll();
            } else {
                this.cycleZoomLevel();
            }
        }
        if (this.game.field_1755 == null && this.options.keyBindFullscreen.method_1436()) {
            boolean bl = this.fullscreenMap = !this.fullscreenMap;
            this.error = this.zoom == 4 ? I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (0.25x)" : (this.zoom == 3 ? I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (0.5x)" : (this.zoom == 2 ? I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (1.0x)" : (this.zoom == 1 ? I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (2.0x)" : I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (4.0x)")));
        }
        this.checkForChanges();
        if (this.game.field_1755 instanceof class_418 && !(this.lastGuiScreen instanceof class_418)) {
            this.waypointManager.handleDeath();
        }
        this.lastGuiScreen = this.game.field_1755;
        this.calculateCurrentLightAndSkyColor();
        if (this.threading) {
            if (!this.zCalc.isAlive() && this.threading) {
                this.zCalc = new Thread((Runnable)this, "Voxelmap LiveMap Calculation Thread");
                this.zCalc.setPriority(5);
                this.zCalc.start();
            }
            if (!(this.game.field_1755 instanceof class_418) && !(this.game.field_1755 instanceof class_428)) {
                ++this.zCalcTicker;
                if (this.zCalcTicker > 2000) {
                    this.zCalcTicker = 0;
                    this.zCalc.stop();
                } else {
                    Thread thread = this.zCalc;
                    synchronized (thread) {
                        this.zCalc.notify();
                    }
                }
            }
        } else if (!this.threading) {
            if (!this.options.hide && this.world != null) {
                this.mapCalc(this.doFullRender);
                if (!this.doFullRender) {
                    this.chunkCache[this.zoom].centerChunks(this.blockPos.withXYZ(this.lastX, 0, this.lastZ));
                    this.chunkCache[this.zoom].checkIfChunksChanged();
                }
            }
            this.doFullRender = false;
        }
        this.enabled = !mc.field_1690.field_1842 && (this.options.showUnderMenus || this.game.field_1755 == null) && !this.game.field_1690.field_1866;
        this.direction = GameVariableAccessShim.rotationYaw() + 180.0f;
        while (this.direction >= 360.0f) {
            this.direction -= 360.0f;
        }
        while (this.direction < 0.0f) {
            this.direction += 360.0f;
        }
        if (!this.error.equals("") && this.ztimer == 0) {
            this.ztimer = 500;
        }
        if (this.ztimer > 0) {
            --this.ztimer;
        }
        if (this.ztimer == 0 && !this.error.equals("")) {
            this.error = "";
        }
        if (this.enabled) {
            this.drawMinimap(matrixStack, mc);
        }
        this.timer = this.timer > 5000 ? 0 : this.timer + 1;
    }

    private void cycleZoomLevel() {
        if (this.options.zoom == 4) {
            this.options.zoom = 3;
            this.error = I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (0.5x)";
        } else if (this.options.zoom == 3) {
            this.options.zoom = 2;
            this.error = I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (1.0x)";
        } else if (this.options.zoom == 2) {
            this.options.zoom = 1;
            this.error = I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (2.0x)";
        } else if (this.options.zoom == 1) {
            this.options.zoom = 0;
            this.error = I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (4.0x)";
        } else if (this.options.zoom == 0) {
            if (this.multicore && class_316.field_1933.method_18613(this.game.field_1690) > 8.0) {
                this.options.zoom = 4;
                this.error = I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (0.25x)";
            } else {
                this.options.zoom = 3;
                this.error = I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (0.5x)";
            }
        }
        this.options.saveAll();
        this.zoomChanged = true;
        this.zoom = this.options.zoom;
        this.setZoomScale();
        this.mapImages[this.zoom].blank();
        this.doFullRender = true;
    }

    private void setZoomScale() {
        this.zoomScale = Math.pow(2.0, this.zoom) / 2.0;
        if (this.options.squareMap && this.options.rotates) {
            this.getClass();
            this.zoomScaleAdjusted = this.zoomScale / (double)1.4142f;
        } else {
            this.zoomScaleAdjusted = this.zoomScale;
        }
    }

    private class_1043 getLightmapTexture() {
        class_765 lightTextureManager = this.game.field_1773.method_22974();
        Object lightmapTextureObj = ReflectionUtils.getPrivateFieldValueByType(lightTextureManager, class_765.class, class_1043.class);
        if (lightmapTextureObj == null) {
            return null;
        }
        return (class_1043)lightmapTextureObj;
    }

    public void calculateCurrentLightAndSkyColor() {
        int biomeID;
        boolean aboveHorizon;
        boolean scheduledUpdate;
        int lastLightningBolt;
        int t;
        if (this.world == null) {
            return;
        }
        if (this.needLightmapRefresh && TickCounter.tickCounter != this.tickWithLightChange && !this.game.method_1493() || this.options.realTimeTorches) {
            GLUtils.disp(this.lightmapTexture.method_4624());
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1024).order(ByteOrder.nativeOrder());
            GLShim.glGetTexImage(3553, 0, 6408, 5121, byteBuffer);
            for (int i = 0; i < this.lightmapColors.length; ++i) {
                int index = i * 4;
                this.lightmapColors[i] = (byteBuffer.get(index + 3) << 24) + (byteBuffer.get(index) << 16) + (byteBuffer.get(index + 1) << 8) + (byteBuffer.get(index + 2) << 0);
            }
            if (this.lightmapColors[255] != 0) {
                this.needLightmapRefresh = false;
            }
        }
        boolean lightChanged = false;
        if (this.game.field_1690.field_1840 != this.lastGamma) {
            lightChanged = true;
            this.lastGamma = this.game.field_1690.field_1840;
        }
        float[] providerLightBrightnessTable = new float[16];
        for (t = 0; t < 16; ++t) {
            providerLightBrightnessTable[t] = this.world.method_8597().method_28516(t);
        }
        for (t = 0; t < 16; ++t) {
            if (providerLightBrightnessTable[t] == this.lastLightBrightnessTable[t]) continue;
            lightChanged = true;
            this.lastLightBrightnessTable[t] = providerLightBrightnessTable[t];
        }
        float sunBrightness = this.world.method_23783(1.0f);
        if ((double)Math.abs(this.lastSunBrightness - sunBrightness) > 0.01 || (double)sunBrightness == 1.0 && sunBrightness != this.lastSunBrightness || (double)sunBrightness == 0.0 && sunBrightness != this.lastSunBrightness) {
            lightChanged = true;
            this.needSkyColor = true;
            this.lastSunBrightness = sunBrightness;
        }
        float potionEffect = 0.0f;
        if (this.game.field_1724.method_6059(class_1294.field_5925)) {
            int duration = this.game.field_1724.method_6112(class_1294.field_5925).method_5584();
            float f = potionEffect = duration > 200 ? 1.0f : 0.7f + class_3532.method_15374((float)(((float)duration - 1.0f) * (float)Math.PI * 0.2f)) * 0.3f;
        }
        if (this.lastPotion != potionEffect) {
            this.lastPotion = potionEffect;
            lightChanged = true;
        }
        if (this.lastLightning != (float)(lastLightningBolt = this.world.method_23789())) {
            this.lastLightning = lastLightningBolt;
            lightChanged = true;
        }
        if (this.lastPaused != this.game.method_1493()) {
            this.lastPaused = !this.lastPaused;
            lightChanged = true;
        }
        boolean bl = scheduledUpdate = (this.timer - 50) % (this.lastLightBrightnessTable[0] == 0.0f ? 250 : 2000) == 0;
        if (lightChanged || scheduledUpdate) {
            this.tickWithLightChange = TickCounter.tickCounter;
            lightChanged = false;
            this.needLightmapRefresh = true;
        }
        boolean bl2 = aboveHorizon = this.game.field_1724.method_5836((float)0.0f).field_1351 >= this.world.method_28104().method_28105();
        if (this.world.method_27983().method_29177().toString().toLowerCase().contains("ether")) {
            aboveHorizon = true;
        }
        if (aboveHorizon != this.lastAboveHorizon) {
            this.needSkyColor = true;
            this.lastAboveHorizon = aboveHorizon;
        }
        if ((biomeID = this.world.method_30349().method_30530(class_2378.field_25114).method_10206((Object)this.world.method_23753((class_2338)this.blockPos.withXYZ(GameVariableAccessShim.xCoord(), GameVariableAccessShim.yCoord(), GameVariableAccessShim.zCoord())))) != this.lastBiome) {
            this.needSkyColor = true;
            this.lastBiome = biomeID;
        }
        if (this.needSkyColor || scheduledUpdate) {
            this.colorManager.setSkyColor(this.getSkyColor());
        }
    }

    private int getSkyColor() {
        this.needSkyColor = false;
        boolean aboveHorizon = this.lastAboveHorizon;
        float[] fogColors = new float[4];
        FloatBuffer temp = BufferUtils.createFloatBuffer((int)4);
        class_758.method_3210((class_4184)this.game.field_1773.method_19418(), (float)0.0f, (class_638)this.world, (int)this.game.field_1690.field_1870, (float)this.game.field_1773.method_3195(0.0f));
        GLShim.glGetFloatv(3106, temp);
        temp.get(fogColors);
        float r = fogColors[0];
        float g = fogColors[1];
        float b = fogColors[2];
        if (!aboveHorizon && this.game.field_1690.field_1870 >= 4) {
            return 0xA000000 + (int)(r * 255.0f) * 65536 + (int)(g * 255.0f) * 256 + (int)(b * 255.0f);
        }
        int backgroundColor = -16777216 + (int)(r * 255.0f) * 65536 + (int)(g * 255.0f) * 256 + (int)(b * 255.0f);
        float[] sunsetColors = this.world.method_28103().method_28109(this.world.method_30274(0.0f), 0.0f);
        if (sunsetColors != null && this.game.field_1690.field_1870 >= 4) {
            int sunsetColor = (int)(sunsetColors[3] * 128.0f) * 0x1000000 + (int)(sunsetColors[0] * 255.0f) * 65536 + (int)(sunsetColors[1] * 255.0f) * 256 + (int)(sunsetColors[2] * 255.0f);
            return ColorUtils.colorAdder(sunsetColor, backgroundColor);
        }
        return backgroundColor;
    }

    @Override
    public int[] getLightmapArray() {
        return this.lightmapColors;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void drawMinimap(class_4587 matrixStack, class_310 mc) {
        scScaleOrig = 1;
        while (this.game.method_22683().method_4489() / (scScaleOrig + 1) >= 320 && this.game.method_22683().method_4506() / (scScaleOrig + 1) >= 240) {
            ++scScaleOrig;
        }
        scScale = scScaleOrig + (this.fullscreenMap != false ? 0 : this.options.sizeModifier);
        scaledWidthD = (double)this.game.method_22683().method_4489() / (double)scScale;
        scaledHeightD = (double)this.game.method_22683().method_4506() / (double)scScale;
        this.scWidth = class_3532.method_15384((double)scaledWidthD);
        this.scHeight = class_3532.method_15384((double)scaledHeightD);
        GLShim.glMatrixMode(5889);
        GLShim.glPushMatrix();
        GLShim.glLoadIdentity();
        GLShim.glOrtho(0.0, scaledWidthD, scaledHeightD, 0.0, 1000.0, 3000.0);
        GLShim.glMatrixMode(5888);
        GLShim.glPushMatrix();
        GLShim.glLoadIdentity();
        GLShim.glTranslatef(0.0f, 0.0f, -2000.0f);
        v0 = this.options.mapCorner;
        this.options.getClass();
        if (v0 == 0) ** GOTO lbl-1000
        v1 = this.options.mapCorner;
        this.options.getClass();
        if (v1 == 3) lbl-1000:
        // 2 sources

        {
            this.mapX = 37;
        } else {
            this.mapX = this.scWidth - 37;
        }
        v2 = this.options.mapCorner;
        this.options.getClass();
        if (v2 == 0) ** GOTO lbl-1000
        v3 = this.options.mapCorner;
        this.options.getClass();
        if (v3 == 1) lbl-1000:
        // 2 sources

        {
            this.mapY = 37;
        } else {
            this.mapY = this.scHeight - 37;
        }
        v4 = this.options.mapCorner;
        this.options.getClass();
        if (v4 == 1 && this.game.field_1724.method_6026().size() > 0) {
            statusIconOffset = 0.0f;
            statusEffectInstances = this.game.field_1724.method_6026();
            for (class_1293 statusEffectInstance : statusEffectInstances) {
                if (!statusEffectInstance.method_5592()) continue;
                if (statusEffectInstance.method_5579().method_5573()) {
                    statusIconOffset = Math.max(statusIconOffset, 24.0f);
                    continue;
                }
                statusIconOffset = Math.max(statusIconOffset, 50.0f);
            }
            scHeight = this.game.method_22683().method_4502();
            resFactor = (float)this.scHeight / (float)scHeight;
            this.mapY += (int)(statusIconOffset * resFactor);
        }
        GLShim.glEnable(3042);
        GLShim.glEnable(3553);
        GLShim.glBlendFunc(770, 0);
        GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (!this.options.hide) {
            if (this.fullscreenMap) {
                this.renderMapFull(matrixStack, this.scWidth, this.scHeight);
            } else {
                this.renderMap(this.mapX, this.mapY, scScale);
            }
            GLShim.glDisable(2929);
            if (this.master.getRadar() != null && !this.fullscreenMap) {
                this.layoutVariables.updateVars(scScale, this.mapX, this.mapY, this.zoomScale, this.zoomScaleAdjusted);
                this.master.getRadar().OnTickInGame(mc, this.layoutVariables);
            }
            if (!this.fullscreenMap) {
                this.drawDirections(matrixStack, this.mapX, this.mapY);
            }
            GLShim.glEnable(3042);
            if (this.fullscreenMap) {
                this.drawArrow(this.scWidth / 2, this.scHeight / 2);
            } else {
                this.drawArrow(this.mapX, this.mapY);
            }
        }
        if (this.options.coords) {
            this.showCoords(matrixStack, this.mapX, this.mapY);
        }
        GLShim.glMatrixMode(5889);
        GLShim.glPopMatrix();
        GLShim.glMatrixMode(5888);
        GLShim.glPopMatrix();
        if (this.showWelcomeScreen) {
            GLShim.glEnable(3042);
            this.drawWelcomeScreen(matrixStack, this.game.method_22683().method_4486(), this.game.method_22683().method_4502());
        }
        GLShim.glDepthMask(true);
        GLShim.glEnable(2929);
        GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLShim.glTexParameteri(3553, 10241, 9728);
        GLShim.glTexParameteri(3553, 10240, 9728);
    }

    private void checkForChanges() {
        boolean changed = false;
        if (this.colorManager.checkForChanges()) {
            this.loadMapImage();
            changed = true;
        }
        if (this.options.isChanged()) {
            this.mapImages = this.options.filtering ? this.mapImagesFiltered : this.mapImagesUnfiltered;
            changed = true;
            this.setZoomScale();
        }
        if (changed) {
            this.doFullRender = true;
            this.master.getSettingsAndLightingChangeNotifier().notifyOfChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapCalc(boolean full) {
        int imageX;
        int imageY;
        boolean beneathRendering;
        int currentX = GameVariableAccessShim.xCoord();
        int currentZ = GameVariableAccessShim.zCoord();
        int currentY = GameVariableAccessShim.yCoord();
        int offsetX = currentX - this.lastX;
        int offsetZ = currentZ - this.lastZ;
        int offsetY = currentY - this.lastY;
        int multi = (int)Math.pow(2.0, this.zoom);
        boolean needHeightAndID = false;
        boolean needHeightMap = false;
        boolean needLight = false;
        boolean skyColorChanged = false;
        int skyColor = this.colorManager.getAirColor();
        if (this.lastSkyColor != skyColor) {
            skyColorChanged = true;
            this.lastSkyColor = skyColor;
        }
        if (this.options.lightmap) {
            int torchOffset = this.options.realTimeTorches ? 8 : 0;
            int skylightMultiplier = 16;
            for (int t = 0; t < 16; ++t) {
                if (this.lastLightmapValues[t] == this.lightmapColors[t * skylightMultiplier + torchOffset]) continue;
                needLight = true;
                this.lastLightmapValues[t] = this.lightmapColors[t * skylightMultiplier + torchOffset];
            }
        }
        if (offsetY != 0) {
            ++this.heightMapFudge;
        } else if (this.heightMapFudge != 0) {
            ++this.heightMapFudge;
        }
        if (full || Math.abs(offsetY) >= this.heightMapResetHeight || this.heightMapFudge > this.heightMapResetTime) {
            if (this.lastY != currentY) {
                needHeightMap = true;
            }
            this.lastY = currentY;
            this.heightMapFudge = 0;
        }
        if (Math.abs(offsetX) > 32 * multi || Math.abs(offsetZ) > 32 * multi) {
            full = true;
        }
        boolean nether = false;
        boolean caves = false;
        boolean netherPlayerInOpen = false;
        this.blockPos.setXYZ(this.lastX, Math.max(Math.min(GameVariableAccessShim.yCoord(), this.WORLD_HEIGHT - 1), 0), this.lastZ);
        if (this.game.field_1724.field_6002.method_8597().method_27998()) {
            netherPlayerInOpen = this.world.method_22350((class_2338)this.blockPos).method_12005(class_2902.class_2903.field_13197, this.blockPos.method_10263() & 0xF, this.blockPos.method_10260() & 0xF) <= currentY;
            boolean bl = nether = currentY < 126;
            if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && currentY >= 126 && !netherPlayerInOpen) {
                caves = true;
            }
        } else if (this.game.field_1724.field_17892.method_28103().method_28114() && !this.game.field_1724.field_17892.method_8597().method_12491()) {
            boolean endPlayerInOpen;
            boolean bl = endPlayerInOpen = this.world.method_22350((class_2338)this.blockPos).method_12005(class_2902.class_2903.field_13197, this.blockPos.method_10263() & 0xF, this.blockPos.method_10260() & 0xF) <= currentY;
            if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && !endPlayerInOpen) {
                caves = true;
            }
        } else if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && this.world.method_8314(class_1944.field_9284, (class_2338)this.blockPos) <= 0) {
            caves = true;
        }
        boolean bl = beneathRendering = caves || nether;
        if (this.lastBeneathRendering != beneathRendering) {
            full = true;
        }
        this.lastBeneathRendering = beneathRendering;
        needHeightAndID = needHeightMap && (nether || caves);
        int color24 = -1;
        Object object = this.coordinateLock;
        synchronized (object) {
            if (!full) {
                this.mapImages[this.zoom].moveY(offsetZ);
                this.mapImages[this.zoom].moveX(offsetX);
            }
            this.lastX = currentX;
            this.lastZ = currentZ;
        }
        int startX = currentX - 16 * multi;
        int startZ = currentZ - 16 * multi;
        if (!full) {
            this.mapData[this.zoom].moveZ(offsetZ);
            this.mapData[this.zoom].moveX(offsetX);
            for (imageY = offsetZ > 0 ? 32 * multi - 1 : -offsetZ - 1; imageY >= (offsetZ > 0 ? 32 * multi - offsetZ : 0); --imageY) {
                for (imageX = 0; imageX < 32 * multi; ++imageX) {
                    color24 = this.getPixelColor(true, true, true, true, nether, caves, this.world, multi, startX, startZ, imageX, imageY);
                    this.mapImages[this.zoom].setRGB(imageX, imageY, color24);
                }
            }
            for (imageY = 32 * multi - 1; imageY >= 0; --imageY) {
                for (imageX = offsetX > 0 ? 32 * multi - offsetX : 0; imageX < (offsetX > 0 ? 32 * multi : -offsetX); ++imageX) {
                    color24 = this.getPixelColor(true, true, true, true, nether, caves, this.world, multi, startX, startZ, imageX, imageY);
                    this.mapImages[this.zoom].setRGB(imageX, imageY, color24);
                }
            }
        }
        if (full || this.options.heightmap && needHeightMap || needHeightAndID || this.options.lightmap && needLight || skyColorChanged) {
            for (imageY = 32 * multi - 1; imageY >= 0; --imageY) {
                for (imageX = 0; imageX < 32 * multi; ++imageX) {
                    color24 = this.getPixelColor(full, full || needHeightAndID, full, full || needLight || needHeightAndID, nether, caves, this.world, multi, startX, startZ, imageX, imageY);
                    this.mapImages[this.zoom].setRGB(imageX, imageY, color24);
                }
            }
        }
        if ((full || offsetX != 0 || offsetZ != 0 || !this.lastFullscreen) && this.fullscreenMap) {
            int n = this.options.biomeOverlay;
            this.options.getClass();
            if (n != 0) {
                this.mapData[this.zoom].segmentBiomes();
                this.mapData[this.zoom].findCenterOfSegments(!this.options.oldNorth);
            }
        }
        this.lastFullscreen = this.fullscreenMap;
        if (full || offsetX != 0 || offsetZ != 0 || needHeightMap || needLight || skyColorChanged) {
            this.imageChanged = true;
        }
        if (needLight || skyColorChanged) {
            this.master.getSettingsAndLightingChangeNotifier().notifyOfChanges();
        }
    }

    @Override
    public void handleChangeInWorld(int chunkX, int chunkZ) {
        this.chunkCache[this.zoom].registerChangeAt(chunkX, chunkZ);
    }

    @Override
    public void processChunk(class_2818 chunk) {
        this.rectangleCalc(chunk.method_12004().field_9181 * 16, chunk.method_12004().field_9180 * 16, chunk.method_12004().field_9181 * 16 + 15, chunk.method_12004().field_9180 * 16 + 15);
    }

    private void rectangleCalc(int left, int top, int right, int bottom) {
        boolean nether = false;
        boolean caves = false;
        boolean netherPlayerInOpen = false;
        this.blockPos.setXYZ(this.lastX, Math.max(Math.min(GameVariableAccessShim.yCoord(), this.WORLD_HEIGHT - 1), 0), this.lastZ);
        int currentY = GameVariableAccessShim.yCoord();
        if (this.game.field_1724.field_6002.method_8597().method_27998()) {
            netherPlayerInOpen = this.world.method_22350((class_2338)this.blockPos).method_12005(class_2902.class_2903.field_13197, this.blockPos.method_10263() & 0xF, this.blockPos.method_10260() & 0xF) <= currentY;
            boolean bl = nether = currentY < 126;
            if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && currentY >= 126 && !netherPlayerInOpen) {
                caves = true;
            }
        } else if (this.game.field_1724.field_17892.method_28103().method_28114() && !this.game.field_1724.field_17892.method_8597().method_12491()) {
            boolean endPlayerInOpen;
            boolean bl = endPlayerInOpen = this.world.method_22350((class_2338)this.blockPos).method_12005(class_2902.class_2903.field_13197, this.blockPos.method_10263() & 0xF, this.blockPos.method_10260() & 0xF) <= currentY;
            if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && !endPlayerInOpen) {
                caves = true;
            }
        } else if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && this.world.method_8314(class_1944.field_9284, (class_2338)this.blockPos) <= 0) {
            caves = true;
        }
        int startX = this.lastX;
        int startZ = this.lastZ;
        int multi = (int)Math.pow(2.0, this.zoom);
        left = left - (startX -= 16 * multi) - 1;
        right = right - startX + 1;
        top = top - (startZ -= 16 * multi) - 1;
        bottom = bottom - startZ + 1;
        left = Math.max(0, left);
        right = Math.min(32 * multi - 1, right);
        top = Math.max(0, top);
        bottom = Math.min(32 * multi - 1, bottom);
        int color24 = 0;
        for (int imageY = bottom; imageY >= top; --imageY) {
            for (int imageX = left; imageX <= right; ++imageX) {
                color24 = this.getPixelColor(true, true, true, true, nether, caves, this.world, multi, startX, startZ, imageX, imageY);
                this.mapImages[this.zoom].setRGB(imageX, imageY, color24);
            }
        }
        this.imageChanged = true;
    }

    private int getPixelColor(boolean needBiome, boolean needHeightAndID, boolean needTint, boolean needLight, boolean nether, boolean caves, class_638 world, int multi, int startX, int startZ, int imageX, int imageY) {
        int light;
        int surfaceHeight = 0;
        int seafloorHeight = -1;
        int transparentHeight = -1;
        int foliageHeight = -1;
        int surfaceColor = 0;
        int seafloorColor = 0;
        int transparentColor = 0;
        int foliageColor = 0;
        this.surfaceBlockState = null;
        this.transparentBlockState = BlockRepository.air.method_9564();
        this.foliageBlockState = BlockRepository.air.method_9564();
        this.seafloorBlockState = BlockRepository.air.method_9564();
        boolean surfaceBlockChangeForcedTint = false;
        boolean transparentBlockChangeForcedTint = false;
        boolean foliageBlockChangeForcedTint = false;
        boolean seafloorBlockChangeForcedTint = false;
        int surfaceBlockStateID = 0;
        int transparentBlockStateID = 0;
        int foliageBlockStateID = 0;
        int seafloorBlockStateID = 0;
        this.blockPos = this.blockPos.withXYZ(startX + imageX, 0, startZ + imageY);
        int color24 = 0;
        int biomeID = 0;
        if (needBiome) {
            biomeID = world.method_22340((class_2338)this.blockPos) ? world.method_30349().method_30530(class_2378.field_25114).method_10206((Object)world.method_23753((class_2338)this.blockPos)) : -1;
            this.mapData[this.zoom].setBiomeID(imageX, imageY, biomeID);
        } else {
            biomeID = this.mapData[this.zoom].getBiomeID(imageX, imageY);
        }
        int n = this.options.biomeOverlay;
        this.options.getClass();
        if (n == 1) {
            color24 = biomeID >= 0 ? BiomeRepository.getBiomeColor(biomeID) | 0xFF000000 : 0;
            color24 = MapUtils.doSlimeAndGrid(color24, startX + imageX, startZ + imageY);
            return color24;
        }
        boolean solid = false;
        if (needHeightAndID) {
            if (nether || caves) {
                surfaceHeight = this.getNetherHeight(nether, startX + imageX, startZ + imageY);
                this.surfaceBlockState = world.method_8320((class_2338)this.blockPos.withXYZ(startX + imageX, surfaceHeight - 1, startZ + imageY));
                surfaceBlockStateID = BlockRepository.getStateId(this.surfaceBlockState);
                foliageHeight = surfaceHeight + 1;
                this.blockPos.setXYZ(startX + imageX, foliageHeight - 1, startZ + imageY);
                this.foliageBlockState = world.method_8320((class_2338)this.blockPos);
                class_3614 material = this.foliageBlockState.method_26207();
                if (material == class_3614.field_15948 || material == class_3614.field_15959 || material == class_3614.field_15922 || material == class_3614.field_15920) {
                    foliageHeight = -1;
                } else {
                    foliageBlockStateID = BlockRepository.getStateId(this.foliageBlockState);
                }
            } else {
                boolean hasOpacity;
                class_2818 chunk = world.method_8500((class_2338)this.blockPos);
                transparentHeight = chunk.method_12005(class_2902.class_2903.field_13197, this.blockPos.method_10263() & 0xF, this.blockPos.method_10260() & 0xF) + 1;
                this.transparentBlockState = world.method_8320((class_2338)this.blockPos.withXYZ(startX + imageX, transparentHeight - 1, startZ + imageY));
                class_3610 fluidState = this.transparentBlockState.method_26227();
                if (fluidState != class_3612.field_15906.method_15785()) {
                    this.transparentBlockState = fluidState.method_15759();
                }
                surfaceHeight = transparentHeight;
                this.surfaceBlockState = this.transparentBlockState;
                class_265 voxelShape = null;
                boolean bl = hasOpacity = this.surfaceBlockState.method_26193((class_1922)world, (class_2338)this.blockPos) > 0;
                if (!hasOpacity && this.surfaceBlockState.method_26225() && this.surfaceBlockState.method_26211()) {
                    voxelShape = this.surfaceBlockState.method_26173((class_1922)world, (class_2338)this.blockPos, class_2350.field_11033);
                    hasOpacity = class_259.method_20713((class_265)voxelShape, (class_265)class_259.method_1073());
                    voxelShape = this.surfaceBlockState.method_26173((class_1922)world, (class_2338)this.blockPos, class_2350.field_11036);
                    boolean bl2 = hasOpacity = hasOpacity || class_259.method_20713((class_265)class_259.method_1073(), (class_265)voxelShape);
                }
                while (!hasOpacity && surfaceHeight > 0) {
                    this.foliageBlockState = this.surfaceBlockState;
                    this.surfaceBlockState = world.method_8320((class_2338)this.blockPos.withXYZ(startX + imageX, --surfaceHeight - 1, startZ + imageY));
                    fluidState = this.surfaceBlockState.method_26227();
                    if (fluidState != class_3612.field_15906.method_15785()) {
                        this.surfaceBlockState = fluidState.method_15759();
                    }
                    if ((hasOpacity = this.surfaceBlockState.method_26193((class_1922)world, (class_2338)this.blockPos) > 0) || !this.surfaceBlockState.method_26225() || !this.surfaceBlockState.method_26211()) continue;
                    voxelShape = this.surfaceBlockState.method_26173((class_1922)world, (class_2338)this.blockPos, class_2350.field_11033);
                    hasOpacity = class_259.method_20713((class_265)voxelShape, (class_265)class_259.method_1073());
                    voxelShape = this.surfaceBlockState.method_26173((class_1922)world, (class_2338)this.blockPos, class_2350.field_11036);
                    hasOpacity = hasOpacity || class_259.method_20713((class_265)class_259.method_1073(), (class_265)voxelShape);
                }
                if (surfaceHeight == transparentHeight) {
                    transparentHeight = -1;
                    this.transparentBlockState = BlockRepository.air.method_9564();
                    this.foliageBlockState = world.method_8320((class_2338)this.blockPos.withXYZ(startX + imageX, surfaceHeight, startZ + imageY));
                }
                if (this.foliageBlockState.method_26207() == class_3614.field_15948) {
                    this.surfaceBlockState = this.foliageBlockState;
                    this.foliageBlockState = BlockRepository.air.method_9564();
                }
                if (this.foliageBlockState == this.transparentBlockState) {
                    this.foliageBlockState = BlockRepository.air.method_9564();
                }
                foliageHeight = this.foliageBlockState == null || this.foliageBlockState.method_26207() == class_3614.field_15959 ? -1 : surfaceHeight + 1;
                class_3614 material = this.surfaceBlockState.method_26207();
                if (material == class_3614.field_15920 || material == class_3614.field_15958) {
                    seafloorHeight = surfaceHeight;
                    this.seafloorBlockState = world.method_8320((class_2338)this.blockPos.withXYZ(startX + imageX, seafloorHeight - 1, startZ + imageY));
                    while (this.seafloorBlockState.method_26193((class_1922)world, (class_2338)this.blockPos) < 5 && this.seafloorBlockState.method_26207() != class_3614.field_15923 && seafloorHeight > 1) {
                        material = this.seafloorBlockState.method_26207();
                        if (transparentHeight == -1 && material != class_3614.field_15958 && material != class_3614.field_15920 && material.method_15801()) {
                            transparentHeight = seafloorHeight;
                            this.transparentBlockState = this.seafloorBlockState;
                        }
                        if (foliageHeight == -1 && seafloorHeight != transparentHeight && this.transparentBlockState != this.seafloorBlockState && material != class_3614.field_15958 && material != class_3614.field_15920 && material != class_3614.field_15959 && material != class_3614.field_15915) {
                            foliageHeight = seafloorHeight;
                            this.foliageBlockState = this.seafloorBlockState;
                        }
                        this.seafloorBlockState = world.method_8320((class_2338)this.blockPos.withXYZ(startX + imageX, --seafloorHeight - 1, startZ + imageY));
                    }
                    if (this.seafloorBlockState.method_26207() == class_3614.field_15920) {
                        this.seafloorBlockState = BlockRepository.air.method_9564();
                    }
                }
            }
            surfaceBlockStateID = BlockRepository.getStateId(this.surfaceBlockState);
            if (this.options.biomes && this.surfaceBlockState != this.mapData[this.zoom].getBlockstate(imageX, imageY)) {
                surfaceBlockChangeForcedTint = true;
            }
            this.mapData[this.zoom].setHeight(imageX, imageY, surfaceHeight);
            this.mapData[this.zoom].setBlockstateID(imageX, imageY, surfaceBlockStateID);
            if (this.options.biomes && this.transparentBlockState != this.mapData[this.zoom].getTransparentBlockstate(imageX, imageY)) {
                transparentBlockChangeForcedTint = true;
            }
            this.mapData[this.zoom].setTransparentHeight(imageX, imageY, transparentHeight);
            transparentBlockStateID = BlockRepository.getStateId(this.transparentBlockState);
            this.mapData[this.zoom].setTransparentBlockstateID(imageX, imageY, transparentBlockStateID);
            if (this.options.biomes && this.foliageBlockState != this.mapData[this.zoom].getFoliageBlockstate(imageX, imageY)) {
                foliageBlockChangeForcedTint = true;
            }
            this.mapData[this.zoom].setFoliageHeight(imageX, imageY, foliageHeight);
            foliageBlockStateID = BlockRepository.getStateId(this.foliageBlockState);
            this.mapData[this.zoom].setFoliageBlockstateID(imageX, imageY, foliageBlockStateID);
            if (this.options.biomes && this.seafloorBlockState != this.mapData[this.zoom].getOceanFloorBlockstate(imageX, imageY)) {
                seafloorBlockChangeForcedTint = true;
            }
            this.mapData[this.zoom].setOceanFloorHeight(imageX, imageY, seafloorHeight);
            seafloorBlockStateID = BlockRepository.getStateId(this.seafloorBlockState);
            this.mapData[this.zoom].setOceanFloorBlockstateID(imageX, imageY, seafloorBlockStateID);
        } else {
            surfaceHeight = this.mapData[this.zoom].getHeight(imageX, imageY);
            surfaceBlockStateID = this.mapData[this.zoom].getBlockstateID(imageX, imageY);
            this.surfaceBlockState = BlockRepository.getStateById(surfaceBlockStateID);
            transparentHeight = this.mapData[this.zoom].getTransparentHeight(imageX, imageY);
            transparentBlockStateID = this.mapData[this.zoom].getTransparentBlockstateID(imageX, imageY);
            this.transparentBlockState = BlockRepository.getStateById(transparentBlockStateID);
            foliageHeight = this.mapData[this.zoom].getFoliageHeight(imageX, imageY);
            foliageBlockStateID = this.mapData[this.zoom].getFoliageBlockstateID(imageX, imageY);
            this.foliageBlockState = BlockRepository.getStateById(foliageBlockStateID);
            seafloorHeight = this.mapData[this.zoom].getOceanFloorHeight(imageX, imageY);
            seafloorBlockStateID = this.mapData[this.zoom].getOceanFloorBlockstateID(imageX, imageY);
            this.seafloorBlockState = BlockRepository.getStateById(seafloorBlockStateID);
        }
        if (surfaceHeight == -1) {
            surfaceHeight = this.lastY + 1;
            solid = true;
        }
        if (this.surfaceBlockState.method_26207() == class_3614.field_15922) {
            solid = false;
        }
        if (this.options.biomes) {
            surfaceColor = this.colorManager.getBlockColor(this.blockPos, surfaceBlockStateID, biomeID);
            int tint = -1;
            if (needTint || surfaceBlockChangeForcedTint) {
                tint = this.colorManager.getBiomeTint(this.mapData[this.zoom], world, this.surfaceBlockState, surfaceBlockStateID, this.blockPos.withXYZ(startX + imageX, surfaceHeight - 1, startZ + imageY), this.tempBlockPos, startX, startZ);
                this.mapData[this.zoom].setBiomeTint(imageX, imageY, tint);
            } else {
                tint = this.mapData[this.zoom].getBiomeTint(imageX, imageY);
            }
            if (tint != -1) {
                surfaceColor = ColorUtils.colorMultiplier(surfaceColor, tint);
            }
        } else {
            surfaceColor = this.colorManager.getBlockColorWithDefaultTint(this.blockPos, surfaceBlockStateID);
        }
        surfaceColor = this.applyHeight(surfaceColor, nether, caves, (class_1937)world, multi, startX, startZ, imageX, imageY, surfaceHeight, solid, 1);
        int n2 = light = solid ? 0 : 255;
        if (needLight) {
            light = this.getLight(surfaceColor, this.surfaceBlockState, (class_1937)world, startX + imageX, startZ + imageY, surfaceHeight, solid);
            this.mapData[this.zoom].setLight(imageX, imageY, light);
        } else {
            light = this.mapData[this.zoom].getLight(imageX, imageY);
        }
        if (light == 0) {
            surfaceColor = 0;
        } else if (light != 255) {
            surfaceColor = ColorUtils.colorMultiplier(surfaceColor, light);
        }
        if (this.options.waterTransparency && seafloorHeight != -1) {
            if (this.options.biomes) {
                seafloorColor = this.colorManager.getBlockColor(this.blockPos, seafloorBlockStateID, biomeID);
                int tint = -1;
                if (needTint || seafloorBlockChangeForcedTint) {
                    tint = this.colorManager.getBiomeTint(this.mapData[this.zoom], world, this.seafloorBlockState, seafloorBlockStateID, this.blockPos.withXYZ(startX + imageX, seafloorHeight - 1, startZ + imageY), this.tempBlockPos, startX, startZ);
                    this.mapData[this.zoom].setOceanFloorBiomeTint(imageX, imageY, tint);
                } else {
                    tint = this.mapData[this.zoom].getOceanFloorBiomeTint(imageX, imageY);
                }
                if (tint != -1) {
                    seafloorColor = ColorUtils.colorMultiplier(seafloorColor, tint);
                }
            } else {
                seafloorColor = this.colorManager.getBlockColorWithDefaultTint(this.blockPos, seafloorBlockStateID);
            }
            seafloorColor = this.applyHeight(seafloorColor, nether, caves, (class_1937)world, multi, startX, startZ, imageX, imageY, seafloorHeight, solid, 0);
            int seafloorLight = 255;
            if (needLight) {
                seafloorLight = this.getLight(seafloorColor, this.seafloorBlockState, (class_1937)world, startX + imageX, startZ + imageY, seafloorHeight, solid);
                this.blockPos.setXYZ(startX + imageX, seafloorHeight, startZ + imageY);
                class_2680 blockStateAbove = world.method_8320((class_2338)this.blockPos);
                class_3614 materialAbove = blockStateAbove.method_26207();
                if (this.options.lightmap && materialAbove == class_3614.field_15958) {
                    int multiplier = 255;
                    if (this.game.field_1690.field_1841 == class_4060.field_18145) {
                        multiplier = 200;
                    } else if (this.game.field_1690.field_1841 == class_4060.field_18146) {
                        multiplier = 120;
                    }
                    seafloorLight = ColorUtils.colorMultiplier(seafloorLight, 0xFF000000 | multiplier << 16 | multiplier << 8 | multiplier);
                }
                this.mapData[this.zoom].setOceanFloorLight(imageX, imageY, seafloorLight);
            } else {
                seafloorLight = this.mapData[this.zoom].getOceanFloorLight(imageX, imageY);
            }
            if (seafloorLight == 0) {
                seafloorColor = 0;
            } else if (seafloorLight != 255) {
                seafloorColor = ColorUtils.colorMultiplier(seafloorColor, seafloorLight);
            }
        }
        if (this.options.blockTransparency) {
            if (transparentHeight != -1 && this.transparentBlockState != null && this.transparentBlockState != BlockRepository.air.method_9564()) {
                if (this.options.biomes) {
                    transparentColor = this.colorManager.getBlockColor(this.blockPos, transparentBlockStateID, biomeID);
                    int tint = -1;
                    if (needTint || transparentBlockChangeForcedTint) {
                        tint = this.colorManager.getBiomeTint(this.mapData[this.zoom], world, this.transparentBlockState, transparentBlockStateID, this.blockPos.withXYZ(startX + imageX, transparentHeight - 1, startZ + imageY), this.tempBlockPos, startX, startZ);
                        this.mapData[this.zoom].setTransparentBiomeTint(imageX, imageY, tint);
                    } else {
                        tint = this.mapData[this.zoom].getTransparentBiomeTint(imageX, imageY);
                    }
                    if (tint != -1) {
                        transparentColor = ColorUtils.colorMultiplier(transparentColor, tint);
                    }
                } else {
                    transparentColor = this.colorManager.getBlockColorWithDefaultTint(this.blockPos, transparentBlockStateID);
                }
                transparentColor = this.applyHeight(transparentColor, nether, caves, (class_1937)world, multi, startX, startZ, imageX, imageY, transparentHeight, solid, 3);
                int transparentLight = 255;
                if (needLight) {
                    transparentLight = this.getLight(transparentColor, this.transparentBlockState, (class_1937)world, startX + imageX, startZ + imageY, transparentHeight, solid);
                    this.mapData[this.zoom].setTransparentLight(imageX, imageY, transparentLight);
                } else {
                    transparentLight = this.mapData[this.zoom].getTransparentLight(imageX, imageY);
                }
                if (transparentLight == 0) {
                    transparentColor = 0;
                } else if (transparentLight != 255) {
                    transparentColor = ColorUtils.colorMultiplier(transparentColor, transparentLight);
                }
            }
            if (foliageHeight != -1 && this.foliageBlockState != null && this.foliageBlockState != BlockRepository.air.method_9564()) {
                if (this.options.biomes) {
                    foliageColor = this.colorManager.getBlockColor(this.blockPos, foliageBlockStateID, biomeID);
                    int tint = -1;
                    if (needTint || foliageBlockChangeForcedTint) {
                        tint = this.colorManager.getBiomeTint(this.mapData[this.zoom], world, this.foliageBlockState, foliageBlockStateID, this.blockPos.withXYZ(startX + imageX, foliageHeight - 1, startZ + imageY), this.tempBlockPos, startX, startZ);
                        this.mapData[this.zoom].setFoliageBiomeTint(imageX, imageY, tint);
                    } else {
                        tint = this.mapData[this.zoom].getFoliageBiomeTint(imageX, imageY);
                    }
                    if (tint != -1) {
                        foliageColor = ColorUtils.colorMultiplier(foliageColor, tint);
                    }
                } else {
                    foliageColor = this.colorManager.getBlockColorWithDefaultTint(this.blockPos, foliageBlockStateID);
                }
                foliageColor = this.applyHeight(foliageColor, nether, caves, (class_1937)world, multi, startX, startZ, imageX, imageY, foliageHeight, solid, 2);
                int foliageLight = 255;
                if (needLight) {
                    foliageLight = this.getLight(foliageColor, this.foliageBlockState, (class_1937)world, startX + imageX, startZ + imageY, foliageHeight, solid);
                    this.mapData[this.zoom].setFoliageLight(imageX, imageY, foliageLight);
                } else {
                    foliageLight = this.mapData[this.zoom].getFoliageLight(imageX, imageY);
                }
                if (foliageLight == 0) {
                    foliageColor = 0;
                } else if (foliageLight != 255) {
                    foliageColor = ColorUtils.colorMultiplier(foliageColor, foliageLight);
                }
            }
        }
        if (seafloorColor != 0 && seafloorHeight > 0) {
            color24 = seafloorColor;
            if (foliageColor != 0 && foliageHeight <= surfaceHeight) {
                color24 = ColorUtils.colorAdder(foliageColor, color24);
            }
            if (transparentColor != 0 && transparentHeight <= surfaceHeight) {
                color24 = ColorUtils.colorAdder(transparentColor, color24);
            }
            color24 = ColorUtils.colorAdder(surfaceColor, color24);
        } else {
            color24 = surfaceColor;
        }
        if (foliageColor != 0 && foliageHeight > surfaceHeight) {
            color24 = ColorUtils.colorAdder(foliageColor, color24);
        }
        if (transparentColor != 0 && transparentHeight > surfaceHeight) {
            color24 = ColorUtils.colorAdder(transparentColor, color24);
        }
        int n3 = this.options.biomeOverlay;
        this.options.getClass();
        if (n3 == 2) {
            int bc = 0;
            if (biomeID >= 0) {
                bc = BiomeRepository.getBiomeColor(biomeID);
            }
            bc = 0x7F000000 | bc;
            color24 = ColorUtils.colorAdder(bc, color24);
        }
        color24 = MapUtils.doSlimeAndGrid(color24, startX + imageX, startZ + imageY);
        return color24;
    }

    private final int getBlockHeight(boolean nether, boolean caves, class_1937 world, int x, int z) {
        int playerHeight = GameVariableAccessShim.yCoord();
        this.blockPos.setXYZ(x, playerHeight, z);
        class_2818 chunk = (class_2818)world.method_22350((class_2338)this.blockPos);
        int height = chunk.method_12005(class_2902.class_2903.field_13197, this.blockPos.method_10263() & 0xF, this.blockPos.method_10260() & 0xF) + 1;
        class_2680 blockState = world.method_8320((class_2338)this.blockPos.withXYZ(x, height - 1, z));
        class_3610 fluidState = this.transparentBlockState.method_26227();
        if (fluidState != class_3612.field_15906.method_15785()) {
            blockState = fluidState.method_15759();
        }
        while (blockState.method_26193((class_1922)world, (class_2338)this.blockPos) == 0 && height > 0) {
            blockState = world.method_8320((class_2338)this.blockPos.withXYZ(x, --height - 1, z));
            fluidState = this.surfaceBlockState.method_26227();
            if (fluidState == class_3612.field_15906.method_15785()) continue;
            blockState = fluidState.method_15759();
        }
        if (!nether && !caves || height <= playerHeight) {
            return height;
        }
        return this.getNetherHeight(nether, x, z);
    }

    private int getNetherHeight(boolean nether, int x, int z) {
        int y = this.lastY;
        this.blockPos.setXYZ(x, y, z);
        class_2680 blockState = this.world.method_8320((class_2338)this.blockPos);
        if (blockState.method_26193((class_1922)this.world, (class_2338)this.blockPos) == 0 && blockState.method_26207() != class_3614.field_15922) {
            while (y > 0) {
                this.blockPos.setXYZ(x, --y, z);
                blockState = this.world.method_8320((class_2338)this.blockPos);
                if (blockState.method_26193((class_1922)this.world, (class_2338)this.blockPos) <= 0 && blockState.method_26207() != class_3614.field_15922) continue;
                return y + 1;
            }
            return y;
        }
        while (y <= this.lastY + 10 && y < (nether ? 127 : 256)) {
            this.blockPos.setXYZ(x, ++y, z);
            blockState = this.world.method_8320((class_2338)this.blockPos);
            if (blockState.method_26193((class_1922)this.world, (class_2338)this.blockPos) != 0 || blockState.method_26207() == class_3614.field_15922) continue;
            return y;
        }
        return -1;
    }

    private final int getSeafloorHeight(class_1937 world, int x, int z, int height) {
        class_2680 blockState = world.method_8320((class_2338)this.blockPos.withXYZ(x, height - 1, z));
        while (blockState.method_26193((class_1922)world, (class_2338)this.blockPos) < 5 && blockState.method_26207() != class_3614.field_15923 && height > 1) {
            blockState = world.method_8320((class_2338)this.blockPos.withXYZ(x, --height - 1, z));
        }
        return height;
    }

    private final int getTransparentHeight(boolean nether, boolean caves, class_1937 world, int x, int z, int height) {
        int transHeight = -1;
        if (caves || nether) {
            transHeight = -1;
        } else {
            transHeight = world.method_8598(class_2902.class_2903.field_13197, (class_2338)this.blockPos.withXYZ(x, height, z)).method_10264();
            if (transHeight <= height) {
                transHeight = -1;
            }
        }
        class_2680 blockState = world.method_8320((class_2338)this.blockPos.withXYZ(x, transHeight - 1, z));
        class_3614 material = blockState.method_26207();
        if (transHeight == height + 1 && material == class_3614.field_15948) {
            transHeight = -1;
        }
        if (material == class_3614.field_15952 && (material = (blockState = world.method_8320((class_2338)this.blockPos.withXYZ(x, ++transHeight - 1, z))).method_26207()) == class_3614.field_15959) {
            transHeight = -1;
        }
        return transHeight;
    }

    private int applyHeight(int color24, boolean nether, boolean caves, class_1937 world, int multi, int startX, int startZ, int imageX, int imageY, int height, boolean solid, int layer) {
        if (color24 != this.colorManager.getAirColor() && color24 != 0 && (this.options.heightmap || this.options.slopemap) && !solid) {
            int heightComp = -1;
            int diff = 0;
            double sc = 0.0;
            if (this.options.slopemap) {
                if (imageX > 0 && imageY < 32 * multi - 1) {
                    class_2248 block;
                    if (layer == 0) {
                        heightComp = this.mapData[this.zoom].getOceanFloorHeight(imageX - 1, imageY + 1);
                    }
                    if (layer == 1) {
                        heightComp = this.mapData[this.zoom].getHeight(imageX - 1, imageY + 1);
                    }
                    if (layer == 2) {
                        heightComp = height;
                    }
                    if (layer == 3 && (heightComp = this.mapData[this.zoom].getTransparentHeight(imageX - 1, imageY + 1)) == -1 && ((block = BlockRepository.getStateById(this.mapData[this.zoom].getTransparentBlockstateID(imageX, imageY)).method_26204()) instanceof class_2368 || block instanceof class_2506)) {
                        heightComp = this.mapData[this.zoom].getHeight(imageX - 1, imageY + 1);
                    }
                } else {
                    class_2680 blockState;
                    class_2248 block;
                    int baseHeight;
                    if (layer == 0) {
                        baseHeight = this.getBlockHeight(nether, caves, world, startX + imageX - 1, startZ + imageY + 1);
                        heightComp = this.getSeafloorHeight(world, startX + imageX - 1, startZ + imageY + 1, baseHeight);
                    }
                    if (layer == 1) {
                        heightComp = this.getBlockHeight(nether, caves, world, startX + imageX - 1, startZ + imageY + 1);
                    }
                    if (layer == 2) {
                        heightComp = height;
                    }
                    if (layer == 3 && (heightComp = this.getTransparentHeight(nether, caves, world, startX + imageX - 1, startZ + imageY + 1, baseHeight = this.getBlockHeight(nether, caves, world, startX + imageX - 1, startZ + imageY + 1))) == -1 && ((block = (blockState = world.method_8320((class_2338)this.blockPos.withXYZ(startX + imageX, height - 1, startZ + imageY))).method_26204()) instanceof class_2368 || block instanceof class_2506)) {
                        heightComp = baseHeight;
                    }
                }
                if (heightComp == -1) {
                    heightComp = height;
                }
                if ((diff = heightComp - height) != 0) {
                    sc = diff > 0 ? 1.0 : (diff < 0 ? -1.0 : 0.0);
                    sc /= 8.0;
                }
                if (this.options.heightmap) {
                    diff = height - this.lastY;
                    double heightsc = Math.log10((double)Math.abs(diff) / 8.0 + 1.0) / 3.0;
                    sc = diff > 0 ? sc + heightsc : sc - heightsc;
                }
            } else if (this.options.heightmap) {
                diff = height - this.lastY;
                sc = Math.log10((double)Math.abs(diff) / 8.0 + 1.0) / 1.8;
                if (diff < 0) {
                    sc = 0.0 - sc;
                }
            }
            int alpha = color24 >> 24 & 0xFF;
            int r = color24 >> 16 & 0xFF;
            int g = color24 >> 8 & 0xFF;
            int b = color24 >> 0 & 0xFF;
            if (sc > 0.0) {
                r = (int)(sc * (double)(255 - r)) + r;
                g = (int)(sc * (double)(255 - g)) + g;
                b = (int)(sc * (double)(255 - b)) + b;
            } else if (sc < 0.0) {
                sc = Math.abs(sc);
                r -= (int)(sc * (double)r);
                g -= (int)(sc * (double)g);
                b -= (int)(sc * (double)b);
            }
            color24 = alpha * 0x1000000 + r * 65536 + g * 256 + b;
        }
        return color24;
    }

    private int getLight(int color24, class_2680 blockState, class_1937 world, int x, int z, int height, boolean solid) {
        int i3 = 255;
        if (solid) {
            i3 = 0;
        } else if (color24 != this.colorManager.getAirColor() && color24 != 0 && this.options.lightmap) {
            this.blockPos.setXYZ(x, Math.max(Math.min(height, this.WORLD_HEIGHT - 1), 0), z);
            int blockLight = world.method_8314(class_1944.field_9282, (class_2338)this.blockPos);
            int skyLight = world.method_8314(class_1944.field_9284, (class_2338)this.blockPos);
            if (blockState.method_26207() == class_3614.field_15922 || blockState.method_26204() == class_2246.field_10092) {
                blockLight = 14;
            }
            i3 = this.lightmapColors[blockLight + skyLight * 16];
        }
        return i3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderMap(int x, int y, int scScale) {
        float multi22;
        float scale = 1.0f;
        if (this.options.squareMap && this.options.rotates) {
            scale = this.SQRT2;
        }
        if (GLUtils.hasAlphaBits) {
            GLShim.glColorMask(false, false, false, true);
            GLShim.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            GLShim.glClear(16384);
            GLShim.glBlendFunc(770, 771);
            GLShim.glColorMask(true, true, true, true);
            GLUtils.img(this.options.squareMap ? this.squareStencil : this.circleStencil);
            GLUtils.drawPre();
            GLUtils.setMap(x, y, 128);
            GLUtils.drawPost();
            GLShim.glBlendFunc(772, 773);
            Object object = this.coordinateLock;
            synchronized (object) {
                if (this.imageChanged) {
                    this.imageChanged = false;
                    this.mapImages[this.zoom].write();
                    this.lastImageX = this.lastX;
                    this.lastImageZ = this.lastZ;
                }
            }
            multi22 = (float)(1.0 / this.zoomScaleAdjusted);
            this.percentX = (float)(GameVariableAccessShim.xCoordDouble() - (double)this.lastImageX);
            this.percentY = (float)(GameVariableAccessShim.zCoordDouble() - (double)this.lastImageZ);
            this.percentX *= multi22;
            this.percentY *= multi22;
            GLUtils.disp(this.mapImages[this.zoom].getIndex());
            GLShim.glPushMatrix();
            GLShim.glTranslatef(x, y, 0.0f);
            GLShim.glRotatef(!this.options.rotates ? (float)this.northRotate : -this.direction, 0.0f, 0.0f, 1.0f);
            GLShim.glTranslatef(-x, -y, 0.0f);
            GLShim.glTranslatef(-this.percentX, -this.percentY, 0.0f);
            GLShim.glTexParameteri(3553, 10241, 9987);
            GLShim.glTexParameteri(3553, 10240, 9729);
        } else {
            GLShim.glBindTexture(3553, 0);
            GLShim.glPushAttrib(4096);
            GLShim.glViewport(0, 0, 512, 512);
            GLShim.glMatrixMode(5889);
            GLShim.glPushMatrix();
            GLShim.glLoadIdentity();
            GLShim.glOrtho(0.0, 512.0, 512.0, 0.0, 1000.0, 3000.0);
            GLShim.glMatrixMode(5888);
            GLShim.glPushMatrix();
            GLShim.glLoadIdentity();
            GLShim.glTranslatef(0.0f, 0.0f, -2000.0f);
            GLUtils.bindFrameBuffer();
            GLShim.glDepthMask(false);
            GLShim.glDisable(2929);
            GLShim.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            GLShim.glClear(16384);
            GLShim.glBlendFunc(770, 0);
            GLUtils.img(new class_2960("voxelmap", this.options.squareMap ? "images/square.png" : "images/circle.png"));
            GLUtils.drawPre();
            GLUtils.ldrawthree(256.0f - 256.0f / scale, 256.0f + 256.0f / scale, 1.0, 0.0f, 0.0f);
            GLUtils.ldrawthree(256.0f + 256.0f / scale, 256.0f + 256.0f / scale, 1.0, 1.0f, 0.0f);
            GLUtils.ldrawthree(256.0f + 256.0f / scale, 256.0f - 256.0f / scale, 1.0, 1.0f, 1.0f);
            GLUtils.ldrawthree(256.0f - 256.0f / scale, 256.0f - 256.0f / scale, 1.0, 0.0f, 1.0f);
            GLUtils.drawPost();
            GLShim.glBlendFuncSeparate(1, 0, 774, 0);
            Object multi22 = this.coordinateLock;
            synchronized (multi22) {
                if (this.imageChanged) {
                    this.imageChanged = false;
                    this.mapImages[this.zoom].write();
                    this.lastImageX = this.lastX;
                    this.lastImageZ = this.lastZ;
                }
            }
            multi22 = (float)(1.0 / this.zoomScale);
            this.percentX = (float)(GameVariableAccessShim.xCoordDouble() - (double)this.lastImageX);
            this.percentY = (float)(GameVariableAccessShim.zCoordDouble() - (double)this.lastImageZ);
            this.percentX *= multi22;
            this.percentY *= multi22;
            GLUtils.disp(this.mapImages[this.zoom].getIndex());
            GLShim.glTexParameteri(3553, 10241, 9987);
            GLShim.glTexParameteri(3553, 10240, 9729);
            GLShim.glTranslatef(256.0f, 256.0f, 0.0f);
            if (!this.options.rotates) {
                GLShim.glRotatef(-this.northRotate, 0.0f, 0.0f, 1.0f);
            } else {
                GLShim.glRotatef(this.direction, 0.0f, 0.0f, 1.0f);
            }
            GLShim.glTranslatef(-256.0f, -256.0f, 0.0f);
            GLShim.glTranslatef(-this.percentX * 512.0f / 64.0f, this.percentY * 512.0f / 64.0f, 0.0f);
            GLUtils.drawPre();
            GLUtils.ldrawthree(0.0, 512.0, 1.0, 0.0f, 0.0f);
            GLUtils.ldrawthree(512.0, 512.0, 1.0, 1.0f, 0.0f);
            GLUtils.ldrawthree(512.0, 0.0, 1.0, 1.0f, 1.0f);
            GLUtils.ldrawthree(0.0, 0.0, 1.0, 0.0f, 1.0f);
            GLUtils.drawPost();
            GLShim.glDepthMask(true);
            GLShim.glEnable(2929);
            GLUtils.unbindFrameBuffer();
            GLShim.glMatrixMode(5889);
            GLShim.glPopMatrix();
            GLShim.glMatrixMode(5888);
            GLShim.glPopMatrix();
            GLShim.glPopAttrib();
            GLShim.glViewport(0, 0, this.game.method_22683().method_4489(), this.game.method_22683().method_4506());
            GLShim.glPushMatrix();
            GLShim.glBlendFunc(770, 0);
            GLShim.glEnable(3008);
            GLUtils.disp(GLUtils.fboTextureID);
        }
        double guiScale = (double)this.game.method_22683().method_4489() / (double)this.scWidth;
        GLShim.glEnable(3089);
        GLShim.glScissor((int)(guiScale * (double)(x - 32)), (int)(guiScale * ((double)(this.scHeight - y) - 32.0)), (int)(guiScale * 64.0), (int)(guiScale * 63.0));
        GLUtils.drawPre();
        GLUtils.setMapWithScale(x, y, scale);
        GLUtils.drawPost();
        GLShim.glDisable(3089);
        GLShim.glPopMatrix();
        GLShim.glBlendFunc(770, 771);
        GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.options.squareMap) {
            this.drawSquareMapFrame(x, y);
        } else {
            this.drawRoundMapFrame(x, y);
        }
        double lastXDouble = GameVariableAccessShim.xCoordDouble();
        double lastZDouble = GameVariableAccessShim.zCoordDouble();
        TextureAtlas textureAtlas = this.master.getWaypointManager().getTextureAtlas();
        GLUtils.disp(textureAtlas.method_4624());
        Waypoint highlightedPoint = this.waypointManager.getHighlightedWaypoint();
        for (Waypoint pt : this.waypointManager.getWaypoints()) {
            double distanceSq;
            if (!pt.isActive() && pt != highlightedPoint || !((distanceSq = pt.getDistanceSqToEntity(this.game.method_1560())) < (double)(this.options.maxWaypointDisplayDistance * this.options.maxWaypointDisplayDistance)) && this.options.maxWaypointDisplayDistance >= 0 && pt != highlightedPoint) continue;
            this.drawWaypoint(pt, textureAtlas, x, y, scScale, lastXDouble, lastZDouble, null, null, null, null);
        }
        if (highlightedPoint != null) {
            this.drawWaypoint(highlightedPoint, textureAtlas, x, y, scScale, lastXDouble, lastZDouble, textureAtlas.getAtlasSprite("voxelmap:images/waypoints/target.png"), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
        }
        GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawWaypoint(Waypoint pt, TextureAtlas textureAtlas, int x, int y, int scScale, double lastXDouble, double lastZDouble, Sprite icon, Float r, Float g, Float b) {
        boolean uprightIcon;
        boolean bl = uprightIcon = icon != null;
        if (r == null) {
            r = Float.valueOf(pt.red);
        }
        if (g == null) {
            g = Float.valueOf(pt.green);
        }
        if (b == null) {
            b = Float.valueOf(pt.blue);
        }
        double wayX = lastXDouble - (double)pt.getX() - 0.5;
        double wayY = lastZDouble - (double)pt.getZ() - 0.5;
        float locate = (float)Math.toDegrees(Math.atan2(wayX, wayY));
        double hypot = Math.sqrt(wayX * wayX + wayY * wayY);
        boolean far = false;
        locate = this.options.rotates ? (locate += this.direction) : (locate -= (float)this.northRotate);
        hypot /= this.zoomScaleAdjusted;
        if (this.options.squareMap) {
            double radLocate = Math.toRadians(locate);
            double dispX = hypot * Math.cos(radLocate);
            double dispY = hypot * Math.sin(radLocate);
            boolean bl2 = far = Math.abs(dispX) > 28.5 || Math.abs(dispY) > 28.5;
            if (far) {
                hypot = hypot / Math.max(Math.abs(dispX), Math.abs(dispY)) * 30.0;
            }
        } else {
            boolean bl3 = far = hypot >= 31.0;
            if (far) {
                hypot = 34.0;
            }
        }
        boolean target = false;
        if (far) {
            try {
                if (icon == null) {
                    icon = scScale >= 3 ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/marker" + pt.imageSuffix + ".png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/marker" + pt.imageSuffix + "Small.png");
                    if (icon == textureAtlas.getMissingImage()) {
                        icon = scScale >= 3 ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/marker.png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/markerSmall.png");
                    }
                } else {
                    target = true;
                }
                GLShim.glPushMatrix();
                GLShim.glColor4f(r.floatValue(), g.floatValue(), b.floatValue(), pt.enabled || target ? 1.0f : 0.3f);
                GLShim.glTexParameteri(3553, 10241, 9729);
                GLShim.glTexParameteri(3553, 10240, 9729);
                GLShim.glTranslatef(x, y, 0.0f);
                GLShim.glRotatef(-locate, 0.0f, 0.0f, 1.0f);
                if (uprightIcon) {
                    GLShim.glTranslated(0.0, -hypot, 0.0);
                    GLShim.glRotatef(locate, 0.0f, 0.0f, 1.0f);
                    GLShim.glTranslatef(-x, -y, 0.0f);
                } else {
                    GLShim.glTranslatef(-x, -y, 0.0f);
                    GLShim.glTranslated(0.0, -hypot, 0.0);
                }
                GLUtils.drawPre();
                GLUtils.setMap(icon, x, y, 16.0f);
                GLUtils.drawPost();
            }
            catch (Exception localException) {
                this.error = "Error: marker overlay not found!";
            }
            finally {
                GLShim.glPopMatrix();
            }
        } else {
            try {
                if (icon == null) {
                    icon = scScale >= 3 ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint" + pt.imageSuffix + ".png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint" + pt.imageSuffix + "Small.png");
                    if (icon == textureAtlas.getMissingImage()) {
                        icon = scScale >= 3 ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint.png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypointSmall.png");
                    }
                } else {
                    target = true;
                }
                GLShim.glPushMatrix();
                GLShim.glColor4f(r.floatValue(), g.floatValue(), b.floatValue(), pt.enabled || target ? 1.0f : 0.3f);
                GLShim.glTexParameteri(3553, 10241, 9729);
                GLShim.glTexParameteri(3553, 10240, 9729);
                GLShim.glRotatef(-locate, 0.0f, 0.0f, 1.0f);
                GLShim.glTranslated(0.0, -hypot, 0.0);
                GLShim.glRotatef(-(-locate), 0.0f, 0.0f, 1.0f);
                GLUtils.drawPre();
                GLUtils.setMap(icon, x, y, 16.0f);
                GLUtils.drawPost();
            }
            catch (Exception localException) {
                this.error = "Error: waypoint overlay not found!";
            }
            finally {
                GLShim.glPopMatrix();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawArrow(int x, int y) {
        try {
            GLShim.glPushMatrix();
            GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GLShim.glBlendFunc(770, 771);
            GLUtils.img(this.arrowResourceLocation);
            GLShim.glTexParameteri(3553, 10241, 9729);
            GLShim.glTexParameteri(3553, 10240, 9729);
            GLShim.glTranslatef(x, y, 0.0f);
            GLShim.glRotatef(!this.options.rotates || this.fullscreenMap ? this.direction + (float)this.northRotate : 0.0f, 0.0f, 0.0f, 1.0f);
            GLShim.glTranslatef(-x, -y, 0.0f);
            GLUtils.drawPre();
            GLUtils.setMap(x, y, 16);
            GLUtils.drawPost();
        }
        catch (Exception localException) {
            this.error = "Error: minimap arrow not found!";
        }
        finally {
            GLShim.glPopMatrix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderMapFull(class_4587 matrixStack, int scWidth, int scHeight) {
        Object object = this.coordinateLock;
        synchronized (object) {
            if (this.imageChanged) {
                this.imageChanged = false;
                this.mapImages[this.zoom].write();
                this.lastImageX = this.lastX;
                this.lastImageZ = this.lastZ;
            }
        }
        GLUtils.disp(this.mapImages[this.zoom].getIndex());
        GLShim.glTexParameteri(3553, 10241, 9987);
        GLShim.glTexParameteri(3553, 10240, 9729);
        GLShim.glPushMatrix();
        GLShim.glTranslatef((float)scWidth / 2.0f, (float)scHeight / 2.0f, -0.0f);
        GLShim.glRotatef(this.northRotate, 0.0f, 0.0f, 1.0f);
        GLShim.glTranslatef(-((float)scWidth / 2.0f), -((float)scHeight / 2.0f), -0.0f);
        GLShim.glDisable(2929);
        GLUtils.drawPre();
        int left = scWidth / 2 - 128;
        int top = scHeight / 2 - 128;
        GLUtils.ldrawone(left, top + 256, 160.0, 0.0f, 1.0f);
        GLUtils.ldrawone(left + 256, top + 256, 160.0, 1.0f, 1.0f);
        GLUtils.ldrawone(left + 256, top, 160.0, 1.0f, 0.0f);
        GLUtils.ldrawone(left, top, 160.0, 0.0f, 0.0f);
        GLUtils.drawPost();
        GLShim.glPopMatrix();
        int n = this.options.biomeOverlay;
        this.options.getClass();
        if (n != 0) {
            double factor = Math.pow(2.0, 3 - this.zoom);
            int minimumSize = (int)Math.pow(2.0, this.zoom);
            minimumSize *= minimumSize;
            ArrayList<AbstractMapData.BiomeLabel> labels = this.mapData[this.zoom].getBiomeLabels();
            GLShim.glDisable(2929);
            GLShim.glPushMatrix();
            GLShim.glTranslated(0.0, 0.0, 160.0);
            for (int t = 0; t < labels.size(); ++t) {
                AbstractMapData.BiomeLabel label = labels.get(t);
                if (label.segmentSize <= minimumSize) continue;
                String name = label.name;
                int nameWidth = this.chkLen(name);
                float x = (float)((double)label.x * factor);
                float z = (float)((double)label.z * factor);
                if (this.options.oldNorth) {
                    this.write(matrixStack, name, (float)(left + 256) - z - (float)(nameWidth / 2), (float)top + x - 3.0f, 0xFFFFFF);
                    continue;
                }
                this.write(matrixStack, name, (float)left + x - (float)(nameWidth / 2), (float)top + z - 3.0f, 0xFFFFFF);
            }
            GLShim.glPopMatrix();
            GLShim.glEnable(2929);
        }
    }

    private void drawSquareMapFrame(int x, int y) {
        try {
            GLUtils.disp(this.mapImageInt);
            GLShim.glTexParameteri(3553, 10241, 9729);
            GLShim.glTexParameteri(3553, 10240, 9729);
            GLShim.glTexParameteri(3553, 10242, 10496);
            GLShim.glTexParameteri(3553, 10243, 10496);
            GLUtils.drawPre();
            GLUtils.setMap(x, y, 128);
            GLUtils.drawPost();
        }
        catch (Exception localException) {
            this.error = "error: minimap overlay not found!";
        }
    }

    private void loadMapImage() {
        if (this.mapImageInt != -1) {
            GLUtils.glah(this.mapImageInt);
        }
        try {
            InputStream is = this.game.method_1478().method_14486(new class_2960("voxelmap", "images/squaremap.png")).method_14482();
            BufferedImage mapImage = ImageIO.read(is);
            is.close();
            this.mapImageInt = GLUtils.tex(mapImage);
        }
        catch (Exception e) {
            try {
                InputStream is = this.game.method_1478().method_14486(new class_2960("textures/map/map_background.png")).method_14482();
                BufferedImage tpMap = ImageIO.read(is);
                is.close();
                BufferedImage mapImage = new BufferedImage(((Image)tpMap).getWidth(null), ((Image)tpMap).getHeight(null), 2);
                Graphics2D gfx = mapImage.createGraphics();
                gfx.drawImage((Image)tpMap, 0, 0, null);
                int border = mapImage.getWidth() * 8 / 128;
                gfx.setComposite(AlphaComposite.Clear);
                gfx.fillRect(border, border, mapImage.getWidth() - border * 2, mapImage.getHeight() - border * 2);
                gfx.dispose();
                this.mapImageInt = GLUtils.tex(mapImage);
            }
            catch (Exception f) {
                System.err.println("Error loading texture pack's map image: " + f.getLocalizedMessage());
            }
        }
    }

    private void drawRoundMapFrame(int x, int y) {
        try {
            GLUtils.img(this.roundmapResourceLocation);
            GLShim.glTexParameteri(3553, 10241, 9729);
            GLShim.glTexParameteri(3553, 10240, 9729);
            GLUtils.drawPre();
            GLUtils.setMap(x, y, 128);
            GLUtils.drawPost();
        }
        catch (Exception localException) {
            this.error = "Error: minimap overlay not found!";
        }
    }

    private void drawDirections(class_4587 matrixStack, int x, int y) {
        float distance;
        boolean unicode = this.game.field_1690.field_1819;
        float scale = unicode ? 0.65f : 0.5f;
        float rotate = this.options.rotates ? -this.direction - 90.0f - (float)this.northRotate : -90.0f;
        if (this.options.squareMap) {
            if (this.options.rotates) {
                float tempdir = this.direction % 90.0f;
                tempdir = 45.0f - Math.abs(45.0f - tempdir);
                distance = (float)(33.5 / (double)scale / Math.cos(Math.toRadians(tempdir)));
            } else {
                distance = 33.5f / scale;
            }
        } else {
            distance = 32.0f / scale;
        }
        GLShim.glPushMatrix();
        GLShim.glScalef(scale, scale, 1.0f);
        GLShim.glTranslated((double)distance * Math.sin(Math.toRadians(-((double)rotate - 90.0))), (double)distance * Math.cos(Math.toRadians(-((double)rotate - 90.0))), 10.0);
        this.write(matrixStack, "N", (float)x / scale - 2.0f, (float)y / scale - 4.0f, 0xFFFFFF);
        GLShim.glPopMatrix();
        GLShim.glPushMatrix();
        GLShim.glScalef(scale, scale, 1.0f);
        GLShim.glTranslated((double)distance * Math.sin(Math.toRadians(-rotate)), (double)distance * Math.cos(Math.toRadians(-rotate)), 10.0);
        this.write(matrixStack, "E", (float)x / scale - 2.0f, (float)y / scale - 4.0f, 0xFFFFFF);
        GLShim.glPopMatrix();
        GLShim.glPushMatrix();
        GLShim.glScalef(scale, scale, 1.0f);
        GLShim.glTranslated((double)distance * Math.sin(Math.toRadians(-((double)rotate + 90.0))), (double)distance * Math.cos(Math.toRadians(-((double)rotate + 90.0))), 10.0);
        this.write(matrixStack, "S", (float)x / scale - 2.0f, (float)y / scale - 4.0f, 0xFFFFFF);
        GLShim.glPopMatrix();
        GLShim.glPushMatrix();
        GLShim.glScalef(scale, scale, 1.0f);
        GLShim.glTranslated((double)distance * Math.sin(Math.toRadians(-((double)rotate + 180.0))), (double)distance * Math.cos(Math.toRadians(-((double)rotate + 180.0))), 10.0);
        this.write(matrixStack, "W", (float)x / scale - 2.0f, (float)y / scale - 4.0f, 0xFFFFFF);
        GLShim.glPopMatrix();
    }

    private void showCoords(class_4587 matrixStack, int x, int y) {
        int textStart = y > this.scHeight - 37 - 32 - 4 - 15 ? y - 32 - 4 - 9 : y + 32 + 4;
        if (!this.options.hide && !this.fullscreenMap) {
            boolean unicode = this.game.field_1690.field_1819;
            float scale = unicode ? 0.65f : 0.5f;
            GLShim.glPushMatrix();
            GLShim.glScalef(scale, scale, 1.0f);
            String xy = this.dCoord(GameVariableAccessShim.xCoord()) + ", " + this.dCoord(GameVariableAccessShim.zCoord());
            int m = this.chkLen(xy) / 2;
            this.write(matrixStack, xy, (float)x / scale - (float)m, (float)textStart / scale, 0xFFFFFF);
            xy = Integer.toString(GameVariableAccessShim.yCoord());
            m = this.chkLen(xy) / 2;
            this.write(matrixStack, xy, (float)x / scale - (float)m, (float)textStart / scale + 10.0f, 0xFFFFFF);
            if (this.ztimer > 0) {
                m = this.chkLen(this.error) / 2;
                this.write(matrixStack, this.error, (float)x / scale - (float)m, (float)textStart / scale + 19.0f, 0xFFFFFF);
            }
            GLShim.glPopMatrix();
        } else {
            int heading = (int)(this.direction + (float)this.northRotate);
            if (heading > 360) {
                heading -= 360;
            }
            String stats = "(" + this.dCoord(GameVariableAccessShim.xCoord()) + ", " + GameVariableAccessShim.yCoord() + ", " + this.dCoord(GameVariableAccessShim.zCoord()) + ") " + heading + "'";
            int m = this.chkLen(stats) / 2;
            this.write(matrixStack, stats, (float)(this.scWidth / 2 - m), 5.0f, 0xFFFFFF);
            if (this.ztimer > 0) {
                m = this.chkLen(this.error) / 2;
                this.write(matrixStack, this.error, (float)(this.scWidth / 2 - m), 15.0f, 0xFFFFFF);
            }
        }
    }

    private String dCoord(int paramInt1) {
        if (paramInt1 < 0) {
            return "-" + Math.abs(paramInt1);
        }
        if (paramInt1 > 0) {
            return "+" + paramInt1;
        }
        return " " + paramInt1;
    }

    private int chkLen(String string) {
        return this.fontRenderer.method_1727(string);
    }

    private void write(class_4587 matrixStack, String text, float x, float y, int color) {
        this.fontRenderer.method_1720(matrixStack, text, x, y, color);
    }

    private int chkLen(class_2561 text) {
        return this.fontRenderer.method_27525((class_5348)text);
    }

    private void write(class_4587 matrixStack, class_2561 text, float x, float y, int color) {
        this.fontRenderer.method_30881(matrixStack, text, x, y, color);
    }

    private void drawWelcomeScreen(class_4587 matrixStack, int scWidth, int scHeight) {
        int height;
        if (this.welcomeText[1] == null || this.welcomeText[1].getString().equals("minimap.ui.welcome2")) {
            this.welcomeText[0] = new class_2585("").method_10852((class_2561)new class_2585("VoxelMap! ").method_27692(class_124.field_1061)).method_27693(this.zmodver + " ").method_10852((class_2561)new class_2588("minimap.ui.welcome1"));
            this.welcomeText[1] = new class_2588("minimap.ui.welcome2");
            this.welcomeText[2] = new class_2588("minimap.ui.welcome3");
            this.welcomeText[3] = new class_2588("minimap.ui.welcome4");
            this.welcomeText[4] = new class_2585("").method_10852((class_2561)new class_2572(this.options.keyBindZoom.method_1431()).method_27692(class_124.field_1075)).method_27693(": ").method_10852((class_2561)new class_2588("minimap.ui.welcome5a")).method_27693(", ").method_10852((class_2561)new class_2572(this.options.keyBindMenu.method_1431()).method_27692(class_124.field_1075)).method_27693(": ").method_10852((class_2561)new class_2588("minimap.ui.welcome5b"));
            this.welcomeText[5] = new class_2585("").method_10852((class_2561)new class_2572(this.options.keyBindFullscreen.method_1431()).method_27692(class_124.field_1075)).method_27693(": ").method_10852((class_2561)new class_2588("minimap.ui.welcome6"));
            this.welcomeText[6] = new class_2585("").method_10852((class_2561)new class_2572(this.options.keyBindWaypoint.method_1431()).method_27692(class_124.field_1075)).method_27693(": ").method_10852((class_2561)new class_2588("minimap.ui.welcome7"));
            this.welcomeText[7] = this.options.keyBindZoom.method_16007().method_27661().method_27693(": ").method_10852((class_2561)new class_2588("minimap.ui.welcome8").method_27692(class_124.field_1080));
        }
        GLShim.glBlendFunc(770, 771);
        int maxSize = 0;
        int border = 2;
        class_2561 head = this.welcomeText[0];
        for (height = 1; height < this.welcomeText.length - 1; ++height) {
            if (this.chkLen(this.welcomeText[height]) <= maxSize) continue;
            maxSize = this.chkLen(this.welcomeText[height]);
        }
        int title = this.chkLen(head);
        int centerX = (int)((double)(scWidth + 5) / 2.0);
        int centerY = (int)((double)(scHeight + 5) / 2.0);
        class_2561 hide = this.welcomeText[this.welcomeText.length - 1];
        int footer = this.chkLen(hide);
        GLShim.glDisable(3553);
        GLShim.glColor4f(0.0f, 0.0f, 0.0f, 0.7f);
        double leftX = (double)centerX - (double)title / 2.0 - (double)border;
        double rightX = (double)centerX + (double)title / 2.0 + (double)border;
        double topY = (double)centerY - (double)(height - 1) / 2.0 * 10.0 - (double)border - 20.0;
        double botY = (double)centerY - (double)(height - 1) / 2.0 * 10.0 + (double)border - 10.0;
        this.drawBox(leftX, rightX, topY, botY);
        leftX = (double)centerX - (double)maxSize / 2.0 - (double)border;
        rightX = (double)centerX + (double)maxSize / 2.0 + (double)border;
        topY = (double)centerY - (double)(height - 1) / 2.0 * 10.0 - (double)border;
        botY = (double)centerY + (double)(height - 1) / 2.0 * 10.0 + (double)border;
        this.drawBox(leftX, rightX, topY, botY);
        leftX = (double)centerX - (double)footer / 2.0 - (double)border;
        rightX = (double)centerX + (double)footer / 2.0 + (double)border;
        topY = (double)centerY + (double)(height - 1) / 2.0 * 10.0 - (double)border + 10.0;
        botY = (double)centerY + (double)(height - 1) / 2.0 * 10.0 + (double)border + 20.0;
        this.drawBox(leftX, rightX, topY, botY);
        GLShim.glEnable(3553);
        this.write(matrixStack, head, (float)(centerX - title / 2), (float)(centerY - (height - 1) * 10 / 2 - 19), 0xFFFFFF);
        for (int n = 1; n < height; ++n) {
            this.write(matrixStack, this.welcomeText[n], (float)(centerX - maxSize / 2), (float)(centerY - (height - 1) * 10 / 2 + n * 10 - 9), 0xFFFFFF);
        }
        this.write(matrixStack, hide, (float)(centerX - footer / 2), (float)((scHeight + 5) / 2 + (height - 1) * 10 / 2 + 11), 0xFFFFFF);
    }

    private void drawBox(double leftX, double rightX, double topY, double botY) {
        GLUtils.drawPre(class_290.field_1592);
        GLUtils.ldrawtwo(leftX, botY, 0.0);
        GLUtils.ldrawtwo(rightX, botY, 0.0);
        GLUtils.ldrawtwo(rightX, topY, 0.0);
        GLUtils.ldrawtwo(leftX, topY, 0.0);
        GLUtils.drawPost();
    }
}

