/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.init;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.Map;
import me.sargunvohra.mcmods.autoconfig1u.AutoConfig;
import me.sargunvohra.mcmods.autoconfig1u.ConfigHolder;
import me.sargunvohra.mcmods.autoconfig1u.gui.registry.api.GuiProvider;
import me.sargunvohra.mcmods.autoconfig1u.serializer.GsonConfigSerializer;
import net.minecraft.class_2960;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import randommcsomethin.fallingleaves.FallingLeavesClient;
import randommcsomethin.fallingleaves.config.FallingLeavesConfig;
import randommcsomethin.fallingleaves.config.FallingLeavesConfigV0;
import randommcsomethin.fallingleaves.config.GsonConfigHelper;
import randommcsomethin.fallingleaves.config.IdentifierTypeAdapter;
import randommcsomethin.fallingleaves.config.LeafSettingsGuiProvider;

public class Config {
    public static FallingLeavesConfig CONFIG;
    private static ConfigHolder<FallingLeavesConfig> configHolder;

    public static void init() {
        Config.migrateOldConfig();
        configHolder = AutoConfig.register(FallingLeavesConfig.class, (definition, configClass) -> new GsonConfigSerializer(definition, configClass, new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(class_2960.class, (Object)IdentifierTypeAdapter.INST).create()));
        CONFIG = (FallingLeavesConfig)configHolder.getConfig();
        if (Config.CONFIG.displayDebugData && FallingLeavesClient.LOGGER.getLevel().compareTo(Level.DEBUG) < 0) {
            Configurator.setLevel((String)FallingLeavesClient.LOGGER.getName(), (Level)Level.DEBUG);
        }
        AutoConfig.getGuiRegistry(FallingLeavesConfig.class).registerPredicateProvider((GuiProvider)new LeafSettingsGuiProvider(), field -> field.getName().equals("leafSettings"));
        FallingLeavesClient.LOGGER.debug("Loaded configuration.");
    }

    public static void save() {
        configHolder.save();
    }

    private static void migrateOldConfig() {
        FallingLeavesConfigV0 oldConfig;
        GsonConfigHelper gsonHelper = new GsonConfigHelper("fallingleaves");
        try {
            oldConfig = gsonHelper.load(FallingLeavesConfigV0.class);
        }
        catch (JsonParseException | IOException e) {
            FallingLeavesClient.LOGGER.debug("Couldn't load config as v0, assuming it is v1");
            return;
        }
        if (oldConfig.version != 0) {
            return;
        }
        FallingLeavesClient.LOGGER.info("Migrating old v0 config");
        FallingLeavesConfig newConfig = new FallingLeavesConfig();
        newConfig.setLeafSize(oldConfig.leafSize);
        newConfig.leafLifespan = oldConfig.leafLifespan;
        newConfig.setLeafSpawnRate(oldConfig.leafRate);
        newConfig.setConiferLeafSpawnRate(oldConfig.coniferLeafRate);
        for (String string : oldConfig.coniferLeafIds) {
            newConfig.updateLeafSettings(new class_2960(string), entry -> {
                entry.isConiferBlock = true;
            });
        }
        for (Map.Entry entry2 : oldConfig.rateOverrides.entrySet()) {
            newConfig.updateLeafSettings(new class_2960((String)entry2.getKey()), newEntry -> {
                double oldRateOverride = (Double)oldEntry.getValue();
                if (newEntry.isConiferBlock) {
                    if (oldConfig.coniferLeafRate != 0.0) {
                        newEntry.spawnRateFactor = oldRateOverride / oldConfig.coniferLeafRate;
                    }
                } else if (oldConfig.leafRate != 0.0) {
                    newEntry.spawnRateFactor = oldRateOverride / oldConfig.leafRate;
                }
            });
        }
        try {
            gsonHelper.save(newConfig);
            FallingLeavesClient.LOGGER.info("Migrated successfully");
        }
        catch (JsonIOException | IOException e) {
            FallingLeavesClient.LOGGER.error("Couldn't save migrated config!", e);
        }
    }
}

