/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.util;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;
import randommcsomethin.fallingleaves.FallingLeavesClient;
import randommcsomethin.fallingleaves.config.LeafSettingsEntry;
import randommcsomethin.fallingleaves.init.Config;
import randommcsomethin.fallingleaves.init.Leaves;
import randommcsomethin.fallingleaves.util.RegistryUtil;
import randommcsomethin.fallingleaves.util.TextureCache;

public class LeafUtil {
    public static void trySpawnLeafParticle(class_2680 state, class_1937 world, class_2338 pos, Random random, LeafSettingsEntry leafSettings) {
        double z;
        double y;
        double x = (double)pos.method_10263() + random.nextDouble();
        if (LeafUtil.shouldSpawnParticle(world, pos, x, y = (double)pos.method_10264(), z = (double)pos.method_10260() + random.nextDouble())) {
            class_310 client = class_310.method_1551();
            class_1087 model = client.method_1541().method_3349(state);
            List quads = model.method_4707(state, class_2350.field_11033, random);
            boolean shouldColor = quads.isEmpty() || quads.stream().anyMatch(class_777::method_3360);
            int blockColor = client.method_1505().method_1697(state, (class_1920)world, pos, 0);
            class_2960 texture = LeafUtil.spriteToTexture(model.method_4711());
            double[] color = LeafUtil.calculateLeafColor(texture, shouldColor, blockColor, client);
            double r = color[0];
            double g = color[1];
            double b = color[2];
            world.method_8406((class_2394)(leafSettings.isConiferBlock ? Leaves.FALLING_CONIFER_LEAF : Leaves.FALLING_LEAF), x, y, z, r, g, b);
        }
    }

    private static double[] calculateLeafColor(class_2960 texture, boolean shouldColor, int blockColor, class_310 client) {
        try {
            double[] textureColor;
            class_3298 res = client.method_1478().method_14486(texture);
            String resourcePack = res.method_14480();
            TextureCache.Data cache = TextureCache.INST.get(texture);
            if (cache != null && resourcePack.equals(cache.resourcePack)) {
                textureColor = cache.getColor();
            } else {
                try (InputStream is = res.method_14482();){
                    textureColor = LeafUtil.averageColor(ImageIO.read(is));
                    TextureCache.INST.put(texture, new TextureCache.Data(textureColor, resourcePack));
                    FallingLeavesClient.LOGGER.debug("{}: Calculated texture color {} ", (Object)texture, (Object)textureColor);
                }
            }
            if (shouldColor && blockColor != -1) {
                textureColor[0] = textureColor[0] * ((double)(blockColor >> 16 & 0xFF) / 255.0);
                textureColor[1] = textureColor[1] * ((double)(blockColor >> 8 & 0xFF) / 255.0);
                textureColor[2] = textureColor[2] * ((double)(blockColor & 0xFF) / 255.0);
            }
            return textureColor;
        }
        catch (IOException e) {
            FallingLeavesClient.LOGGER.error("Couldn't access resource {}", (Object)texture, (Object)e);
            return new double[]{1.0, 1.0, 1.0};
        }
    }

    private static boolean shouldSpawnParticle(class_1937 world, class_2338 pos, double x, double y, double z) {
        if (world.method_8320(pos.method_10074()).method_26204() instanceof class_2397) {
            return false;
        }
        double y2 = y - (double)Config.CONFIG.minimumFreeSpaceBelow * 0.5;
        class_238 collisionBox = new class_238(x - 0.1, y, z - 0.1, x + 0.1, y2, z + 0.1);
        return !world.method_20812(null, collisionBox).findAny().isPresent();
    }

    public static Map<class_2960, LeafSettingsEntry> getRegisteredLeafBlocks(boolean useBlockTags) {
        return class_2378.field_11146.method_10235().stream().filter(entry -> {
            class_2248 block = (class_2248)class_2378.field_11146.method_10223(entry);
            return block instanceof class_2397 || useBlockTags && block.method_9525((class_3494)class_3481.field_15503);
        }).collect(Collectors.toMap(Function.identity(), LeafSettingsEntry::new));
    }

    @Nullable
    public static LeafSettingsEntry getLeafSettingsEntry(class_2680 blockState) {
        return Config.CONFIG.leafSettings.get(RegistryUtil.getBlockId(blockState));
    }

    public static double[] averageColor(BufferedImage image) {
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        int n = 0;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                Color c = new Color(image.getRGB(x, y), true);
                if (c.getAlpha() != 255) continue;
                r += (double)c.getRed();
                g += (double)c.getGreen();
                b += (double)c.getBlue();
                ++n;
            }
        }
        return new double[]{r / (double)n / 255.0, g / (double)n / 255.0, b / (double)n / 255.0};
    }

    public static class_2960 spriteToTexture(class_1058 sprite) {
        String texture = sprite.method_4598().method_12832();
        return new class_2960(sprite.method_4598().method_12836(), "textures/" + texture + ".png");
    }
}

