/*
 * Decompiled with CFR 0.152.
 */
package mod.ilja615.fish_in_planks;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class FishBarrelBlock
extends DirectionalBlock {
    private SoundEvent sound;
    protected static final VoxelShape FISH_BARREL_EAST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    protected static final VoxelShape FISH_BARREL_WEST_AABB = Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape FISH_BARREL_SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0);
    protected static final VoxelShape FISH_BARREL_NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape FISH_BARREL_UP_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape FISH_BARREL_DOWN_AABB = Block.func_208617_a((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public FishBarrelBlock(AbstractBlock.Properties properties, SoundEvent s) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176387_N, (Comparable)Direction.UP));
        this.sound = s;
    }

    public VoxelShape func_230335_e_(BlockState p_230335_1_, IBlockReader p_230335_2_, BlockPos p_230335_3_) {
        return VoxelShapes.func_197868_b();
    }

    public VoxelShape func_230322_a_(BlockState p_230322_1_, IBlockReader p_230322_2_, BlockPos p_230322_3_, ISelectionContext p_230322_4_) {
        return VoxelShapes.func_197868_b();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)field_176387_N)) {
            case DOWN: {
                return FISH_BARREL_DOWN_AABB;
            }
            case UP: {
                return FISH_BARREL_UP_AABB;
            }
            case NORTH: {
                return FISH_BARREL_NORTH_AABB;
            }
            case SOUTH: {
                return FISH_BARREL_SOUTH_AABB;
            }
            case WEST: {
                return FISH_BARREL_WEST_AABB;
            }
            case EAST: {
                return FISH_BARREL_EAST_AABB;
            }
        }
        return FISH_BARREL_UP_AABB;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_176387_N, (Comparable)context.func_196010_d().func_176734_d());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)field_176387_N, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)field_176387_N)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)field_176387_N)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176387_N});
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        Random random = new Random();
        entityIn.func_213317_d(new Vector3d(entityIn.func_213322_ci().func_82615_a() * 0.5, entityIn.func_213322_ci().func_82617_b(), entityIn.func_213322_ci().func_82616_c() * 0.5));
        if (!worldIn.field_72995_K) {
            double d0 = Math.abs(entityIn.func_226277_ct_() - entityIn.field_70142_S);
            double d1 = Math.abs(entityIn.func_226281_cx_() - entityIn.field_70136_U);
            double d2 = Math.abs(entityIn.func_226278_cu_() - entityIn.field_70137_T);
            if ((d0 >= (double)0.003f || d1 >= (double)0.003f || d2 >= (double)0.003f) && random.nextInt(16) == 0) {
                worldIn.func_184148_a((PlayerEntity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this.sound, SoundCategory.BLOCKS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
            }
            if ((this.getRegistryName().toString().equals("fish_in_planks:pufferfish_barrel") || this.getRegistryName().toString().equals("fish_in_planks:lionfish_barrel")) && entityIn instanceof LivingEntity && !((LivingEntity)entityIn).func_70644_a(Effects.field_76436_u)) {
                ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76436_u, 200, 2));
            }
        }
    }

    public boolean func_196266_a(BlockState p_196266_1_, IBlockReader p_196266_2_, BlockPos p_196266_3_, PathType p_196266_4_) {
        return false;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (worldIn.func_180495_p(pos).func_177229_b((Property)field_176387_N) == Direction.UP) {
            entityIn.func_225503_b_(fallDistance, 0.2f);
            if (!worldIn.field_72995_K) {
                Random random = new Random();
                if (fallDistance > 10.0f) {
                    worldIn.func_184148_a((PlayerEntity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this.sound, SoundCategory.BLOCKS, 5.0f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
                } else if (fallDistance > 3.0f) {
                    worldIn.func_184148_a((PlayerEntity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this.sound, SoundCategory.BLOCKS, 2.0f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
                } else {
                    worldIn.func_184148_a((PlayerEntity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this.sound, SoundCategory.BLOCKS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
                }
            }
        } else {
            super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        }
    }
}

