/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.network;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.tiles.IFluxController;
import sonar.fluxnetworks.api.tiles.IFluxPlug;
import sonar.fluxnetworks.api.tiles.IFluxPoint;
import sonar.fluxnetworks.api.tiles.IFluxStorage;

public class FluxCacheType<T extends IFluxConnector> {
    public static final FluxCacheType<IFluxConnector> FLUX = new FluxCacheType<IFluxConnector>(IFluxConnector.class);
    public static final FluxCacheType<IFluxPlug> PLUG = new FluxCacheType<IFluxPlug>(IFluxPlug.class);
    public static final FluxCacheType<IFluxPoint> POINT = new FluxCacheType<IFluxPoint>(IFluxPoint.class);
    public static final FluxCacheType<IFluxStorage> STORAGE = new FluxCacheType<IFluxStorage>(IFluxStorage.class);
    public static final FluxCacheType<IFluxController> CONTROLLER = new FluxCacheType<IFluxController>(IFluxController.class);
    private final Class<T> clazz;
    public static final List<FluxCacheType<? extends IFluxConnector>> TYPES = Lists.newArrayList((Object[])new FluxCacheType[]{FLUX, PLUG, POINT, STORAGE, CONTROLLER});

    public FluxCacheType(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Nonnull
    public static List<FluxCacheType<IFluxConnector>> getValidTypes(IFluxConnector tile) {
        ArrayList<FluxCacheType<IFluxConnector>> valid = new ArrayList<FluxCacheType<IFluxConnector>>();
        for (FluxCacheType<? extends IFluxConnector> type : TYPES) {
            if (!type.clazz.isInstance(tile)) continue;
            valid.add(type);
        }
        return valid;
    }
}

