/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.utils.FluxConfigurationType;
import sonar.fluxnetworks.client.gui.basic.GuiFluxCore;
import sonar.fluxnetworks.client.mui.NavigationHome;
import sonar.fluxnetworks.common.core.FluxUtils;
import sonar.fluxnetworks.common.data.FluxNetworkData;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.item.FluxConfiguratorItem;
import sonar.fluxnetworks.common.network.NetworkColourRequestPacket;
import sonar.fluxnetworks.common.tileentity.TileFluxCore;

public class FluxColorHandler
implements IBlockColor,
IItemColor {
    public static final FluxColorHandler INSTANCE = new FluxColorHandler();
    public static final int DEFAULT_COLOR = FluxUtils.getIntFromColor(41, 94, 138);
    public static final int NO_NETWORK_COLOR = FluxUtils.getIntFromColor(178, 178, 178);
    private static final Map<Integer, Integer> COLOR_MAP = new HashMap<Integer, Integer>();
    private static final Map<Integer, String> NAME_MAP = new HashMap<Integer, String>();
    private static final List<Integer> REQUESTS = new ArrayList<Integer>();
    private static final List<Integer> SENT_REQUESTS = new ArrayList<Integer>();
    public static int tickCount;

    public static void reset() {
        COLOR_MAP.clear();
        NAME_MAP.clear();
        REQUESTS.clear();
    }

    public static void loadColorCache(int id, int color) {
        if (id != -1) {
            COLOR_MAP.put(id, color);
        }
    }

    public static void loadNameCache(int id, String name) {
        if (id != -1) {
            NAME_MAP.put(id, name);
        }
    }

    public static void placeRequest(int id) {
        if (id != -1 && !REQUESTS.contains(id) && !SENT_REQUESTS.contains(id)) {
            REQUESTS.add(id);
        }
    }

    public static int getOrRequestNetworkColor(int id) {
        if (id == -1) {
            return NO_NETWORK_COLOR;
        }
        Integer cached = COLOR_MAP.get(id);
        if (cached != null) {
            return cached;
        }
        FluxColorHandler.placeRequest(id);
        return NO_NETWORK_COLOR;
    }

    public static String getOrRequestNetworkName(int id) {
        if (id == -1) {
            return "NONE";
        }
        String cached = NAME_MAP.get(id);
        if (cached != null) {
            return cached;
        }
        FluxColorHandler.placeRequest(id);
        return "WAITING FOR SERVER";
    }

    public static void sendRequests() {
        if (!REQUESTS.isEmpty() && ++tickCount > 40) {
            tickCount = 0;
            PacketHandler.INSTANCE.sendToServer((Object)new NetworkColourRequestPacket(Lists.newArrayList(REQUESTS)));
            SENT_REQUESTS.addAll(REQUESTS);
            REQUESTS.clear();
        }
    }

    public static void receiveCache(Map<Integer, Tuple<Integer, String>> cache) {
        cache.forEach((id, colorToName) -> {
            FluxColorHandler.loadColorCache(id, (Integer)colorToName.func_76341_a());
            FluxColorHandler.loadNameCache(id, (String)colorToName.func_76340_b());
            SENT_REQUESTS.remove(id);
            REQUESTS.remove(id);
        });
    }

    public int getColor(@Nonnull BlockState state, @Nullable ILightReader world, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 1 && pos != null && world != null) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileFluxCore) {
                TileFluxCore t = (TileFluxCore)tile;
                if (t.getNetworkID() == -1) {
                    return NO_NETWORK_COLOR;
                }
                return FluxUtils.getBrighterColor(t.color, 1.2);
            }
            return DEFAULT_COLOR;
        }
        return -1;
    }

    public int getColor(@Nonnull ItemStack stack, int tintIndex) {
        if (tintIndex == 1) {
            CompoundNBT tag;
            if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("GuiColor")) {
                if (FluxConfig.enableGuiDebug && FluxNetworks.modernUILoaded) {
                    return NavigationHome.network.isInvalid() ? NO_NETWORK_COLOR : NavigationHome.network.getSetting(NetworkSettings.NETWORK_COLOR) | 0xFF000000;
                }
                Screen screen = Minecraft.func_71410_x().field_71462_r;
                if (screen instanceof GuiFluxCore) {
                    GuiFluxCore guiFluxCore = (GuiFluxCore)screen;
                    return guiFluxCore.network.isInvalid() ? NO_NETWORK_COLOR : guiFluxCore.network.getSetting(NetworkSettings.NETWORK_COLOR) | 0xFF000000;
                }
            }
            if ((tag = stack.func_179543_a("FluxData")) != null) {
                return FluxColorHandler.getOrRequestNetworkColor(tag.func_74762_e(FluxNetworkData.NETWORK_ID));
            }
            return NO_NETWORK_COLOR;
        }
        return -1;
    }

    public static int colorMultiplierForConfigurator(ItemStack stack, int tintIndex) {
        if (tintIndex == 1) {
            CompoundNBT tag;
            Screen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof GuiFluxCore) {
                GuiFluxCore guiFluxCore = (GuiFluxCore)screen;
                if (guiFluxCore.connector instanceof FluxConfiguratorItem.ContainerProvider) {
                    return guiFluxCore.network.getSetting(NetworkSettings.NETWORK_COLOR);
                }
            }
            if ((tag = stack.func_179543_a("Configs")) != null) {
                return FluxColorHandler.getOrRequestNetworkColor(tag.func_74762_e(FluxConfigurationType.NETWORK.getNBTName()));
            }
            return NO_NETWORK_COLOR;
        }
        return -1;
    }
}

