/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui;

import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.gui.EnumNavigationTabs;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.api.utils.FluxConfigurationType;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.FluxTextWidget;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.client.gui.button.NormalButton;
import sonar.fluxnetworks.client.gui.button.SlidedSwitchButton;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.item.FluxConfiguratorItem;
import sonar.fluxnetworks.common.network.ConfiguratorUpdateSettingsPacket;
import sonar.fluxnetworks.common.network.NetworkUpdateRequestPacket;

public class GuiFluxConfiguratorHome
extends GuiTabCore {
    public InvisibleButton redirectButton;
    public NormalButton apply;
    public FluxTextWidget fluxName;
    public FluxTextWidget priority;
    public FluxTextWidget limit;
    public SlidedSwitchButton surge;
    public SlidedSwitchButton disableLimit;
    public SlidedSwitchButton chunkLoad;
    public ItemStack stack;
    public CompoundNBT configTag;
    public String stackCustomName;
    public int stackPriority;
    public long stackLimit;
    public boolean stackSurgeMode;
    public boolean stackDisableLimit;
    public boolean stackChunkLoading;
    private int timer;

    public GuiFluxConfiguratorHome(PlayerEntity player, FluxConfiguratorItem.ContainerProvider connector) {
        super(player, connector);
        this.stack = connector.stack;
        this.updateSettingsFromTag();
    }

    @Override
    public EnumNavigationTabs getNavigationTab() {
        return EnumNavigationTabs.TAB_HOME;
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        this.screenUtils.renderNetwork(this.network.getSetting(NetworkSettings.NETWORK_NAME), this.network.getSetting(NetworkSettings.NETWORK_COLOR), 20, 8);
        this.screenUtils.drawCenteredString(this.font, TextFormatting.RED + FluxNetworks.PROXY.getFeedback(false).getInfo(), 89, 150, 0xFFFFFF);
        this.font.func_211126_b(FluxTranslate.SURGE_MODE.t(), 20.0f, 90.0f, this.network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
        this.font.func_211126_b(FluxTranslate.DISABLE_LIMIT.t(), 20.0f, 102.0f, this.network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
    }

    @Override
    public void init() {
        super.init();
        this.configureNavigationButtons(EnumNavigationTabs.TAB_HOME, this.navigationTabs);
        this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 8, 135, 12, EnumNavigationTabs.TAB_SELECTION.getTranslatedName(), b -> GuiFluxConfiguratorHome.switchTab(EnumNavigationTabs.TAB_SELECTION, this.player, this.connector));
        this.addButton((Widget)this.redirectButton);
        int color = this.network.getSetting(NetworkSettings.NETWORK_COLOR) | 0xFF000000;
        this.fluxName = FluxTextWidget.create(FluxTranslate.NAME.t() + ": ", this.font, this.field_147003_i + 16, this.field_147009_r + 28, 144, 12).setOutlineColor(color);
        this.fluxName.func_146203_f(24);
        this.fluxName.func_146180_a(this.stackCustomName);
        this.fluxName.func_212954_a(string -> {
            this.stackCustomName = this.fluxName.func_146179_b();
            this.onSettingsChanged();
        });
        this.addButton((Widget)this.fluxName);
        this.priority = FluxTextWidget.create(FluxTranslate.PRIORITY.t() + ": ", this.font, this.field_147003_i + 16, this.field_147009_r + 45, 144, 12).setOutlineColor(color).setDigitsOnly().setAllowNegatives(true);
        this.priority.func_146203_f(5);
        this.priority.func_146180_a(String.valueOf(this.stackPriority));
        this.priority.func_212954_a(string -> {
            this.stackPriority = this.priority.getValidInt();
            this.onSettingsChanged();
        });
        this.addButton((Widget)this.priority);
        this.limit = FluxTextWidget.create(FluxTranslate.TRANSFER_LIMIT.t() + ": ", this.font, this.field_147003_i + 16, this.field_147009_r + 62, 144, 12).setOutlineColor(color).setDigitsOnly().setMaxValue(Long.MAX_VALUE);
        this.limit.func_146203_f(9);
        this.limit.func_146180_a(String.valueOf(this.stackLimit));
        this.limit.func_212954_a(string -> {
            this.stackLimit = this.limit.getValidLong();
            this.onSettingsChanged();
        });
        this.addButton((Widget)this.limit);
        this.surge = new SlidedSwitchButton(140, 90, 1, this.field_147003_i, this.field_147009_r, this.stackSurgeMode);
        this.switches.add(this.surge);
        this.disableLimit = new SlidedSwitchButton(140, 102, 2, this.field_147003_i, this.field_147009_r, this.stackDisableLimit);
        this.switches.add(this.disableLimit);
        this.apply = new NormalButton(FluxTranslate.APPLY.t(), this.field_146999_f / 2 - 18, 138, 36, 12, 3);
        this.buttons.add(this.apply);
        this.apply.clickable = this.configTag == null;
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            if (button instanceof SlidedSwitchButton) {
                SlidedSwitchButton switchButton = (SlidedSwitchButton)button;
                switchButton.switchButton();
                switch (switchButton.id) {
                    case 1: {
                        this.stackSurgeMode = switchButton.slideControl;
                        this.onSettingsChanged();
                        break;
                    }
                    case 2: {
                        this.stackDisableLimit = switchButton.slideControl;
                        this.onSettingsChanged();
                        break;
                    }
                    case 3: {
                        this.stackChunkLoading = switchButton.slideControl;
                    }
                }
            }
            if (button == this.apply) {
                CompoundNBT tag = new CompoundNBT();
                tag.func_74768_a(FluxConfigurationType.NETWORK.getNBTName(), this.network.getNetworkID());
                tag.func_74768_a(FluxConfigurationType.PRIORITY.getNBTName(), this.stackPriority);
                tag.func_74772_a(FluxConfigurationType.TRANSFER.getNBTName(), this.stackLimit);
                tag.func_74757_a(FluxConfigurationType.PRIORITY_SETTING.getNBTName(), this.stackSurgeMode);
                tag.func_74757_a(FluxConfigurationType.TRANSFER_SETTING.getNBTName(), this.stackDisableLimit);
                PacketHandler.INSTANCE.sendToServer((Object)new ConfiguratorUpdateSettingsPacket(this.stackCustomName, tag));
                this.stack.func_77983_a("Configs", (INBT)tag);
                this.updateSettingsFromTag();
                this.apply.setUnclickable();
            }
        }
    }

    public void updateSettingsFromTag() {
        this.configTag = this.stack.func_179543_a("Configs");
        if (this.configTag != null) {
            this.stackCustomName = this.stack.func_200301_q().getString();
            this.stackPriority = this.configTag.func_74762_e(FluxConfigurationType.PRIORITY.getNBTName());
            this.stackSurgeMode = this.configTag.func_74767_n(FluxConfigurationType.PRIORITY_SETTING.getNBTName());
            this.stackLimit = this.configTag.func_74763_f(FluxConfigurationType.TRANSFER.getNBTName());
            this.stackDisableLimit = this.configTag.func_74767_n(FluxConfigurationType.TRANSFER_SETTING.getNBTName());
            this.stackChunkLoading = false;
        } else {
            this.stackCustomName = this.stack.func_200301_q().getString();
            this.stackPriority = 0;
            this.stackSurgeMode = false;
            this.stackLimit = FluxConfig.defaultLimit;
            this.stackDisableLimit = false;
            this.stackChunkLoading = false;
        }
    }

    public void onSettingsChanged() {
        this.apply.clickable = this.configTag == null ? true : this.network.getNetworkID() != this.configTag.func_74762_e(FluxConfigurationType.NETWORK.getNBTName()) || this.stackPriority != this.configTag.func_74762_e(FluxConfigurationType.PRIORITY.getNBTName()) || this.stackLimit != this.configTag.func_74763_f(FluxConfigurationType.TRANSFER.getNBTName()) || this.stackSurgeMode != this.configTag.func_74767_n(FluxConfigurationType.PRIORITY_SETTING.getNBTName()) || this.stackDisableLimit != this.configTag.func_74767_n(FluxConfigurationType.TRANSFER_SETTING.getNBTName()) || !this.stackCustomName.equals(this.stack.func_200301_q());
    }

    @Override
    public void tick() {
        super.tick();
        if (this.timer == 0) {
            PacketHandler.INSTANCE.sendToServer((Object)new NetworkUpdateRequestPacket(this.network.getNetworkID(), NBTType.NETWORK_GENERAL));
        }
        ++this.timer;
        this.timer %= 100;
    }
}

