/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui;

import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.gui.EnumNavigationTabs;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.FluxTextWidget;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.client.gui.button.SlidedSwitchButton;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.NetworkUpdateRequestPacket;
import sonar.fluxnetworks.common.network.TilePacket;
import sonar.fluxnetworks.common.network.TilePacketEnum;
import sonar.fluxnetworks.common.network.TilePacketHandler;
import sonar.fluxnetworks.common.tileentity.TileFluxCore;

public class GuiFluxConnectorHome
extends GuiTabCore {
    public InvisibleButton redirectButton;
    public FluxTextWidget fluxName;
    public FluxTextWidget priority;
    public FluxTextWidget limit;
    public SlidedSwitchButton surge;
    public SlidedSwitchButton disableLimit;
    public SlidedSwitchButton chunkLoad;
    private TileFluxCore tileEntity;
    private int timer;

    public GuiFluxConnectorHome(PlayerEntity player, TileFluxCore tileEntity) {
        super(player, tileEntity);
        this.tileEntity = tileEntity;
    }

    @Override
    public EnumNavigationTabs getNavigationTab() {
        return EnumNavigationTabs.TAB_HOME;
    }

    @Override
    public void init() {
        super.init();
        this.configureNavigationButtons(EnumNavigationTabs.TAB_HOME, this.navigationTabs);
        this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 8, 135, 12, EnumNavigationTabs.TAB_SELECTION.getTranslatedName(), b -> GuiFluxConnectorHome.switchTab(EnumNavigationTabs.TAB_SELECTION, this.player, this.connector));
        this.addButton((Widget)this.redirectButton);
        int color = this.network.getSetting(NetworkSettings.NETWORK_COLOR) | 0xFF000000;
        this.fluxName = FluxTextWidget.create(FluxTranslate.NAME.t() + ": ", this.font, this.field_147003_i + 16, this.field_147009_r + 28, 144, 12).setOutlineColor(color);
        this.fluxName.func_146203_f(24);
        this.fluxName.func_146180_a(this.tileEntity.getCustomName());
        this.fluxName.func_212954_a(string -> {
            this.tileEntity.customName = this.fluxName.func_146179_b();
            this.tileEntity.sendTilePacketToServer((byte)0);
        });
        this.addButton((Widget)this.fluxName);
        this.priority = FluxTextWidget.create(FluxTranslate.PRIORITY.t() + ": ", this.font, this.field_147003_i + 16, this.field_147009_r + 45, 144, 12).setOutlineColor(color).setDigitsOnly().setAllowNegatives(true);
        this.priority.func_146203_f(5);
        this.priority.func_146180_a(String.valueOf(this.tileEntity.priority));
        this.priority.func_212954_a(string -> {
            this.tileEntity.priority = this.priority.getValidInt();
            this.tileEntity.sendTilePacketToServer((byte)1);
        });
        this.addButton((Widget)this.priority);
        this.limit = FluxTextWidget.create(FluxTranslate.TRANSFER_LIMIT.t() + ": ", this.font, this.field_147003_i + 16, this.field_147009_r + 62, 144, 12).setOutlineColor(color).setDigitsOnly().setMaxValue(this.tileEntity.getMaxTransferLimit());
        this.limit.func_146203_f(9);
        this.limit.func_146180_a(String.valueOf(this.tileEntity.limit));
        this.limit.func_212954_a(string -> {
            this.tileEntity.limit = this.limit.getValidLong();
            this.tileEntity.sendTilePacketToServer((byte)2);
        });
        this.addButton((Widget)this.limit);
        this.surge = new SlidedSwitchButton(140, 120, 1, this.field_147003_i, this.field_147009_r, this.tileEntity.surgeMode);
        this.disableLimit = new SlidedSwitchButton(140, 132, 2, this.field_147003_i, this.field_147009_r, this.tileEntity.disableLimit);
        this.switches.add(this.surge);
        this.switches.add(this.disableLimit);
        if (!this.tileEntity.getConnectionType().isStorage()) {
            this.chunkLoad = new SlidedSwitchButton(140, 144, 3, this.field_147003_i, this.field_147009_r, this.tileEntity.chunkLoading);
            this.switches.add(this.chunkLoad);
        }
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        this.screenUtils.renderNetwork(this.network.getSetting(NetworkSettings.NETWORK_NAME), this.network.getSetting(NetworkSettings.NETWORK_COLOR), 20, 8);
        this.renderTransfer(this.tileEntity, 0xFFFFFF, 30, 90);
        this.screenUtils.drawCenteredString(this.font, TextFormatting.RED + FluxNetworks.PROXY.getFeedback(false).getInfo(), 89, 150, 0xFFFFFF);
        this.font.func_211126_b(FluxTranslate.SURGE_MODE.t(), 20.0f, 120.0f, this.network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
        this.font.func_211126_b(FluxTranslate.DISABLE_LIMIT.t(), 20.0f, 132.0f, this.network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
        if (!this.tileEntity.getConnectionType().isStorage()) {
            this.font.func_211126_b(FluxTranslate.CHUNK_LOADING.t(), 20.0f, 144.0f, this.network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && button instanceof SlidedSwitchButton) {
            SlidedSwitchButton switchButton = (SlidedSwitchButton)button;
            switch (switchButton.id) {
                case 1: {
                    switchButton.switchButton();
                    this.tileEntity.surgeMode = switchButton.slideControl;
                    this.tileEntity.sendTilePacketToServer((byte)3);
                    break;
                }
                case 2: {
                    switchButton.switchButton();
                    this.tileEntity.disableLimit = switchButton.slideControl;
                    this.tileEntity.sendTilePacketToServer((byte)4);
                    break;
                }
                case 3: {
                    PacketHandler.INSTANCE.sendToServer((Object)new TilePacket(TilePacketEnum.CHUNK_LOADING, TilePacketHandler.getChunkLoadPacket(!switchButton.slideControl), this.tileEntity.getCoords()));
                }
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.timer == 0) {
            PacketHandler.INSTANCE.sendToServer((Object)new NetworkUpdateRequestPacket(this.network.getNetworkID(), NBTType.NETWORK_GENERAL));
        }
        if (this.timer % 4 == 0 && this.chunkLoad != null) {
            this.chunkLoad.slideControl = this.tileEntity.chunkLoading;
        }
        ++this.timer;
        this.timer %= 100;
    }
}

