/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.basic;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.client.gui.basic.GuiFocusable;
import sonar.fluxnetworks.client.gui.popups.PopUpCore;
import sonar.fluxnetworks.common.core.ContainerConnector;

public abstract class GuiPopUpHost
extends GuiFocusable<ContainerConnector<?>> {
    public INetworkConnector connector;
    public PlayerEntity player;
    public PopUpCore<GuiPopUpHost> currentPopUp;

    public GuiPopUpHost(PlayerEntity player, INetworkConnector connector) {
        super(new ContainerConnector<INetworkConnector>(0, player.field_71071_by, connector), player.field_71071_by, ((INamedContainerProvider)connector).func_145748_c_());
        this.player = player;
        this.connector = connector;
    }

    public final boolean hasActivePopup() {
        return this.currentPopUp != null;
    }

    public final void openPopUp(PopUpCore popUp) {
        if (popUp == null) {
            return;
        }
        if (this.currentPopUp != null) {
            this.currentPopUp.closePopUp();
            this.currentPopUp = null;
        }
        this.currentPopUp = popUp;
        this.currentPopUp.openPopUp();
        this.onPopUpOpen(popUp);
    }

    public void onPopUpOpen(PopUpCore popUp) {
    }

    public final void closePopUp() {
        if (this.currentPopUp != null) {
            this.onPopUpClose(this.currentPopUp);
            this.currentPopUp.closePopUp();
            this.currentPopUp = null;
        }
    }

    public void onPopUpClose(PopUpCore popUp) {
    }

    @Nullable
    public IGuiEventListener getPopUp() {
        return this.currentPopUp;
    }

    public void func_212927_b(double xPos, double yPos) {
        if (this.getPopUp() != null) {
            this.mouseMovedPopUp(xPos, yPos);
            return;
        }
        if (this.mouseMovedMain(xPos, yPos)) {
            return;
        }
        super.func_212927_b(xPos, yPos);
    }

    public void mouseMovedPopUp(double xPos, double yPos) {
        this.getPopUp().func_212927_b(xPos, yPos);
    }

    public boolean mouseMovedMain(double xPos, double yPos) {
        return false;
    }

    public final boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.getPopUp() != null) {
            return this.mouseClickedPopUp(mouseX, mouseY, mouseButton);
        }
        return this.mouseClickedMain(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseClickedPopUp(double mouseX, double mouseY, int mouseButton) {
        return this.getPopUp().mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseClickedMain(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public final boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.getPopUp() != null) {
            return this.mouseReleasedPopUp(mouseX, mouseY, mouseButton);
        }
        return this.mouseReleasedMain(mouseX, mouseY, mouseButton) || super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleasedPopUp(double mouseX, double mouseY, int mouseButton) {
        return this.getPopUp().mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleasedMain(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public final boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double startX, double startY) {
        if (this.getPopUp() != null) {
            return this.mouseDraggedPopUp(mouseX, mouseY, mouseButton, startX, mouseY);
        }
        return this.mouseDraggedMain(mouseX, mouseY, mouseButton, startX, mouseY) || super.mouseDragged(mouseX, mouseY, mouseButton, startX, mouseY);
    }

    public boolean mouseDraggedPopUp(double mouseX, double mouseY, int mouseButton, double startX, double startY) {
        return this.getPopUp().mouseDragged(mouseX, mouseY, mouseButton, startX, startY);
    }

    public boolean mouseDraggedMain(double mouseX, double mouseY, int mouseButton, double startX, double startY) {
        return false;
    }

    public final boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        if (this.getPopUp() != null) {
            return this.mouseScrolledPopUp(mouseX, mouseY, scroll);
        }
        return this.mouseScrolledMain(mouseX, mouseY, scroll) || super.mouseScrolled(mouseX, mouseY, scroll);
    }

    public boolean mouseScrolledPopUp(double mouseX, double mouseY, double scroll) {
        return this.getPopUp().mouseScrolled(mouseX, mouseY, scroll);
    }

    public boolean mouseScrolledMain(double mouseX, double mouseY, double scroll) {
        return false;
    }

    @Override
    public final boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.getPopUp() != null) {
            return this.keyPressedPopUp(keyCode, scanCode, modifiers);
        }
        return this.keyPressedMain(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyPressedPopUp(int keyCode, int scanCode, int modifiers) {
        return this.getPopUp().keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyPressedMain(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public final boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        if (this.getPopUp() != null) {
            return this.keyReleasedPopUp(keyCode, scanCode, modifiers);
        }
        return this.keyReleasedMain(keyCode, scanCode, modifiers) || super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean keyReleasedPopUp(int keyCode, int scanCode, int modifiers) {
        return this.getPopUp().func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean keyReleasedMain(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public final boolean charTyped(char typedChar, int keyCode) {
        if (this.getPopUp() != null) {
            return this.charTypedPopUp(typedChar, keyCode);
        }
        return this.charTypedMain(typedChar, keyCode) || super.charTyped(typedChar, keyCode);
    }

    public boolean charTypedPopUp(char typedChar, int keyCode) {
        return this.getPopUp().charTyped(typedChar, keyCode);
    }

    public boolean charTypedMain(char typedChar, int keyCode) {
        return false;
    }

    public void init(Minecraft mc, int width, int height) {
        super.init(mc, width, height);
        if (this.currentPopUp != null) {
            this.currentPopUp.init(mc, width, height);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (this.currentPopUp != null) {
            // empty if block
        }
    }

    public void func_191948_b(int mouseX, int mouseY) {
        if (this.currentPopUp == null) {
            super.func_191948_b(mouseX, mouseY);
        }
    }

    protected void drawForegroundLayer(int mouseX, int mouseY) {
    }

    protected void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
    }

    protected final void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.drawForegroundLayer(mouseX, mouseY);
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        if (this.currentPopUp != null) {
            RenderSystem.disableDepthTest();
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)(-this.field_147003_i), (double)(-this.field_147009_r), (double)0.0);
            this.currentPopUp.func_146976_a(partialTicks, mouseX, mouseY);
            RenderSystem.popMatrix();
            this.currentPopUp.func_146979_b(mouseX, mouseY);
            RenderSystem.enableDepthTest();
        }
    }

    protected final void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        this.drawFluxDefaultBackground();
        this.drawBackgroundLayer(partialTicks, mouseX, mouseY);
    }
}

