/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.button;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;

public class FluxTextWidget
extends TextFieldWidget {
    private String origin;
    private String extraText;
    private int textWidth;
    private boolean hexOnly;
    private FontRenderer font;
    private boolean digitsOnly;
    private long maxValue = Integer.MAX_VALUE;
    private boolean allowNegatives = false;
    private int outlineColor = -4934476;
    private static final int boxColor = 0x20000000;

    public FluxTextWidget(String text, FontRenderer fontRenderer, int x, int y, int par5Width, int par6Height, int width) {
        super(fontRenderer, x + width, y, par5Width - width, par6Height, "");
        this.extraText = text;
        this.textWidth = width;
        this.font = fontRenderer;
    }

    public static FluxTextWidget create(String text, FontRenderer fontRenderer, int x, int y, int width, int height) {
        return new FluxTextWidget(text, fontRenderer, x, y, width, height, fontRenderer.func_78256_a(text));
    }

    public int getIntegerFromText(boolean allowNegatives) {
        if (this.func_146179_b().isEmpty() || this.func_146179_b().equals("-")) {
            return 0;
        }
        int parseInt = Integer.parseInt(this.func_146179_b());
        return allowNegatives ? parseInt : Math.max(parseInt, 0);
    }

    public long getLongFromText(boolean allowNegatives) {
        if (this.func_146179_b().isEmpty() || this.func_146179_b().equals("-")) {
            return 0L;
        }
        long parseLong = Long.parseLong(this.func_146179_b());
        return allowNegatives ? parseLong : Math.max(parseLong, 0L);
    }

    public int getIntegerFromHex() {
        return Integer.parseInt(this.func_146179_b(), 16);
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        this.func_146185_a(true);
        if (this.func_146176_q()) {
            FluxTextWidget.fill((int)(this.x - this.textWidth - 1), (int)(this.y - 1), (int)(this.x + this.width + 1), (int)this.y, (int)this.outlineColor);
            FluxTextWidget.fill((int)(this.x - this.textWidth - 1), (int)(this.y + this.height), (int)(this.x + this.width + 1), (int)(this.y + this.height + 1), (int)this.outlineColor);
            FluxTextWidget.fill((int)(this.x - this.textWidth - 1), (int)this.y, (int)(this.x - this.textWidth), (int)(this.y + this.height), (int)this.outlineColor);
            FluxTextWidget.fill((int)(this.x + this.width), (int)this.y, (int)(this.x + this.width + 1), (int)(this.y + this.height), (int)this.outlineColor);
            FluxTextWidget.fill((int)(this.x - this.textWidth), (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)0x20000000);
        }
        this.func_146185_a(false);
        this.x += 4;
        this.y += (this.height - 8) / 2;
        super.renderButton(mouseX, mouseY, partialTicks);
        this.font.func_211126_b(this.extraText, (float)(this.x - this.textWidth), (float)this.y, this.outlineColor);
        this.x -= 4;
        this.y -= (this.height - 8) / 2;
    }

    public void func_146191_b(String textToWrite) {
        char c;
        int i;
        if (this.digitsOnly) {
            for (i = 0; i < textToWrite.length(); ++i) {
                c = textToWrite.charAt(i);
                if (Character.isDigit(c)) continue;
                if (this.func_146179_b().isEmpty()) {
                    if (c == '-') continue;
                    return;
                }
                return;
            }
        }
        if (this.hexOnly) {
            for (i = 0; i < textToWrite.length(); ++i) {
                c = textToWrite.charAt(i);
                if (c != '-') continue;
                return;
            }
            String origin = this.func_146179_b();
            super.func_146191_b(textToWrite);
            try {
                Integer.parseInt(this.func_146179_b(), 16);
            }
            catch (NumberFormatException ignored) {
                this.func_146180_a(origin);
            }
            return;
        }
        super.func_146191_b(textToWrite);
    }

    public void func_146195_b(boolean isFocusedIn) {
        super.func_146195_b(isFocusedIn);
        if (this.digitsOnly) {
            if (isFocusedIn) {
                this.origin = this.func_146179_b();
            } else {
                try {
                    this.func_146180_a(String.valueOf(this.getValidLong()));
                }
                catch (NumberFormatException ignored) {
                    this.func_146180_a(this.origin);
                    System.out.println(ignored.getMessage());
                }
            }
        }
    }

    public long getValidLong() {
        return Math.min(this.getLongFromText(this.allowNegatives), this.maxValue);
    }

    public int getValidInt() {
        return (int)Math.min(this.getValidLong(), Integer.MAX_VALUE);
    }

    public FluxTextWidget setOutlineColor(int color) {
        this.outlineColor = color;
        return this;
    }

    public FluxTextWidget setTextInvisible() {
        this.func_195607_a(FluxTextWidget::getInvisibleText);
        return this;
    }

    public static String getInvisibleText(String string, int cursorPos) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            builder.append("*");
        }
        return builder.toString();
    }

    public FluxTextWidget setDigitsOnly() {
        this.digitsOnly = true;
        return this;
    }

    public FluxTextWidget setAllowNegatives(boolean allowNegatives) {
        this.allowNegatives = allowNegatives;
        return this;
    }

    public FluxTextWidget setMaxValue(long max) {
        this.maxValue = max;
        return this;
    }

    public FluxTextWidget setHexOnly() {
        this.hexOnly = true;
        return this;
    }
}

