/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.popups;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.api.utils.Coord4D;
import sonar.fluxnetworks.client.gui.button.FluxTextWidget;
import sonar.fluxnetworks.client.gui.button.NormalButton;
import sonar.fluxnetworks.client.gui.button.SimpleToggleButton;
import sonar.fluxnetworks.client.gui.button.SlidedSwitchButton;
import sonar.fluxnetworks.client.gui.popups.PopUpCore;
import sonar.fluxnetworks.client.gui.tab.GuiTabConnections;
import sonar.fluxnetworks.common.core.FluxUtils;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.BatchEditingPacket;

public class PopUpConnectionEdit
extends PopUpCore<GuiTabConnections> {
    public NormalButton apply;
    public FluxTextWidget fluxName;
    public FluxTextWidget priority;
    public FluxTextWidget limit;
    public SlidedSwitchButton surge;
    public SlidedSwitchButton unlimited;
    public SlidedSwitchButton chunkLoad;
    public SimpleToggleButton editName;
    public SimpleToggleButton editPriority;
    public SimpleToggleButton editLimit;
    public SimpleToggleButton editSurge;
    public SimpleToggleButton editUnlimited;
    public SimpleToggleButton editChunkLoad;
    public boolean batchMode;
    private List<SimpleToggleButton> toggleButtons = new ArrayList<SimpleToggleButton>();

    public PopUpConnectionEdit(GuiTabConnections host, boolean batchMode, PlayerEntity player, INetworkConnector connector) {
        super(host, player, connector);
        this.batchMode = batchMode;
    }

    @Override
    public void init() {
        super.init();
        this.toggleButtons.clear();
        this.popButtons.add(new NormalButton(FluxTranslate.CANCEL.t(), 40, 140, 36, 12, 11));
        this.apply = new NormalButton(FluxTranslate.APPLY.t(), 100, 140, 36, 12, 12).setUnclickable();
        this.popButtons.add(this.apply);
        int color = ((GuiTabConnections)this.host).network.getSetting(NetworkSettings.NETWORK_COLOR) | 0xFF000000;
        if (this.batchMode) {
            this.fluxName = FluxTextWidget.create(FluxTranslate.NAME.t() + ": ", this.font, this.field_147003_i + 20, this.field_147009_r + 30, 136, 12).setOutlineColor(color);
            this.fluxName.func_146203_f(24);
            this.addButton((Widget)this.fluxName);
            this.priority = FluxTextWidget.create(FluxTranslate.PRIORITY.t() + ": ", this.font, this.field_147003_i + 20, this.field_147009_r + 47, 136, 12).setOutlineColor(color).setDigitsOnly().setAllowNegatives(true);
            this.priority.func_146203_f(5);
            this.priority.func_146180_a(String.valueOf(0));
            this.addButton((Widget)this.priority);
            this.limit = FluxTextWidget.create(FluxTranslate.TRANSFER_LIMIT.t() + ": ", this.font, this.field_147003_i + 20, this.field_147009_r + 64, 136, 12).setOutlineColor(color).setDigitsOnly().setMaxValue(Long.MAX_VALUE);
            this.limit.func_146203_f(9);
            this.limit.func_146180_a(String.valueOf(0));
            this.addButton((Widget)this.limit);
            this.editName = new SimpleToggleButton(10, 33, this.field_147003_i, this.field_147009_r, 0);
            this.editPriority = new SimpleToggleButton(10, 50, this.field_147003_i, this.field_147009_r, 1);
            this.editLimit = new SimpleToggleButton(10, 67, this.field_147003_i, this.field_147009_r, 2);
            this.editSurge = new SimpleToggleButton(10, 82, this.field_147003_i, this.field_147009_r, 3);
            this.editUnlimited = new SimpleToggleButton(10, 94, this.field_147003_i, this.field_147009_r, 4);
            this.editChunkLoad = new SimpleToggleButton(10, 106, this.field_147003_i, this.field_147009_r, 5);
            this.toggleButtons.add(this.editName);
            this.toggleButtons.add(this.editPriority);
            this.toggleButtons.add(this.editLimit);
            this.toggleButtons.add(this.editSurge);
            this.toggleButtons.add(this.editUnlimited);
            this.toggleButtons.add(this.editChunkLoad);
            this.surge = new SlidedSwitchButton(140, 82, 1, this.field_147003_i, this.field_147009_r, false);
            this.unlimited = new SlidedSwitchButton(140, 94, 2, this.field_147003_i, this.field_147009_r, false);
            this.chunkLoad = new SlidedSwitchButton(140, 106, 3, this.field_147003_i, this.field_147009_r, false);
            this.popSwitches.add(this.surge);
            this.popSwitches.add(this.unlimited);
            this.popSwitches.add(this.chunkLoad);
        } else {
            this.fluxName = FluxTextWidget.create(FluxTranslate.NAME.t() + ": ", this.font, this.field_147003_i + 18, this.field_147009_r + 30, 140, 12).setOutlineColor(color);
            this.fluxName.func_146203_f(24);
            this.fluxName.func_146180_a(((GuiTabConnections)this.host).singleConnection.getCustomName());
            this.fluxName.func_212954_a(string -> {
                this.apply.clickable = true;
            });
            this.addButton((Widget)this.fluxName);
            this.priority = FluxTextWidget.create(FluxTranslate.PRIORITY.t() + ": ", this.font, this.field_147003_i + 18, this.field_147009_r + 47, 140, 12).setOutlineColor(color).setDigitsOnly().setAllowNegatives(true);
            this.priority.func_146203_f(5);
            this.priority.func_146180_a(String.valueOf(((GuiTabConnections)this.host).singleConnection.getPriority()));
            this.priority.func_212954_a(string -> {
                this.apply.clickable = true;
            });
            this.addButton((Widget)this.priority);
            this.limit = FluxTextWidget.create(FluxTranslate.TRANSFER_LIMIT.t() + ": ", this.font, this.field_147003_i + 18, this.field_147009_r + 64, 140, 12).setOutlineColor(color).setDigitsOnly().setMaxValue(Long.MAX_VALUE);
            this.limit.func_146203_f(9);
            this.limit.func_146180_a(String.valueOf(((GuiTabConnections)this.host).singleConnection.getCurrentLimit()));
            this.limit.func_212954_a(string -> {
                this.apply.clickable = true;
            });
            this.addButton((Widget)this.limit);
            this.surge = new SlidedSwitchButton(140, 82, 1, this.field_147003_i, this.field_147009_r, ((GuiTabConnections)this.host).singleConnection.getSurgeMode());
            this.unlimited = new SlidedSwitchButton(140, 94, 2, this.field_147003_i, this.field_147009_r, ((GuiTabConnections)this.host).singleConnection.getDisableLimit());
            this.popSwitches.add(this.surge);
            this.popSwitches.add(this.unlimited);
            if (!((GuiTabConnections)this.host).singleConnection.getConnectionType().isStorage()) {
                this.chunkLoad = new SlidedSwitchButton(140, 106, 3, this.field_147003_i, this.field_147009_r, ((GuiTabConnections)this.host).singleConnection.isForcedLoading());
                this.popSwitches.add(this.chunkLoad);
            }
        }
    }

    @Override
    public void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        for (SlidedSwitchButton slidedSwitchButton : this.popSwitches) {
            slidedSwitchButton.drawButton(this.minecraft, mouseX, mouseY, this.field_147003_i, this.field_147009_r);
        }
        for (SimpleToggleButton simpleToggleButton : this.toggleButtons) {
            simpleToggleButton.drawButton(this.minecraft, mouseX, mouseY, this.field_147003_i, this.field_147009_r);
        }
        if (!this.batchMode) {
            this.drawCenteredString(this.font, FluxTranslate.SINGLE_EDIT.t(), 88, 14, 0xFFFFFF);
            this.drawCenteredString(this.font, ((GuiTabConnections)this.host).singleConnection.getCoords().getStringInfo(), 88, 122, 0xFFFFFF);
        } else {
            this.drawCenteredString(this.font, FluxTranslate.BATCH_EDIT.t(), 88, 14, 0xFFFFFF);
            this.drawCenteredString(this.font, FluxTranslate.EDITING.t() + " " + ((GuiTabConnections)this.host).batchConnections.size() + " " + FluxTranslate.CONNECTIONS.t(), 88, 122, 0xFFFFFF);
        }
        this.font.func_211126_b(FluxTranslate.SURGE_MODE.t(), 20.0f, 82.0f, ((GuiTabConnections)this.host).network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
        this.font.func_211126_b(FluxTranslate.DISABLE_LIMIT.t(), 20.0f, 94.0f, ((GuiTabConnections)this.host).network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
        if (this.batchMode || !((GuiTabConnections)this.host).singleConnection.getConnectionType().isStorage()) {
            this.font.func_211126_b(FluxTranslate.CHUNK_LOADING.t(), 20.0f, 106.0f, ((GuiTabConnections)this.host).network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
        }
        this.drawCenteredString(this.font, TextFormatting.RED + FluxNetworks.PROXY.getFeedback(false).getInfo(), 88, 155, 0xFFFFFF);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            for (NormalButton normalButton : this.popButtons) {
                ArrayList list;
                if (!normalButton.clickable || !normalButton.isMouseHovered(this.minecraft, (int)mouseX - this.field_147003_i, (int)mouseY - this.field_147009_r)) continue;
                if (normalButton.id == 11) {
                    ((GuiTabConnections)this.host).closePopUp();
                    return true;
                }
                if (normalButton.id != 12) continue;
                boolean[] b2 = new boolean[]{true, true, true, true, true, true, false};
                if (this.batchMode) {
                    list = ((GuiTabConnections)this.host).batchConnections.stream().map(IFluxConnector::getCoords).collect(Collectors.toList());
                    b2[0] = this.editName.on;
                    b2[1] = this.editPriority.on;
                    b2[2] = this.editLimit.on;
                    b2[3] = this.editSurge.on;
                    b2[4] = this.editUnlimited.on;
                    b2[5] = this.editChunkLoad.on;
                } else {
                    list = Lists.newArrayList((Object[])new Coord4D[]{((GuiTabConnections)this.host).singleConnection.getCoords()});
                }
                CompoundNBT tag = FluxUtils.getBatchEditingTag(this.fluxName, this.priority, this.limit, this.surge, this.unlimited, this.chunkLoad);
                PacketHandler.INSTANCE.sendToServer((Object)new BatchEditingPacket(((GuiTabConnections)this.host).network.getNetworkID(), list, tag, b2));
                return true;
            }
            for (SlidedSwitchButton slidedSwitchButton : this.popSwitches) {
                if (!slidedSwitchButton.isMouseHovered(this.minecraft, (int)mouseX - this.field_147003_i, (int)mouseY - this.field_147009_r)) continue;
                slidedSwitchButton.switchButton();
                if (!this.batchMode) {
                    this.apply.clickable = true;
                }
                return true;
            }
            for (SimpleToggleButton simpleToggleButton : this.toggleButtons) {
                if (!simpleToggleButton.isMouseHovered(this.minecraft, (int)mouseX - this.field_147003_i, (int)mouseY - this.field_147009_r)) continue;
                simpleToggleButton.on = !simpleToggleButton.on;
                this.apply.clickable = this.toggleButtons.stream().anyMatch(b -> b.on);
                return true;
            }
        }
        return false;
    }
}

