/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.gui.EnumFeedbackInfo;
import sonar.fluxnetworks.api.gui.EnumNavigationTabs;
import sonar.fluxnetworks.api.gui.EnumNetworkColor;
import sonar.fluxnetworks.api.network.EnumSecurityType;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.api.utils.EnergyType;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.button.ColorButton;
import sonar.fluxnetworks.client.gui.button.NormalButton;
import sonar.fluxnetworks.client.gui.tab.GuiTabEditAbstract;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.GeneralPacket;
import sonar.fluxnetworks.common.network.GeneralPacketEnum;
import sonar.fluxnetworks.common.network.GeneralPacketHandler;

public class GuiTabCreate
extends GuiTabEditAbstract {
    public NormalButton apply;
    public NormalButton create;

    public GuiTabCreate(PlayerEntity player, INetworkConnector connector) {
        super(player, connector);
        this.securityType = EnumSecurityType.ENCRYPTED;
        this.energyType = EnergyType.FE;
    }

    @Override
    public EnumNavigationTabs getNavigationTab() {
        return EnumNavigationTabs.TAB_CREATE;
    }

    @Override
    public void init() {
        super.init();
        this.name.func_146180_a(this.minecraft.field_71439_g.func_145748_c_().func_150254_d() + "'s Network");
        int i = 0;
        for (EnumNetworkColor color : EnumNetworkColor.values()) {
            this.colorButtons.add(new ColorButton(48 + (i >= 7 ? i - 7 : i) * 16, 96 + (i >= 7 ? 1 : 0) * 16, color.color));
            ++i;
        }
        this.color = (ColorButton)((Object)this.colorButtons.get(0));
        this.color.selected = true;
        this.create = new NormalButton(FluxTranslate.CREATE.t(), 70, 150, 36, 12, 3).setUnclickable();
        this.buttons.add(this.create);
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        this.screenUtils.renderNetwork(this.name.func_146179_b(), this.color.color, 20, 129);
        this.drawCenteredString(this.font, TextFormatting.RED + FluxNetworks.PROXY.getFeedback(false).getInfo(), 88, 150, 0xFFFFFF);
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (button instanceof NormalButton && mouseButton == 0 && button.id == 3) {
            PacketHandler.INSTANCE.sendToServer((Object)new GeneralPacket(GeneralPacketEnum.CREATE_NETWORK, GeneralPacketHandler.getCreateNetworkPacket(this.name.func_146179_b(), this.color.color, this.securityType, this.energyType, this.password.func_146179_b())));
        }
    }

    @Override
    public void onEditSettingsChanged() {
        if (this.create != null) {
            this.create.clickable = (!this.securityType.isEncrypted() || this.password.func_146179_b().length() != 0) && this.name.func_146179_b().length() != 0;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (FluxNetworks.PROXY.getFeedback(true) == EnumFeedbackInfo.SUCCESS) {
            GuiTabCreate.switchTab(EnumNavigationTabs.TAB_SELECTION, this.player, this.connector);
            FluxNetworks.PROXY.setFeedback(EnumFeedbackInfo.NONE, true);
        }
    }
}

