/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.gui.EnumFeedbackInfo;
import sonar.fluxnetworks.api.gui.EnumNavigationTabs;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.client.gui.ScreenUtils;
import sonar.fluxnetworks.client.gui.basic.GuiTabPages;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.client.gui.popups.PopUpUserEdit;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.GUIPermissionRequestPacket;
import sonar.fluxnetworks.common.network.NetworkUpdateRequestPacket;

public class GuiTabMembers
extends GuiTabPages<NetworkMember> {
    public InvisibleButton redirectButton;
    public NetworkMember selectedPlayer;
    private int timer;

    public GuiTabMembers(PlayerEntity player, INetworkConnector connector) {
        super(player, connector);
        this.gridStartX = 15;
        this.gridStartY = 22;
        this.gridHeight = 13;
        this.gridPerPage = 10;
        this.elementHeight = 12;
        this.elementWidth = 146;
        PacketHandler.INSTANCE.sendToServer((Object)new NetworkUpdateRequestPacket(this.network.getNetworkID(), NBTType.NETWORK_PLAYERS));
    }

    @Override
    public EnumNavigationTabs getNavigationTab() {
        return EnumNavigationTabs.TAB_MEMBER;
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        if (this.networkValid) {
            String str2 = this.accessPermission.getName();
            this.font.func_211126_b(str2, (float)(158 - this.font.func_78256_a(str2)), 10.0f, 0xFFFFFF);
            this.font.func_211126_b(FluxTranslate.SORT_BY.t() + ": " + TextFormatting.AQUA + FluxTranslate.SORTING_SMART.t(), 19.0f, 10.0f, 0xFFFFFF);
            super.drawForegroundLayer(mouseX, mouseY);
        } else {
            super.drawForegroundLayer(mouseX, mouseY);
            this.renderNavigationPrompt(FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
        }
    }

    @Override
    public void init() {
        super.init();
        this.configureNavigationButtons(EnumNavigationTabs.TAB_MEMBER, this.navigationTabs);
        if (!this.networkValid) {
            this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 16, 135, 20, EnumNavigationTabs.TAB_SELECTION.getTranslatedName(), b -> GuiTabMembers.switchTab(EnumNavigationTabs.TAB_SELECTION, this.player, this.connector));
            this.addButton((Widget)this.redirectButton);
        }
    }

    @Override
    protected void onElementClicked(NetworkMember element, int mouseButton) {
        if (mouseButton == 0) {
            this.selectedPlayer = element;
            this.openPopUp(new PopUpUserEdit(this, this.player, this.connector));
        }
    }

    @Override
    public void renderElement(NetworkMember element, int x, int y) {
        GlStateManager.func_227626_N_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227709_e_();
        int color = element.getAccessPermission().color;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color4f((float)f, (float)f1, (float)f2, (float)0.8f);
        this.minecraft.func_110434_K().func_110577_a(ScreenUtils.GUI_BAR);
        this.blit(x, y, 0, 16, this.elementWidth, this.elementHeight);
        if (element.getPlayerUUID().equals(this.player.func_110124_au())) {
            GuiTabMembers.fill((int)(x - 4), (int)(y + 1), (int)(x - 2), (int)(y + this.elementHeight - 1), (int)-855638017);
            GuiTabMembers.fill((int)(x + this.elementWidth + 2), (int)(y + 1), (int)(x + this.elementWidth + 4), (int)(y + this.elementHeight - 1), (int)-855638017);
        }
        this.font.func_211126_b(TextFormatting.WHITE + element.getCachedName(), (float)(x + 4), (float)(y + 2), 0xFFFFFF);
        String p = element.getAccessPermission().getName();
        this.font.func_211126_b(p, (float)(x + 142 - this.font.func_78256_a(p)), (float)(y + 2), 0xFFFFFF);
        GlStateManager.func_227627_O_();
    }

    @Override
    public void renderElementTooltip(NetworkMember element, int mouseX, int mouseY) {
        if (this.hasActivePopup()) {
            return;
        }
        GlStateManager.func_227626_N_();
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(FluxTranslate.USERNAME.t() + ": " + TextFormatting.AQUA + element.getCachedName());
        String permission = element.getAccessPermission().getName() + (element.getPlayerUUID().equals(this.player.func_110124_au()) ? " (" + FluxTranslate.YOU.t() + ")" : "");
        strings.add(FluxTranslate.ACCESS.t() + ": " + TextFormatting.RESET + permission);
        this.screenUtils.drawHoverTooltip(strings, mouseX + 4, mouseY - 8);
        GlStateManager.func_227627_O_();
    }

    @Override
    public boolean mouseClickedMain(double mouseX, double mouseY, int mouseButton) {
        super.mouseClickedMain(mouseX, mouseY, mouseButton);
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.timer == 0) {
            PacketHandler.INSTANCE.sendToServer((Object)new GUIPermissionRequestPacket(this.network.getNetworkID(), this.player.func_110124_au()));
        }
        if (this.timer % 2 == 0) {
            this.refreshPages(this.network.getSetting(NetworkSettings.NETWORK_PLAYERS));
            if (FluxNetworks.PROXY.getFeedback(true) == EnumFeedbackInfo.SUCCESS) {
                if (this.hasActivePopup()) {
                    Optional<NetworkMember> n = this.elements.stream().filter(f -> f.getPlayerUUID().equals(this.selectedPlayer.getPlayerUUID())).findFirst();
                    if (n.isPresent()) {
                        this.selectedPlayer = n.get();
                        this.openPopUp(new PopUpUserEdit(this, this.player, this.connector));
                    } else {
                        this.closePopUp();
                    }
                }
                FluxNetworks.PROXY.setFeedback(EnumFeedbackInfo.NONE, true);
            }
        }
        ++this.timer;
        this.timer %= 40;
    }

    @Override
    protected void sortGrids(GuiTabPages.SortType sortType) {
        this.elements.sort(Comparator.comparing(NetworkMember::getAccessPermission).thenComparing(NetworkMember::getCachedName));
        this.refreshCurrentPageInternal();
    }
}

