/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.jei;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.client.jei.CreatingFluxRecipeType;
import sonar.fluxnetworks.common.registry.RegistryBlocks;
import sonar.fluxnetworks.common.registry.RegistryItems;

public class CreatingFluxRecipeCategory
implements IRecipeCategory<CreatingFluxRecipeType> {
    public static final ResourceLocation CATEGORY_UUID = new ResourceLocation("fluxnetworks", "creatingflux");
    public static final ResourceLocation TEXTURES = new ResourceLocation("fluxnetworks", "textures/gui/gui_creating_flux_recipe.png");
    public IGuiHelper guiHelper;
    public IDrawable background;
    public ITickTimer timer;

    public CreatingFluxRecipeCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.background = guiHelper.createDrawable(TEXTURES, 0, -20, 128, 80);
        this.timer = guiHelper.createTickTimer(60, 320, false);
    }

    public static List<CreatingFluxRecipeType> getRecipes() {
        ArrayList<CreatingFluxRecipeType> recipes = new ArrayList<CreatingFluxRecipeType>();
        recipes.add(new CreatingFluxRecipeType(Blocks.field_150357_h, Blocks.field_150343_Z, new ItemStack((IItemProvider)Items.field_151137_ax), new ItemStack((IItemProvider)RegistryItems.FLUX)));
        recipes.add(new CreatingFluxRecipeType(RegistryBlocks.FLUX_BLOCK, Blocks.field_150343_Z, new ItemStack((IItemProvider)Items.field_151137_ax), new ItemStack((IItemProvider)RegistryItems.FLUX)));
        return recipes;
    }

    public static List<ItemStack> getCatalysts() {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)RegistryItems.FLUX)});
    }

    public ResourceLocation getUid() {
        return CATEGORY_UUID;
    }

    public Class<? extends CreatingFluxRecipeType> getRecipeClass() {
        return CreatingFluxRecipeType.class;
    }

    public String getTitle() {
        return FluxTranslate.JEI_CREATING_FLUX.t();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(CreatingFluxRecipeType recipe, IIngredients iIngredients) {
        iIngredients.setInput(VanillaTypes.ITEM, (Object)recipe.getInput());
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, CreatingFluxRecipeType recipe, IIngredients iIngredients) {
        IGuiItemStackGroup guiItemStacks = iRecipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 8, 24);
        guiItemStacks.init(1, false, 102, 24);
        guiItemStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
        guiItemStacks.set(1, (List)iIngredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public List<String> getTooltipStrings(CreatingFluxRecipeType recipe, double mouseX, double mouseY) {
        if (mouseX > 40.0 && mouseX < 80.0 && mouseY < 64.0) {
            return Lists.newArrayList((Object[])new String[]{"Y+2 = " + recipe.getCrusher().getBlock().func_200291_n().func_150254_d(), "Y+1 = " + recipe.getInput().func_200301_q().func_150254_d(), "Y+0 = " + recipe.getBase().getBlock().func_200291_n().func_150254_d()});
        }
        return Collections.emptyList();
    }

    public void draw(CreatingFluxRecipeType recipe, double mouseX, double mouseY) {
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        MatrixStack stack = new MatrixStack();
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        stack.func_227860_a_();
        int value = this.timer.getValue();
        double offset = (float)(value > 160 ? 160 - (value - 160) : value) / 10.0f;
        stack.func_227861_a_(52.0, 10.0 + offset, 128.0);
        stack.func_227862_a_(16.0f, 16.0f, 16.0f);
        stack.func_227863_a_(new Quaternion(30.0f, 45.0f, 0.0f, true));
        dispatcher.renderBlock(recipe.getCrusher().func_176223_P(), stack, (IRenderTypeBuffer)buffer, 0xF000F0, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
        stack.func_227865_b_();
        stack.func_227860_a_();
        stack.func_227861_a_(52.0, 40.0, 96.0);
        stack.func_227862_a_(16.0f, 16.0f, 16.0f);
        stack.func_227863_a_(new Quaternion(30.0f, 45.0f, 0.0f, true));
        dispatcher.renderBlock(recipe.getBase().func_176223_P(), stack, (IRenderTypeBuffer)buffer, 0xF000F0, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
        stack.func_227865_b_();
        stack.func_227860_a_();
        stack.func_227861_a_(63.0, 36.0, 112.0);
        stack.func_227862_a_(16.0f, -16.0f, 16.0f);
        ItemStack toDisplay = value > 160 ? recipe.getOutput() : recipe.getInput();
        stack.func_227863_a_(new Quaternion(toDisplay.func_77973_b() instanceof BlockItem ? 30.0f : 0.0f, -90.0f + 180.0f * ((float)value / (float)this.timer.getMaxValue()), 0.0f, true));
        itemRenderer.func_229110_a_(toDisplay, ItemCameraTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.field_229196_a_, stack, (IRenderTypeBuffer)buffer);
        stack.func_227865_b_();
        buffer.func_228461_a_();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String help = FluxTranslate.JEI_LEFT_CLICK.format(recipe.getCrusher().getBlock().func_200291_n().func_150254_d());
        fontRenderer.func_211126_b(help, (float)(64 - fontRenderer.func_78256_a(help) / 2), 68.0f, 0x404040);
    }
}

