/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.mui;

import icyllis.modernui.graphics.math.TextAlign;
import icyllis.modernui.gui.master.Canvas;
import icyllis.modernui.gui.master.IDrawable;
import icyllis.modernui.gui.master.IHost;
import icyllis.modernui.gui.master.IWidget;
import icyllis.modernui.gui.master.Locator;
import icyllis.modernui.gui.master.Module;
import icyllis.modernui.gui.math.Color3i;
import icyllis.modernui.gui.widget.NumberInputField;
import icyllis.modernui.gui.widget.SlidingToggleButton;
import icyllis.modernui.gui.widget.TextField;
import javax.annotation.Nonnull;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.client.mui.NavigationHome;
import sonar.fluxnetworks.common.core.FluxUtils;
import sonar.fluxnetworks.common.tileentity.TileFluxCore;

public class FluxTileHome
extends Module {
    private final TileFluxCore tileEntity;
    private TextField.Frame nameDeco;
    private TextField.Frame priorityDeco;
    private TextField.Frame limitDeco;

    protected FluxTileHome(@Nonnull TileFluxCore tileEntity) {
        this.tileEntity = tileEntity;
        this.addDrawable(new Background());
        TextField nameField = new TextField.Builder().setWidth(144.0f).setHeight(12.0f).setLocator(new Locator(-72.0f, -52.0f)).build((IHost)this);
        this.nameDeco = new TextField.Frame(nameField, FluxTranslate.NAME.t() + ":", -1);
        nameField.setMaxStringLength(24);
        nameField.setText(tileEntity.getCustomName());
        nameField.setDecoration(f -> this.nameDeco);
        nameField.setListener(this::changeName, false);
        this.addWidget((IWidget)nameField);
        NumberInputField priorityField = new NumberInputField((IHost)this, new TextField.Builder().setWidth(144.0f).setHeight(12.0f).setLocator(new Locator(-72.0f, -35.0f)));
        this.priorityDeco = new TextField.Frame((TextField)priorityField, FluxTranslate.PRIORITY.t() + ":", -1);
        priorityField.setLimit(-10000L, 10000L);
        priorityField.setText(String.valueOf(tileEntity.priority));
        priorityField.setDecoration(f -> this.priorityDeco);
        priorityField.setNumberListener(this::changePriority, true);
        this.addWidget((IWidget)priorityField);
        NumberInputField limitField = new NumberInputField((IHost)this, new TextField.Builder().setWidth(144.0f).setHeight(12.0f).setLocator(new Locator(-72.0f, -18.0f)));
        this.limitDeco = new TextField.Frame((TextField)limitField, FluxTranslate.TRANSFER_LIMIT.t() + ":", -1);
        limitField.setLimit(0L, Math.min(tileEntity.getMaxTransferLimit(), 1000000000L));
        limitField.setText(String.valueOf(tileEntity.limit));
        limitField.setDecoration(f -> this.limitDeco);
        limitField.setNumberListener(this::changeLimit, true);
        this.addWidget((IWidget)limitField);
        SlidingToggleButton surgeToggle = new SlidingToggleButton.Builder(-2147038967, 0x40808080, 4).setLocator(new Locator(47.0f, 38.0f)).build((IHost)this).buildCallback(tileEntity.surgeMode, this::changeSurgeMode);
        this.addWidget((IWidget)surgeToggle);
        SlidingToggleButton unlimitedToggle = new SlidingToggleButton.Builder(-2137998855, 0x40808080, 4).setLocator(new Locator(47.0f, 50.0f)).build((IHost)this).buildCallback(tileEntity.disableLimit, this::changeUnlimitedMode);
        this.addWidget((IWidget)unlimitedToggle);
        this.updateDecoColor();
    }

    public void tick(int ticks) {
        super.tick(ticks);
        if ((ticks & 0xF) == 0) {
            this.updateDecoColor();
        }
    }

    private void changeName(@Nonnull TextField field) {
        this.tileEntity.customName = field.getText();
        this.tileEntity.sendTilePacketToServer((byte)0);
    }

    private void changePriority(@Nonnull NumberInputField field) {
        this.tileEntity.priority = field.getIntegerFromText();
        this.tileEntity.sendTilePacketToServer((byte)1);
    }

    private void changeLimit(@Nonnull NumberInputField field) {
        this.tileEntity.limit = field.getLongFromText();
        this.tileEntity.sendTilePacketToServer((byte)2);
    }

    private void changeSurgeMode(boolean on) {
        this.tileEntity.surgeMode = on;
        this.tileEntity.sendTilePacketToServer((byte)3);
    }

    private void changeUnlimitedMode(boolean on) {
        this.tileEntity.disableLimit = on;
        this.tileEntity.sendTilePacketToServer((byte)4);
    }

    private void updateDecoColor() {
        int color = NavigationHome.network.getSetting(NetworkSettings.NETWORK_COLOR);
        this.nameDeco.setColor(color |= 0xFF000000);
        this.priorityDeco.setColor(color);
        this.limitDeco.setColor(color);
    }

    private class Background
    implements IDrawable {
        private float x1;
        private float y1;
        private float r;
        private float g;
        private float b;

        public Background() {
            this.updateInfo();
        }

        public void draw(@Nonnull Canvas canvas, float v) {
            canvas.resetColor();
            canvas.setTextAlign(TextAlign.LEFT);
            canvas.drawText(FluxUtils.getTransferInfo(FluxTileHome.this.tileEntity.getConnectionType(), NavigationHome.network.getSetting(NetworkSettings.NETWORK_ENERGY), FluxTileHome.this.tileEntity.getChange()), this.x1 + 28.0f, this.y1 + 8.0f);
            canvas.drawText((FluxTileHome.this.tileEntity.getConnectionType().isStorage() ? FluxTranslate.ENERGY.t() : FluxTranslate.BUFFER.t()) + ": " + TextFormatting.BLUE + FluxUtils.format(FluxTileHome.this.tileEntity.getTransferHandler().getBuffer(), FluxUtils.TypeNumberFormat.COMMAS, NavigationHome.network.getSetting(NetworkSettings.NETWORK_ENERGY), false), this.x1 + 28.0f, this.y1 + 18.0f);
            canvas.drawItemStack(FluxTileHome.this.tileEntity.getDisplayStack(), this.x1 + 9.0f, this.y1 + 10.0f);
            canvas.setRGB(this.r, this.g, this.b);
            canvas.drawText(FluxTranslate.SURGE_MODE.t(), this.x1 + 17.0f, this.y1 + 38.0f);
            canvas.drawText(FluxTranslate.DISABLE_LIMIT.t(), this.x1 + 17.0f, this.y1 + 50.0f);
        }

        public void resize(int width, int height) {
            this.x1 = (float)width / 2.0f - 85.0f;
            this.y1 = (float)height / 2.0f;
        }

        public void tick(int ticks) {
            if ((ticks & 0xF) == 0) {
                this.updateInfo();
            }
        }

        private void updateInfo() {
            int color = NavigationHome.network.getSetting(NetworkSettings.NETWORK_COLOR);
            this.r = Color3i.getRedFrom((int)color);
            this.g = Color3i.getGreenFrom((int)color);
            this.b = Color3i.getBlueFrom((int)color);
        }
    }
}

