/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.mui;

import com.mojang.blaze3d.systems.RenderSystem;
import icyllis.modernui.graphics.math.TextAlign;
import icyllis.modernui.gui.master.Canvas;
import icyllis.modernui.gui.master.IDrawable;
import icyllis.modernui.gui.master.IHost;
import icyllis.modernui.gui.master.Icon;
import icyllis.modernui.gui.master.Locator;
import icyllis.modernui.gui.master.ModuleGroup;
import icyllis.modernui.gui.math.Color3i;
import icyllis.modernui.gui.math.Direction4D;
import icyllis.modernui.gui.widget.TextIconButton;
import icyllis.modernui.system.ConstantsLibrary;
import icyllis.modernui.system.RegistryLibrary;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.gui.EnumNavigationTabs;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.client.mui.FluxTileHome;
import sonar.fluxnetworks.client.mui.NetworkSelection;
import sonar.fluxnetworks.client.mui.WirelessCharging;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.connection.FluxNetworkInvalid;
import sonar.fluxnetworks.common.tileentity.TileFluxCore;

public class NavigationHome
extends ModuleGroup {
    @Nonnull
    public static IFluxNetwork network = FluxNetworkInvalid.INSTANCE;
    private final List<TextIconButton> navigationButtons = new ArrayList<TextIconButton>();
    private final FluxBackground bg;
    private final INetworkConnector connector;

    public NavigationHome(@Nonnull INetworkConnector connector) {
        network = FluxNetworkCache.INSTANCE.getClientNetwork(connector.getNetworkID());
        this.connector = connector;
        this.bg = new FluxBackground();
        this.addDrawable(this.bg);
        for (EnumNavigationTabs tab : EnumNavigationTabs.values()) {
            int id = tab.getId();
            Icon icon = new Icon(ConstantsLibrary.ICONS, (float)((id - 1) * 32) / 512.0f, 0.6875f, (float)(id * 32) / 512.0f, 0.75f, true);
            Locator locator = tab == EnumNavigationTabs.TAB_CREATE ? new Locator(60.0f, -95.0f) : new Locator((float)(id * 18 - 94), -95.0f);
            TextIconButton button = new TextIconButton.Builder(icon, tab.getTranslatedName()).setWidth(16.0f).setHeight(16.0f).setLocator(locator).setModuleId(id).setTextDirection(Direction4D.UP).build((IHost)this).buildCallback(tab == EnumNavigationTabs.TAB_HOME, () -> {
                this.switchChildModule(id);
                if (FluxConfig.enableButtonSound) {
                    this.playSound(RegistryLibrary.BUTTON_CLICK_1);
                }
            });
            this.navigationButtons.add(button);
        }
        this.navigationButtons.forEach(arg_0 -> ((NavigationHome)this).addWidget(arg_0));
        if (connector instanceof TileFluxCore) {
            this.addChildModule(EnumNavigationTabs.TAB_HOME.getId(), () -> new FluxTileHome((TileFluxCore)connector));
        }
        this.addChildModule(EnumNavigationTabs.TAB_SELECTION.getId(), () -> new NetworkSelection(connector));
        this.addChildModule(EnumNavigationTabs.TAB_WIRELESS.getId(), WirelessCharging::new);
        this.switchChildModule(EnumNavigationTabs.TAB_HOME.getId());
    }

    protected void onChildModuleChanged(int id) {
        super.onChildModuleChanged(id);
        this.navigationButtons.forEach(e -> e.onModuleChanged(id));
        if (id == EnumNavigationTabs.TAB_HOME.getId()) {
            this.bg.setRenderNetworkName(true);
        } else {
            this.bg.setRenderNetworkName(false);
        }
    }

    public void tick(int ticks) {
        super.tick(ticks);
        network = FluxNetworkCache.INSTANCE.getClientNetwork(this.connector.getNetworkID());
    }

    private static class FluxBackground
    implements IDrawable {
        private float x1;
        private float x2;
        private float y1;
        private float y2;
        private float r;
        private float g;
        private float b;
        private boolean renderNetworkName = false;

        public FluxBackground() {
            this.updateColor();
        }

        public void draw(@Nonnull Canvas canvas, float v) {
            canvas.setRGBA(0.0f, 0.0f, 0.0f, 0.5f);
            canvas.drawRoundedRect(this.x1, this.y1, this.x2, this.y2, 5.0f);
            canvas.setRGBA(this.r, this.g, this.b, 1.0f);
            canvas.drawRoundedRectFrame(this.x1, this.y1, this.x2, this.y2, 5.0f);
            if (this.renderNetworkName) {
                canvas.setLineAntiAliasing(true);
                canvas.setLineWidth(2.0f);
                canvas.drawOctagonRectFrame(this.x1 + 18.0f, this.y1 + 6.0f, this.x2 - 18.0f, this.y1 + 18.0f, 2.0f);
                canvas.setLineAntiAliasing(false);
                canvas.resetColor();
                canvas.setTextAlign(TextAlign.LEFT);
                canvas.drawText(network.getNetworkName(), this.x1 + 22.0f, this.y1 + 8.0f);
            }
            RenderSystem.enableDepthTest();
            canvas.setZ(300.0);
            canvas.setColor(Color3i.GRAY, 0.2f);
            canvas.drawRect(20.0f, 20.0f, 40.0f, 40.0f);
            canvas.setZ(0.0);
            canvas.setColor(Color3i.GOLD, 1.0f);
            canvas.drawRect(30.0f, 20.0f, 50.0f, 40.0f);
            canvas.setZ(300.0);
            canvas.setColor(Color3i.GRAY, 1.0f);
            canvas.drawRect(60.0f, 20.0f, 80.0f, 40.0f);
            canvas.setZ(0.0);
            canvas.setColor(Color3i.GOLD, 0.2f);
            canvas.drawRect(70.0f, 20.0f, 90.0f, 40.0f);
            RenderSystem.disableDepthTest();
        }

        public void resize(int width, int height) {
            this.x1 = (float)width / 2.0f - 85.0f;
            this.x2 = this.x1 + 170.0f;
            this.y1 = (float)height / 2.0f - 77.0f;
            this.y2 = this.y1 + 170.0f;
        }

        public void tick(int ticks) {
            if ((ticks & 0xF) == 0) {
                this.updateColor();
            }
        }

        private void updateColor() {
            int color = network.getSetting(NetworkSettings.NETWORK_COLOR);
            this.r = Color3i.getRedFrom((int)color);
            this.g = Color3i.getGreenFrom((int)color);
            this.b = Color3i.getBlueFrom((int)color);
        }

        public void setRenderNetworkName(boolean renderNetworkName) {
            this.renderNetworkName = renderNetworkName;
        }
    }
}

