/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.mui;

import icyllis.modernui.graphics.math.TextAlign;
import icyllis.modernui.gui.master.Canvas;
import icyllis.modernui.gui.master.IHost;
import icyllis.modernui.gui.master.IWidget;
import icyllis.modernui.gui.master.Locator;
import icyllis.modernui.gui.master.Module;
import icyllis.modernui.gui.math.Color3i;
import icyllis.modernui.gui.scroll.IScrollHost;
import icyllis.modernui.gui.scroll.MultiPageScrollPanel;
import icyllis.modernui.gui.scroll.UniformScrollEntry;
import icyllis.modernui.gui.scroll.UniformScrollGroup;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.client.mui.NavigationHome;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.TilePacket;
import sonar.fluxnetworks.common.network.TilePacketEnum;
import sonar.fluxnetworks.common.network.TilePacketHandler;

public class NetworkSelection
extends Module {
    protected NetworkSelection(INetworkConnector connector) {
        this.addWidget((IWidget)new Panel((IHost)this, connector));
    }

    private static class Group
    extends UniformScrollGroup<Entry> {
        private final INetworkConnector connector;

        public Group(IScrollHost window, INetworkConnector connector) {
            super(window, 12);
            this.connector = connector;
            this.entries.addAll(FluxNetworkCache.INSTANCE.getAllClientNetworks().stream().map(f -> new Entry(window, (IFluxNetwork)f)).collect(Collectors.toList()));
            this.height = this.entries.size() * this.entryHeight;
        }

        public void locate(float px, float py) {
            super.locate(px, py);
            int i = 0;
            for (Entry entry : this.entries) {
                float cy = py + (float)(i * this.entryHeight);
                entry.locate(px, cy);
                ++i;
            }
        }

        private class Entry
        extends UniformScrollEntry {
            private final IFluxNetwork network;

            public Entry(IScrollHost window, IFluxNetwork network) {
                super(window, 146.0f, 12.0f);
                this.network = network;
            }

            protected void onDraw(@Nonnull Canvas canvas, float time) {
                canvas.setLineAntiAliasing(true);
                canvas.setLineWidth(2.0f);
                int color = this.network.getSetting(NetworkSettings.NETWORK_COLOR);
                float factor = NavigationHome.network.getNetworkID() == this.network.getNetworkID() ? 1.0f : (this.isMouseHovered() ? 0.85f : 0.7f);
                canvas.setRGBA(Color3i.getRedFrom((int)color) * factor, Color3i.getGreenFrom((int)color) * factor, Color3i.getBlueFrom((int)color) * factor, 1.0f);
                canvas.drawOctagonRectFrame(this.x1, this.y1 + 1.0f, this.x2, this.y2 - 1.0f, 2.0f);
                canvas.setLineAntiAliasing(false);
                factor = factor * factor * factor;
                canvas.setRGB(factor, factor, factor);
                canvas.setTextAlign(TextAlign.LEFT);
                canvas.drawText(this.network.getNetworkName(), this.x1 + 4.0f, this.y1 + 2.0f);
            }

            protected boolean onMouseLeftClick(double mouseX, double mouseY) {
                if (NavigationHome.network.getNetworkID() != this.network.getNetworkID() && Group.this.connector instanceof IFluxConnector) {
                    PacketHandler.INSTANCE.sendToServer((Object)new TilePacket(TilePacketEnum.SET_NETWORK, TilePacketHandler.getSetNetworkPacket(this.network.getNetworkID(), ""), ((IFluxConnector)Group.this.connector).getCoords()));
                    return true;
                }
                return false;
            }
        }
    }

    private static class Panel
    extends MultiPageScrollPanel<Group.Entry, Group> {
        public Panel(IHost host, INetworkConnector connector) {
            super(host, new MultiPageScrollPanel.Builder(30).setWidth(162.0f).setHeight(132.0f).setLocator(new Locator(-81.0f, -59.0f)), panel -> new Group((IScrollHost)panel, connector));
        }

        protected void onDraw(@Nonnull Canvas canvas, float time) {
            super.onDraw(canvas, time);
            canvas.resetColor();
            canvas.setTextAlign(TextAlign.RIGHT);
            String a = FluxTranslate.TOTAL.t() + ": " + this.allEntries.size();
            canvas.drawText(a, this.x2 - 12.0f, this.y1 - 11.0f);
        }
    }
}

