/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection.handler;

import java.util.Objects;
import net.minecraft.util.Direction;
import sonar.fluxnetworks.api.network.IFluxTransfer;
import sonar.fluxnetworks.common.connection.handler.AbstractPlugHandler;
import sonar.fluxnetworks.common.connection.transfer.SidedTransfers;
import sonar.fluxnetworks.common.tileentity.TileFluxPlug;

public class FluxPlugHandler
extends AbstractPlugHandler<TileFluxPlug> {
    public SidedTransfers transfers;
    public long addedExternally;

    public FluxPlugHandler(TileFluxPlug fluxPlug) {
        super(fluxPlug);
        this.transfers = new SidedTransfers(fluxPlug);
    }

    @Override
    public void onStartCycle() {
        super.onStartCycle();
        this.transfers.getTransfers().stream().filter(Objects::nonNull).forEach(IFluxTransfer::onStartCycle);
    }

    @Override
    public void onEndCycle() {
        super.onEndCycle();
        this.transfers.getTransfers().stream().filter(Objects::nonNull).forEach(IFluxTransfer::onEndCycle);
        this.change = this.addedExternally;
        this.addedExternally = 0L;
    }

    @Override
    public long addEnergy(long amount, Direction dir, boolean simulate) {
        if (this.getNetwork().isInvalid()) {
            return 0L;
        }
        IFluxTransfer transfer = this.transfers.getTransfer(dir);
        if (transfer != null) {
            long a = this.addEnergyToBuffer(amount, simulate);
            if (!simulate) {
                transfer.onEnergyRemoved(a);
                this.addedExternally += a;
            }
            return a;
        }
        return 0L;
    }

    @Override
    public void updateTransfers(Direction ... faces) {
        this.transfers.updateTransfers(faces);
    }
}

