/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.core;

import net.minecraft.util.Direction;
import net.minecraftforge.energy.IEnergyStorage;
import sonar.fluxnetworks.api.energy.IFNEnergyStorage;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.tiles.IFluxPoint;
import sonar.fluxnetworks.common.tileentity.TileFluxPlug;

public class DefaultEnergyWrapper
implements IEnergyStorage,
IFNEnergyStorage {
    public IFluxConnector tileEntity;
    public Direction side;

    public DefaultEnergyWrapper(IFluxConnector tileEntity, Direction side) {
        this.tileEntity = tileEntity;
        this.side = side;
    }

    @Override
    public long receiveEnergyL(long maxReceive, boolean simulate) {
        return this.tileEntity instanceof TileFluxPlug ? ((TileFluxPlug)this.tileEntity).addPhantomEnergyToNetwork(this.side, maxReceive, simulate) : 0L;
    }

    @Override
    public long extractEnergyL(long maxExtract, boolean simulate) {
        return 0L;
    }

    @Override
    public long getEnergyStoredL() {
        return this.tileEntity instanceof IFluxPoint ? Long.MAX_VALUE : 0L;
    }

    @Override
    public long getMaxEnergyStoredL() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean canExtractL() {
        return this.tileEntity.getConnectionType().canRemoveEnergy();
    }

    @Override
    public boolean canReceiveL() {
        return this.tileEntity.getConnectionType().canAddEnergy();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return (int)this.receiveEnergyL(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return (int)this.extractEnergyL(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return (int)Math.min(this.getEnergyStoredL(), Integer.MAX_VALUE);
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(this.getMaxEnergyStoredL(), Integer.MAX_VALUE);
    }

    public boolean canExtract() {
        return this.canExtractL();
    }

    public boolean canReceive() {
        return this.canReceiveL();
    }
}

